/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.item;

import com.raiiiden.warborn.client.renderer.armor.WarbornGenericArmorRenderer;
import com.raiiiden.warborn.common.network.ModNetworking;
import com.raiiiden.warborn.common.object.capability.BackpackCapabilityProvider;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class WarbornArmorItem
extends ArmorItem
implements GeoItem,
ICurioItem {
    private static final int MAX_STACK_SIZE = 100;
    private static final int MAX_SLOTS = 4;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final String armorType;

    public WarbornArmorItem(ArmorMaterial armorMaterial, ArmorItem.Type type, Item.Properties properties, String armorType) {
        super(armorMaterial, type, properties.m_41487_(1));
        this.armorType = armorType;
    }

    public boolean m_142095_() {
        return true;
    }

    private static boolean isChestplateItem(ItemStack stack) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        return id != null && id.m_135815_().toLowerCase().contains("chestplate");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_142207_(ItemStack chestplate, Slot slot, ClickAction action, Player player) {
        ItemStack toAdd;
        int actuallyAdded;
        if (!(chestplate.m_41720_() instanceof WarbornArmorItem) || !WarbornArmorItem.isChestplateItem(chestplate)) {
            return false;
        }
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack slotStack = slot.m_7993_();
        if (slotStack.m_41619_()) {
            if (!player.m_6144_()) return false;
            Optional<ItemStack> extracted = WarbornArmorItem.removeItem(chestplate);
            if (!extracted.isPresent()) return false;
            ItemStack result = extracted.get();
            slot.m_5852_(result);
            this.playRemoveOneSound((Entity)player);
            return true;
        }
        if (!slotStack.m_41720_().m_142095_()) {
            return false;
        }
        int canAdd = WarbornArmorItem.getAvailableSpace(chestplate, slotStack);
        if (canAdd <= 0 || (actuallyAdded = WarbornArmorItem.addItems(chestplate, toAdd = slotStack.m_255036_(Math.min(canAdd, slotStack.m_41613_())))) <= 0) return false;
        slotStack.m_41774_(actuallyAdded);
        if (slotStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        }
        this.playInsertSound((Entity)player);
        return true;
    }

    public boolean m_142305_(ItemStack chestplate, ItemStack itemBeingMoved, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (!(chestplate.m_41720_() instanceof WarbornArmorItem) || !WarbornArmorItem.isChestplateItem(chestplate)) {
            return false;
        }
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (itemBeingMoved.m_41619_()) {
            WarbornArmorItem.removeItem(chestplate).ifPresent(removed -> {
                access.m_142104_(removed);
                this.playRemoveOneSound((Entity)player);
            });
            return true;
        }
        if (!itemBeingMoved.m_41720_().m_142095_()) {
            return false;
        }
        int canAdd = WarbornArmorItem.getAvailableSpace(chestplate, itemBeingMoved);
        if (canAdd <= 0) {
            return false;
        }
        ItemStack toAdd = itemBeingMoved.m_255036_(Math.min(canAdd, itemBeingMoved.m_41613_()));
        int added = WarbornArmorItem.addItems(chestplate, toAdd);
        if (added > 0) {
            itemBeingMoved.m_41774_(added);
            access.m_142104_(itemBeingMoved.m_41619_() ? ItemStack.f_41583_ : itemBeingMoved);
            this.playInsertSound((Entity)player);
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        if (!WarbornArmorItem.isChestplateItem(stack)) {
            return Optional.empty();
        }
        List<ItemStack> contents = WarbornArmorItem.getContents(stack).limit(4L).toList();
        NonNullList result = NonNullList.m_122779_();
        result.addAll(contents);
        int totalWeight = contents.stream().mapToInt(ItemStack::m_41613_).sum();
        return Optional.of(new BundleTooltip(result, totalWeight));
    }

    private static int getTotalStoredItems(ItemStack chestplate) {
        CompoundTag tag = chestplate.m_41783_();
        if (tag == null || !tag.m_128441_("Items")) {
            return 0;
        }
        int total = 0;
        ListTag items = tag.m_128437_("Items", 10);
        for (int i = 0; i < items.size(); ++i) {
            total += ItemStack.m_41712_((CompoundTag)items.m_128728_(i)).m_41613_();
        }
        return total;
    }

    public static int getAvailableSpace(ItemStack chestplate, ItemStack stackToAdd) {
        if (WarbornArmorItem.isArmor(stackToAdd)) {
            return 0;
        }
        CompoundTag tag = chestplate.m_41784_();
        ListTag items = tag.m_128437_("Items", 10);
        int totalStored = 0;
        int matchingStackSpace = 0;
        for (int i = 0; i < items.size(); ++i) {
            ItemStack existing = ItemStack.m_41712_((CompoundTag)items.m_128728_(i));
            totalStored += existing.m_41613_();
            if (!ItemStack.m_150942_((ItemStack)existing, (ItemStack)stackToAdd)) continue;
            matchingStackSpace += 100 - existing.m_41613_();
        }
        int totalSpace = 400;
        int remainingSpace = totalSpace - totalStored;
        if (items.size() < 4) {
            remainingSpace = Math.max(remainingSpace, 100);
        }
        return Math.min(remainingSpace, stackToAdd.m_41613_());
    }

    public static int addItems(ItemStack chestplate, ItemStack stackToAdd) {
        if (stackToAdd.m_41619_() || !stackToAdd.m_41720_().m_142095_()) {
            return 0;
        }
        if (WarbornArmorItem.isArmor(stackToAdd)) {
            return 0;
        }
        CompoundTag tag = chestplate.m_41784_();
        ListTag items = tag.m_128437_("Items", 10);
        if (items.size() >= 4) {
            if (!items.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_).anyMatch(s -> ItemStack.m_150942_((ItemStack)s, (ItemStack)stackToAdd))) {
                return 0;
            }
        }
        int remaining = stackToAdd.m_41613_();
        int added = 0;
        for (int i = 0; i < items.size() && remaining > 0; ++i) {
            int spaceInStack;
            int toAdd;
            CompoundTag itemTag = items.m_128728_(i);
            ItemStack existing = ItemStack.m_41712_((CompoundTag)itemTag);
            if (!ItemStack.m_150942_((ItemStack)existing, (ItemStack)stackToAdd) || (toAdd = Math.min(remaining, spaceInStack = 100 - existing.m_41613_())) <= 0) continue;
            existing.m_41769_(toAdd);
            CompoundTag updatedTag = new CompoundTag();
            updatedTag.m_128359_("id", BuiltInRegistries.f_257033_.m_7981_((Object)existing.m_41720_()).toString());
            updatedTag.m_128405_("Count", existing.m_41613_());
            if (existing.m_41782_()) {
                updatedTag.m_128365_("tag", (Tag)existing.m_41783_());
            }
            items.set(i, (Tag)updatedTag);
            added += toAdd;
            remaining -= toAdd;
        }
        while (remaining > 0 && items.size() < 4) {
            int toAdd = Math.min(remaining, 100);
            ItemStack newStack = stackToAdd.m_255036_(toAdd);
            CompoundTag newTag = new CompoundTag();
            newTag.m_128359_("id", BuiltInRegistries.f_257033_.m_7981_((Object)newStack.m_41720_()).toString());
            newTag.m_128405_("Count", newStack.m_41613_());
            if (newStack.m_41782_()) {
                newTag.m_128365_("tag", (Tag)newStack.m_41783_());
            }
            items.add((Object)newTag);
            added += toAdd;
            remaining -= toAdd;
        }
        if (added > 0) {
            tag.m_128365_("Items", (Tag)items);
        }
        return added;
    }

    public static Optional<ItemStack> removeItem(ItemStack chestplate) {
        if (!WarbornArmorItem.isChestplateItem(chestplate)) {
            return Optional.empty();
        }
        CompoundTag tag = chestplate.m_41784_();
        if (!tag.m_128441_("Items")) {
            return Optional.empty();
        }
        ListTag items = tag.m_128437_("Items", 10);
        if (items.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag itemTag = items.m_128728_(items.size() - 1);
        ItemStack removed = ItemStack.m_41712_((CompoundTag)itemTag);
        items.remove(items.size() - 1);
        if (items.isEmpty()) {
            chestplate.m_41749_("Items");
        } else {
            tag.m_128365_("Items", (Tag)items);
        }
        return Optional.of(removed);
    }

    private static Stream<ItemStack> getContents(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("Items")) {
            return Stream.empty();
        }
        ListTag items = tag.m_128437_("Items", 10);
        return items.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    private static boolean isArmor(ItemStack stack) {
        return stack.m_41720_() instanceof ArmorItem;
    }

    public boolean m_142522_(ItemStack stack) {
        return WarbornArmorItem.isChestplateItem(stack) && WarbornArmorItem.getContents(stack).findAny().isPresent();
    }

    public int m_142158_(ItemStack stack) {
        if (!WarbornArmorItem.isChestplateItem(stack)) {
            return super.m_142158_(stack);
        }
        long count = WarbornArmorItem.getContents(stack).count();
        return Math.min(13, 1 + (int)(12.0 * ((double)count / 4.0)));
    }

    public int m_142159_(ItemStack stack) {
        return WarbornArmorItem.isChestplateItem(stack) ? BAR_COLOR : super.m_142159_(stack);
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public String getArmorType() {
        return this.armorType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        EquipmentSlot slot;
        ItemStack stack = player.m_21120_(hand);
        if (WarbornArmorItem.isChestplateItem(stack) && player.m_6144_()) {
            if (!level.f_46443_ && stack.m_41783_() != null && stack.m_41783_().m_128441_("Items")) {
                ListTag items = stack.m_41783_().m_128437_("Items", 10);
                for (int i = 0; i < items.size(); ++i) {
                    player.m_36176_(ItemStack.m_41712_((CompoundTag)items.m_128728_(i)), true);
                }
                stack.m_41749_("Items");
                this.playDropContentsSound((Entity)player);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (level.f_46443_ && WarbornArmorItem.isBackpackItem(stack)) {
                ModNetworking.openBackpack(stack);
            }
        }
        if (player.m_6844_(slot = this.m_40402_()).m_41619_()) {
            player.m_8061_(slot, stack.m_41777_());
            stack.m_41764_(0);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    private void playDropContentsSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new WarbornGenericArmorRenderer(WarbornArmorItem.this);
                }
                this.renderer.prepForRender((Entity)entity, stack, slot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> PlayState.CONTINUE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return WarbornArmorItem.isBackpackItem(stack) ? new BackpackCapabilityProvider(stack) : super.initCapabilities(stack, nbt);
    }

    public static boolean isBackpackItem(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        return id != null && id.m_135815_().toLowerCase().contains("backpack");
    }
}

