/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.warborn.common.network;

import com.raiiiden.warborn.common.object.BackpackMenu;
import com.raiiiden.warborn.common.object.capability.BackpackItemStackHandler;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class OpenBackpackPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ItemStack backpackItem;

    public OpenBackpackPacket(ItemStack backpackItem) {
        this.backpackItem = backpackItem;
    }

    public OpenBackpackPacket(FriendlyByteBuf buf) {
        this.backpackItem = buf.m_130267_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130055_(this.backpackItem);
    }

    public static void handle(OpenBackpackPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            final ItemStack actualBackpack = OpenBackpackPacket.findActualBackpack(player, packet.backpackItem);
            if (actualBackpack.m_41619_()) {
                return;
            }
            actualBackpack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                BackpackItemStackHandler backpackHandler;
                if (handler instanceof BackpackItemStackHandler && (backpackHandler = (BackpackItemStackHandler)((Object)((Object)handler))).isUninitialized()) {
                    LOGGER.warn("Backpack capability is uninitialized (0 slots). Open manually once to sync NBT.");
                }
            });
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237115_((String)"menu.warborn.backpack");
                }

                public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
                    return new BackpackMenu(containerId, inventory, actualBackpack);
                }
            }, buf -> buf.m_130055_(actualBackpack));
        });
        ctx.get().setPacketHandled(true);
    }

    private static ItemStack findActualBackpack(ServerPlayer player, ItemStack packetBackpack) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)packetBackpack)) continue;
            return stack;
        }
        for (ItemStack stack : player.m_6168_()) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)packetBackpack)) continue;
            return stack;
        }
        LazyOptional curiosOpt = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (curiosOpt.isPresent()) {
            ICuriosItemHandler curios = (ICuriosItemHandler)curiosOpt.resolve().get();
            for (Map.Entry entry : curios.getCurios().entrySet()) {
                ICurioStacksHandler handler = (ICurioStacksHandler)entry.getValue();
                for (int i = 0; i < handler.getStacks().getSlots(); ++i) {
                    ItemStack stack = handler.getStacks().getStackInSlot(i);
                    if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)packetBackpack)) continue;
                    return stack;
                }
            }
        }
        return ItemStack.f_41583_;
    }
}

