/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record SSplashParticle(BlockPos blockPos, int color) {
    public static void encode(SSplashParticle message, FriendlyByteBuf buf) {
        buf.m_130064_(message.blockPos);
        buf.writeInt(message.color);
    }

    public static SSplashParticle decode(FriendlyByteBuf buf) {
        return new SSplashParticle(buf.m_130135_(), buf.readInt());
    }

    public static void handle(SSplashParticle message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> SSplashParticle.handle(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle(SSplashParticle message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        if (player == null || level == null) {
            return;
        }
        int color = message.color;
        RandomSource randomsource = level.f_46441_;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Vec3 vec3 = Vec3.m_82539_((Vec3i)message.blockPos);
        SimpleParticleType particleoptions = ParticleTypes.f_123806_;
        for (int k2 = 0; k2 < 100; ++k2) {
            double d13 = randomsource.m_188500_() * 4.0;
            double d19 = randomsource.m_188500_() * Math.PI * 2.0;
            double d25 = Math.cos(d19) * d13;
            double d30 = 0.01 + randomsource.m_188500_() * 0.5;
            double d31 = Math.sin(d19) * d13;
            Particle particle1 = particleEngine.m_107370_((ParticleOptions)particleoptions, vec3.f_82479_ + d25 * 0.1, vec3.f_82480_ + 0.3, vec3.f_82481_ + d31 * 0.1, d25, d30, d31);
            if (particle1 == null) continue;
            float f2 = 0.75f + randomsource.m_188501_() * 0.25f;
            particle1.m_107253_(r * f2, g * f2, b * f2);
            particle1.m_107268_((float)d13);
        }
    }
}

