/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.item.throwable.flash;

import com.google.gson.annotations.SerializedName;
import me.xjqsh.lrtactical.item.throwable.ThrowableData;
import org.jetbrains.annotations.NotNull;

public class StunThrowableData
extends ThrowableData {
    @SerializedName(value="stun")
    private StunData stunData = new StunData();

    @NotNull
    public StunData getStunData() {
        return this.stunData;
    }

    public static class StunData {
        @SerializedName(value="radius")
        private float radius = 24.0f;
        @SerializedName(value="blind")
        private BlindData blind = new BlindData();
        @SerializedName(value="deafened")
        private DeafenedData deafened = new DeafenedData();

        public StunData() {
        }

        public StunData(float radius, BlindData blind, DeafenedData deafened) {
            this.radius = radius;
            this.blind = blind;
            this.deafened = deafened;
        }

        public float getRadius() {
            return this.radius;
        }

        public BlindData getBlind() {
            return this.blind;
        }

        public DeafenedData getDeafened() {
            return this.deafened;
        }

        public int calcBlindDuration(double distance, double angle) {
            int mx = this.blind.getMaxDuration();
            int mn = this.blind.getMinDuration();
            int durationBlinded = (int)Math.round((double)mx - (double)(mx - mn) * (distance / (double)this.radius));
            double maxAngle = this.blind.getMaxAngle();
            double factor = this.blind.getViewAngleFactor();
            return (int)((double)durationBlinded * (1.0 - angle * (1.0 - factor) / maxAngle));
        }

        public int calcDeafenedDuration(double distance) {
            int mx = this.deafened.getMaxDuration();
            int mn = this.deafened.getMinDuration();
            return (int)Math.round((double)mx - (double)(mx - mn) * (distance / (double)this.radius));
        }
    }

    public static class BlindData {
        @SerializedName(value="max_duration")
        private int maxDuration = 200;
        @SerializedName(value="min_duration")
        private int minDuration = 10;
        @SerializedName(value="max_angle")
        private double maxAngle = 85.0;
        @SerializedName(value="view_angle_factor")
        private double viewAngleFactor = 0.5;

        public BlindData() {
        }

        public BlindData(int maxDuration, int minDuration, double maxAngle, double viewAngleFactor) {
            this.maxDuration = maxDuration;
            this.minDuration = minDuration;
            this.maxAngle = maxAngle;
            this.viewAngleFactor = viewAngleFactor;
        }

        public int getMaxDuration() {
            return this.maxDuration;
        }

        public int getMinDuration() {
            return this.minDuration;
        }

        public double getMaxAngle() {
            return this.maxAngle;
        }

        public double getViewAngleFactor() {
            return this.viewAngleFactor;
        }
    }

    public static class DeafenedData {
        @SerializedName(value="max_duration")
        private int maxDuration = 200;
        @SerializedName(value="min_duration")
        private int minDuration = 10;

        public DeafenedData() {
        }

        public DeafenedData(int maxDuration, int minDuration) {
            this.maxDuration = maxDuration;
            this.minDuration = minDuration;
        }

        public int getMaxDuration() {
            return this.maxDuration;
        }

        public int getMinDuration() {
            return this.minDuration;
        }
    }
}

