/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.entity;

import me.xjqsh.lrtactical.config.CommonConfig;
import me.xjqsh.lrtactical.entity.ThrowableItemEntity;
import me.xjqsh.lrtactical.util.CustomExplosion;
import me.xjqsh.lrtactical.util.ParticleUtil;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PlayMessages;

public class GrenadeEntity
extends ThrowableItemEntity {
    public static EntityType<GrenadeEntity> TYPE = EntityType.Builder.m_20704_(GrenadeEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).setCustomClientFactory(GrenadeEntity::new).m_20699_(0.3f, 0.3f).m_20716_().m_20698_().m_20719_().m_20712_("grenade_entity");
    private double damage = 18.0;
    private float radius = 4.5f;
    private boolean destroyBlocks = false;
    private double screenShakeTime = 20.0;
    private double screenShakeAmplitude = 50.0;

    public GrenadeEntity(LivingEntity entity, Level level, int lifeTime) {
        super(TYPE, entity, level, lifeTime);
    }

    public GrenadeEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        super(TYPE, level);
    }

    public GrenadeEntity(EntityType<GrenadeEntity> type, Level level) {
        super(type, level);
    }

    @Override
    public void onDeath(HitResult hitResult) {
        Vec3 pos;
        Vec3 vec3 = pos = hitResult == null ? this.m_20182_() : this.m_20182_().m_165921_(hitResult.m_82450_(), 0.8);
        if (!this.m_9236_().m_5776_()) {
            Explosion.BlockInteraction type = this.isDestroyBlocks() && (Boolean)CommonConfig.GRENADE_EXPLOSION_BLOCK_DAMAGE.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
            CustomExplosion explosion = new CustomExplosion(this.m_9236_(), (Entity)this, this.getDamage(), this.getRadius(), type);
            explosion.setScreenShakeAmplitude(this.screenShakeAmplitude);
            explosion.setScreenShakeTime(this.screenShakeTime);
            if (ForgeEventFactory.onExplosionStart((Level)this.m_9236_(), (Explosion)explosion)) {
                return;
            }
            explosion.m_46061_();
            explosion.m_46075_(true);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                double x = pos.m_7096_();
                double y = pos.m_7098_();
                double z = pos.m_7094_();
                ParticleUtil.sendParticle(level2, ParticleTypes.f_123747_, x, y + 0.5, z, 50, 0.2, 0.2, 0.2, 20.0, true);
                ParticleUtil.sendParticle(level2, ParticleTypes.f_123812_, x, y + 1.0, z, 5, 0.7, 0.7, 0.7, 1.0, true);
            }
        }
        super.onDeath(hitResult);
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public boolean isDestroyBlocks() {
        return this.destroyBlocks;
    }

    public void setDestroyBlocks(boolean destroyBlocks) {
        this.destroyBlocks = destroyBlocks;
    }

    public double getScreenShakeTime() {
        return this.screenShakeTime;
    }

    public void setScreenShakeTime(double screenShakeTime) {
        this.screenShakeTime = screenShakeTime;
    }

    public double getScreenShakeAmplitude() {
        return this.screenShakeAmplitude;
    }

    public void setScreenShakeAmplitude(double screenShakeAmplitude) {
        this.screenShakeAmplitude = screenShakeAmplitude;
    }
}

