/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.capability;

import java.util.ArrayList;
import java.util.List;
import me.xjqsh.lrtactical.api.LrTacticalAPI;
import me.xjqsh.lrtactical.api.item.ICustomItem;
import me.xjqsh.lrtactical.api.item.IMeleeWeapon;
import me.xjqsh.lrtactical.api.melee.MeleeAction;
import me.xjqsh.lrtactical.item.melee.CombatData;
import me.xjqsh.lrtactical.network.NetworkHandler;
import me.xjqsh.lrtactical.network.message.CMeleeAttackRequest;
import me.xjqsh.lrtactical.network.message.CPrepareMeleeAttack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;

@AutoRegisterCapability
public class CombatProperties {
    public static final ResourceLocation ID = new ResourceLocation("lrtactical", "combat_data");
    private final List<DelayTask> delayedActions = new ArrayList<DelayTask>();
    private ItemStack lastItem = ItemStack.f_41583_;
    private final Player entity;
    private int coolDownTick = 0;
    private int lastMaxTick = 0;
    private int lastSelected = 0;
    private int drawingTick = 0;
    private boolean preparingAttack = false;

    public CombatProperties(Player entity) {
        this.entity = entity;
    }

    public int getCoolDownTick() {
        return this.coolDownTick;
    }

    public int getLastMaxTick() {
        return this.lastMaxTick;
    }

    public void setCoolDownTick(int coolDownTick) {
        this.coolDownTick = coolDownTick;
    }

    public void tick() {
        Item item = this.entity.m_21205_().m_41720_();
        if (item instanceof ICustomItem) {
            ICustomItem customItem = (ICustomItem)item;
            if (this.lastSelected != this.entity.m_150109_().f_35977_) {
                this.lastSelected = this.entity.m_150109_().f_35977_;
                this.reset(customItem, this.lastItem);
            } else if (!customItem.isSame(this.lastItem, this.entity.m_21205_())) {
                this.reset(customItem, this.lastItem);
            }
        } else if (!ItemStack.m_41728_((ItemStack)this.lastItem, (ItemStack)this.entity.m_21205_())) {
            this.lastItem = this.entity.m_21205_().m_41777_();
        }
        if (this.coolDownTick > 0) {
            IMeleeWeapon weapon;
            --this.coolDownTick;
            item = this.entity.m_21205_().m_41720_();
            if (item instanceof IMeleeWeapon && !(weapon = (IMeleeWeapon)item).canSprintingAttack()) {
                this.entity.m_6858_(false);
            }
            if (this.coolDownTick <= 0) {
                this.preparingAttack = false;
            }
        }
        if (this.entity.m_9236_().m_5776_()) {
            for (DelayTask task : this.delayedActions) {
                if (!task.tick()) continue;
                task.perform(this.entity);
            }
            this.delayedActions.removeIf(DelayTask::expired);
        }
        if (this.drawingTick > 0) {
            --this.drawingTick;
        }
    }

    public boolean isDrawing() {
        return this.drawingTick > 0;
    }

    public void reset(ICustomItem customItem, ItemStack last) {
        this.lastItem = this.entity.m_21205_().m_41777_();
        int newCoolDown = customItem.getDrawTime(this.entity.m_21205_());
        Item item = last.m_41720_();
        if (item instanceof ICustomItem) {
            ICustomItem customItem1 = (ICustomItem)item;
            newCoolDown += customItem1.getPutAwayTime(last);
        }
        this.coolDownTick = newCoolDown;
        this.lastMaxTick = newCoolDown;
        this.drawingTick = newCoolDown;
        this.preparingAttack = false;
    }

    public boolean preAttack(MeleeAction action, Vec3 origin, Vec3 direction) {
        ItemStack stack = this.entity.m_21205_();
        Item item = this.entity.m_21205_().m_41720_();
        if (item instanceof IMeleeWeapon) {
            IMeleeWeapon weapon = (IMeleeWeapon)item;
            if (this.coolDownTick <= 0) {
                if (!weapon.canAttack(this.entity, stack, action)) {
                    return false;
                }
                this.lastMaxTick = this.coolDownTick = weapon.getAttackCoolDown(stack, action);
                if (!this.entity.m_9236_().m_5776_()) {
                    this.preparingAttack = true;
                    this.coolDownTick = Math.max(0, this.coolDownTick - 1);
                } else {
                    NetworkHandler.CHANNEL.sendToServer((Object)new CPrepareMeleeAttack(action, origin, direction));
                    int delay = weapon.getAttackDelay(this.entity, stack, action);
                    DelayAttack attack = new DelayAttack(delay, stack, action);
                    if (attack.getDelay() == 0) {
                        attack.perform(this.entity);
                    } else {
                        this.delayedActions.add(attack);
                    }
                    CombatData.MeleeMovement moveInfo = weapon.getAttackMovement(this.entity, stack, action);
                    if (moveInfo != null) {
                        DelayMove move = new DelayMove(moveInfo.getDelay(), moveInfo.getSpeed(), stack);
                        if (move.getDelay() == 0) {
                            move.perform(this.entity);
                        } else {
                            this.delayedActions.add(move);
                        }
                    }
                    LrTacticalAPI.getMeleeDisplay(stack).ifPresent(display -> {
                        if (display.getSounds().containsKey(action.getId())) {
                            this.entity.m_9236_().m_7785_(origin.f_82479_, origin.f_82480_, origin.f_82481_, SoundEvent.m_262824_((ResourceLocation)display.getSounds().get(action.getId())), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                        }
                    });
                }
                return true;
            }
        }
        return false;
    }

    public void postAttack(MeleeAction action, List<Entity> entities) {
        ItemStack stack = this.entity.m_21205_();
        if (!this.preparingAttack) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof IMeleeWeapon) {
            IMeleeWeapon weapon = (IMeleeWeapon)item;
            weapon.attack(this.entity, stack, action, entities);
        }
        this.preparingAttack = false;
    }

    public static abstract class DelayTask {
        protected int delay;

        protected DelayTask(int delay) {
            this.delay = delay;
        }

        abstract void perform(Player var1);

        public boolean tick() {
            --this.delay;
            return this.delay <= 0;
        }

        public boolean expired() {
            return this.delay <= 0;
        }

        public int getDelay() {
            return this.delay;
        }
    }

    public static class DelayAttack
    extends DelayTask {
        private final ItemStack stack;
        private final MeleeAction action;

        DelayAttack(int delay, ItemStack stack, MeleeAction action) {
            super(delay);
            this.action = action;
            this.stack = stack;
        }

        @Override
        public void perform(Player player) {
            IMeleeWeapon weapon;
            Item item = this.stack.m_41720_();
            if (item instanceof IMeleeWeapon && (weapon = (IMeleeWeapon)item).isSame(this.stack, player.m_21205_())) {
                List<Entity> entities = weapon.collectTargets(player, this.stack, this.action, player.m_146892_(), player.m_20154_());
                NetworkHandler.CHANNEL.sendToServer((Object)new CMeleeAttackRequest(this.action, entities));
            }
        }
    }

    public static class DelayMove
    extends DelayTask {
        private final ItemStack stack;
        private final double speed;

        DelayMove(int delay, double speed, ItemStack stack) {
            super(delay);
            this.stack = stack;
            this.speed = speed;
        }

        @Override
        public void perform(Player player) {
            IMeleeWeapon weapon;
            Item item = this.stack.m_41720_();
            if (item instanceof IMeleeWeapon && (weapon = (IMeleeWeapon)item).isSame(this.stack, player.m_21205_())) {
                double factor = player.m_20096_() ? 1.0 : 0.5;
                Vec3 motion = player.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(factor * this.speed);
                player.m_246865_(motion);
            }
        }
    }
}

