/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.api.collision;

import net.minecraft.world.phys.AABB;
import org.joml.Intersectionf;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record OBB(Vector3f center, Vector3f extents, Quaternionf rotation) {
    public void setCenter(Vector3f center) {
        this.center.set((Vector3fc)center);
    }

    public void setExtents(Vector3f extents) {
        this.extents.set((Vector3fc)extents);
    }

    public void setRotation(Quaternionf rotation) {
        this.rotation.set((Quaternionfc)rotation);
    }

    public Vector3f[] getVertices() {
        Vector3f[] vertices = new Vector3f[8];
        Vector3f[] localVertices = new Vector3f[]{new Vector3f(-this.extents.x, -this.extents.y, -this.extents.z), new Vector3f(this.extents.x, -this.extents.y, -this.extents.z), new Vector3f(this.extents.x, this.extents.y, -this.extents.z), new Vector3f(-this.extents.x, this.extents.y, -this.extents.z), new Vector3f(-this.extents.x, -this.extents.y, this.extents.z), new Vector3f(this.extents.x, -this.extents.y, this.extents.z), new Vector3f(this.extents.x, this.extents.y, this.extents.z), new Vector3f(-this.extents.x, this.extents.y, this.extents.z)};
        for (int i = 0; i < 8; ++i) {
            Vector3f vertex = localVertices[i];
            vertex.rotate((Quaternionfc)this.rotation);
            vertex.add((Vector3fc)this.center);
            vertices[i] = vertex;
        }
        return vertices;
    }

    public Vector3f[] getAxes() {
        Vector3f[] axes = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        this.rotation.transform(axes[0]);
        this.rotation.transform(axes[1]);
        this.rotation.transform(axes[2]);
        return axes;
    }

    public static boolean isColliding(OBB obb, OBB other) {
        Vector3f[] axes1 = obb.getAxes();
        Vector3f[] axes2 = other.getAxes();
        return Intersectionf.testObOb((Vector3f)obb.center(), (Vector3f)axes1[0], (Vector3f)axes1[1], (Vector3f)axes1[2], (Vector3f)obb.extents(), (Vector3f)other.center(), (Vector3f)axes2[0], (Vector3f)axes2[1], (Vector3f)axes2[2], (Vector3f)other.extents());
    }

    public static boolean isColliding(OBB obb, AABB aabb) {
        Vector3f obbCenter = obb.center();
        Vector3f[] obbAxes = obb.getAxes();
        Vector3f obbHalfExtents = obb.extents();
        Vector3f aabbCenter = aabb.m_82399_().m_252839_();
        Vector3f aabbHalfExtents = new Vector3f((float)(aabb.m_82362_() / 2.0), (float)(aabb.m_82376_() / 2.0), (float)(aabb.m_82385_() / 2.0));
        return Intersectionf.testObOb((float)obbCenter.x, (float)obbCenter.y, (float)obbCenter.z, (float)obbAxes[0].x, (float)obbAxes[0].y, (float)obbAxes[0].z, (float)obbAxes[1].x, (float)obbAxes[1].y, (float)obbAxes[1].z, (float)obbAxes[2].x, (float)obbAxes[2].y, (float)obbAxes[2].z, (float)obbHalfExtents.x, (float)obbHalfExtents.y, (float)obbHalfExtents.z, (float)aabbCenter.x, (float)aabbCenter.y, (float)aabbCenter.z, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)aabbHalfExtents.x, (float)aabbHalfExtents.y, (float)aabbHalfExtents.z);
    }

    public boolean interactsWithAABB(AABB aabb) {
        return OBB.isColliding(this, aabb);
    }

    public static Vector3f getClosestPointOBB(Vector3f point, OBB obb) {
        Vector3f nearP = new Vector3f((Vector3fc)obb.center());
        Vector3f dist = point.sub((Vector3fc)nearP, new Vector3f());
        float[] extents = new float[]{obb.extents().x, obb.extents().y, obb.extents().z};
        Vector3f[] axes = obb.getAxes();
        for (int i = 0; i < 3; ++i) {
            float distance = dist.dot((Vector3fc)axes[i]);
            distance = Math.clamp((float)distance, (float)(-extents[i]), (float)extents[i]);
            nearP.x += distance * axes[i].x;
            nearP.y += distance * axes[i].y;
            nearP.z += distance * axes[i].z;
        }
        return nearP;
    }
}

