/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.client.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamresourceful.resourcefullib.client.scissor.ClosingScissorBox;
import com.teamresourceful.resourcefullib.client.screens.AbstractContainerCursorScreen;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.chipped.client.screens.RenderWindowWidget;
import earth.terrarium.chipped.client.screens.SlotWidget;
import earth.terrarium.chipped.common.menus.WorkbenchMenu;
import earth.terrarium.chipped.common.network.NetworkHandler;
import earth.terrarium.chipped.common.network.ServerboundCraftPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WorkbenchScreen
extends AbstractContainerCursorScreen<WorkbenchMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("chipped", "textures/gui/container/workbench.png");
    private static final ResourceLocation SINGLE_BLOCK_BUTTON = new ResourceLocation("chipped", "textures/gui/sprites/single_block_button.png");
    private static final ResourceLocation HORIZONTAL_BLOCKS_BUTTON = new ResourceLocation("chipped", "textures/gui/sprites/horizontal_blocks_button.png");
    private static final ResourceLocation VERTICAL_BLOCKS_BUTTON = new ResourceLocation("chipped", "textures/gui/sprites/vertical_blocks_button.png");
    private static final ResourceLocation TWO_BY_TWO_BUTTON = new ResourceLocation("chipped", "textures/gui/sprites/two_by_two_button.png");
    private static final ResourceLocation BUTTON = new ResourceLocation("chipped", "textures/gui/sprites/button.png");
    public static final int YELLOW = 0x70FFFF00;
    public static final int BLUE = 0x700000FF;
    public static final int DARK_GRAY = 0x70000000;
    private static final Component PREVIEW_TEXT = Component.m_237115_((String)"text.chipped.preview");
    private static final Component CRAFT_TEXT = Component.m_237115_((String)"text.chipped.craft");
    private static final Component CRAFT_ALL_TEXT = Component.m_237115_((String)"text.chipped.craft_all");
    private static final Component SINGLE_TEXT = Component.m_237115_((String)"text.chipped.single");
    private static final Component HORIZONTAL_TEXT = Component.m_237115_((String)"text.chipped.horizontal");
    private static final Component VERTICAL_TEXT = Component.m_237115_((String)"text.chipped.vertical");
    private static final Component TWO_BY_TWO_TEXT = Component.m_237115_((String)"text.chipped.two_by_two");
    protected EditBox searchBox;
    protected double scrollAmount;
    protected RenderWindowWidget renderWindow;
    protected GridLayout grid;
    protected final List<SlotWidget> slotWidgets = new ArrayList<SlotWidget>();
    protected RenderWindowWidget.Mode mode = RenderWindowWidget.Mode.TWO_BY_TWO;

    public WorkbenchScreen(WorkbenchMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.f_97726_ = 256;
        this.f_97727_ = 256;
        this.f_97728_ = 88;
        this.f_97729_ = 14;
        this.f_97731_ = 155;
        this.f_97730_ = 88;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_97735_ + 105, this.f_97736_ + 27, 115, 11, (Component)Component.m_237119_()));
        this.searchBox.m_94202_(-1);
        this.searchBox.m_94205_(-1);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94199_(50);
        this.searchBox.m_94151_(this::onSearchBarChanged);
        this.searchBox.m_94186_(false);
        ((ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 9, this.f_97736_ + 121, 18, 18, 0, 0, 18, SINGLE_BLOCK_BUTTON, 18, 36, button -> {
            this.mode = RenderWindowWidget.Mode.SINGLE_BLOCK;
        }))).m_257544_(Tooltip.m_257550_((Component)SINGLE_TEXT));
        ((ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 27, this.f_97736_ + 121, 18, 18, 0, 0, 18, HORIZONTAL_BLOCKS_BUTTON, 18, 36, button -> {
            this.mode = RenderWindowWidget.Mode.HORIZONTAL_BLOCK;
        }))).m_257544_(Tooltip.m_257550_((Component)HORIZONTAL_TEXT));
        ((ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 45, this.f_97736_ + 121, 18, 18, 0, 0, 18, VERTICAL_BLOCKS_BUTTON, 18, 36, button -> {
            this.mode = RenderWindowWidget.Mode.VERTICAL_BLOCK;
        }))).m_257544_(Tooltip.m_257550_((Component)VERTICAL_TEXT));
        ((ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 63, this.f_97736_ + 121, 18, 18, 0, 0, 18, TWO_BY_TWO_BUTTON, 18, 36, button -> {
            this.mode = RenderWindowWidget.Mode.TWO_BY_TWO;
        }))).m_257544_(Tooltip.m_257550_((Component)TWO_BY_TWO_TEXT));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 9, this.f_97736_ + 101, 72, 18, 0, 0, 18, BUTTON, 72, 36, button -> this.craft()));
        this.addSlotWidgets();
        this.renderWindow = (RenderWindowWidget)this.m_142416_((GuiEventListener)new RenderWindowWidget(this.f_97735_ + 9, this.f_97736_ + 26, 72, 72, this::mode, this::state));
    }

    private void addSlotWidgets() {
        this.slotWidgets.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.slotWidgets.clear();
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        this.grid = new GridLayout(left + 85, top + 41);
        List<ItemStack> results = ((WorkbenchMenu)this.f_97732_).results();
        int rows = Math.max(6, Mth.m_14167_((float)((float)results.size() / 9.0f)));
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < rows; ++j) {
                int index = i + j * 9;
                ItemStack stack = results.size() > index ? results.get(index) : ItemStack.f_41583_;
                SlotWidget slot = (SlotWidget)this.m_7787_((GuiEventListener)new SlotWidget(stack, (WorkbenchMenu)this.f_97732_, top + 40, top + 141));
                this.grid.m_264379_((LayoutElement)slot, j, i);
                this.slotWidgets.add(slot);
            }
        }
        this.grid.m_264036_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        this.grid.m_253211_(top + 41 - (int)this.scrollAmount);
        try (ClosingScissorBox ignored = RenderUtils.createScissorBox((Minecraft)Objects.requireNonNull(this.f_96541_), (PoseStack)graphics.m_280168_(), (int)(left + 84), (int)(top + 40), (int)163, (int)109);){
            for (SlotWidget widget : this.slotWidgets) {
                widget.m_87963_(graphics, mouseX, mouseY, partialTick);
            }
        }
        for (SlotWidget widget : this.slotWidgets) {
            widget.renderTooltip(graphics, this.f_96547_, mouseX, mouseY);
        }
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280163_(TEXTURE, left, top, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
        graphics.m_280614_(this.f_96547_, PREVIEW_TEXT, left + 11, top + 14, 0x404040, false);
        graphics.m_280653_(this.f_96547_, WorkbenchScreen.m_96638_() ? CRAFT_ALL_TEXT : CRAFT_TEXT, left + 45, top + 106, 0x404040);
        ItemStack stack = ((WorkbenchMenu)this.f_97732_).chosenStack();
        if (stack.m_41619_()) {
            return;
        }
        ItemStack selectedStack = ((WorkbenchMenu)this.f_97732_).selectedStack();
        if (selectedStack.m_41619_()) {
            return;
        }
        for (Slot slot : ((WorkbenchMenu)this.f_97732_).f_38839_) {
            if (selectedStack.equals(slot.m_7993_()) || ItemStack.m_41656_((ItemStack)selectedStack, (ItemStack)slot.m_7993_()) && WorkbenchScreen.m_96638_()) {
                graphics.m_280509_(slot.f_40220_ + left - 1, slot.f_40221_ + top - 1, slot.f_40220_ + left + 17, slot.f_40221_ + top + 17, 0x70FFFF00);
                continue;
            }
            if (ItemStack.m_41656_((ItemStack)selectedStack, (ItemStack)slot.m_7993_())) {
                graphics.m_280509_(slot.f_40220_ + left - 1, slot.f_40221_ + top - 1, slot.f_40220_ + left + 17, slot.f_40221_ + top + 17, 0x700000FF);
                continue;
            }
            graphics.m_280509_(slot.f_40220_ + left - 1, slot.f_40221_ + top - 1, slot.f_40220_ + left + 17, slot.f_40221_ + top + 17, 0x70000000);
        }
    }

    private void onSearchBarChanged(String filter) {
        this.scrollAmount = 0.0;
        ((WorkbenchMenu)this.f_97732_).updateResults(filter);
        this.addSlotWidgets();
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.m_6597_(slot, slotId, mouseButton, type);
        this.addSlotWidgets();
        this.searchBox.m_94186_(!((WorkbenchMenu)this.f_97732_).selectedStack().m_41619_());
        this.scrollAmount = 0.0;
        ((WorkbenchMenu)this.f_97732_).setFilter(this.searchBox.m_94155_());
    }

    public void m_181908_() {
        super.m_181908_();
        this.searchBox.m_94120_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (this.m_7222_() == this.searchBox) {
            return this.searchBox.m_7933_(keyCode, scanCode, modifiers) || this.searchBox.m_94204_() || super.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.m_7222_() != this.searchBox) {
            this.m_7522_(null);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (((WorkbenchMenu)this.f_97732_).results().size() <= 54) {
            return false;
        }
        this.setScrollAmount(this.scrollAmount - delta * 16.0 / 2.0);
        return true;
    }

    protected void setScrollAmount(double amount) {
        int rows = Mth.m_14167_((float)((float)((WorkbenchMenu)this.f_97732_).results().size() / 9.0f));
        this.scrollAmount = Mth.m_14008_((double)amount, (double)0.0, (double)(rows * 18 - 108));
    }

    public void craft() {
        if (!((WorkbenchMenu)this.f_97732_).selectedStack().m_41619_()) {
            NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundCraftPacket(((WorkbenchMenu)this.f_97732_).chosenStack(), WorkbenchScreen.m_96638_()));
            Objects.requireNonNull(this.f_96541_).m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12494_, (float)1.0f, (float)1.0f));
            ((WorkbenchMenu)this.f_97732_).reset();
            this.addSlotWidgets();
            this.scrollAmount = 0.0;
            this.m_7522_(null);
        }
    }

    public RenderWindowWidget.Mode mode() {
        return this.mode;
    }

    public BlockState state() {
        Block block = Block.m_49814_((Item)((WorkbenchMenu)this.f_97732_).chosenStack().m_41720_());
        if (block instanceof IronBarsBlock) {
            return (BlockState)((BlockState)block.m_49966_().m_61124_((Property)IronBarsBlock.f_52309_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)IronBarsBlock.f_52311_, (Comparable)Boolean.valueOf(true));
        }
        BlockState state = block.m_49966_();
        return state.m_60795_() ? null : state;
    }
}

