/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.client.animation.statemachine;

import com.tacz.guns.api.client.animation.statemachine.AnimationState;
import com.tacz.guns.api.client.animation.statemachine.AnimationStateContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;

public class LuaAnimationState<T extends AnimationStateContext>
implements AnimationState<T> {
    @Nonnull
    private final LuaTable stateTable;
    @Nonnull
    private final LuaTable scriptTable;
    @Nullable
    private final LuaFunction updateFunction;
    @Nullable
    private final LuaFunction enterFunction;
    @Nullable
    private final LuaFunction exitFunction;
    @Nullable
    private final LuaFunction transitionFunction;

    LuaAnimationState(@Nonnull LuaTable stateTable, @Nonnull LuaTable scriptTable) {
        this.stateTable = stateTable;
        this.scriptTable = scriptTable;
        this.updateFunction = this.checkLuaFunction("update");
        this.enterFunction = this.checkLuaFunction("entry");
        this.exitFunction = this.checkLuaFunction("exit");
        this.transitionFunction = this.checkLuaFunction("transition");
    }

    @Override
    public void update(T context) {
        if (this.updateFunction != null) {
            this.updateFunction.call((LuaValue)this.scriptTable, CoerceJavaToLua.coerce(context));
        }
    }

    @Override
    public void entryAction(T context) {
        if (this.enterFunction != null) {
            this.enterFunction.call((LuaValue)this.scriptTable, CoerceJavaToLua.coerce(context));
        }
    }

    @Override
    public void exitAction(T context) {
        if (this.exitFunction != null) {
            this.exitFunction.call((LuaValue)this.scriptTable, CoerceJavaToLua.coerce(context));
        }
    }

    @Override
    public AnimationState<T> transition(T context, String condition) {
        if (this.transitionFunction != null) {
            LuaString conditionToLua = LuaString.valueOf((String)condition);
            LuaValue nextStateTable = this.transitionFunction.call((LuaValue)this.scriptTable, CoerceJavaToLua.coerce(context), (LuaValue)conditionToLua);
            if (nextStateTable.istable()) {
                return new LuaAnimationState<T>((LuaTable)nextStateTable, this.scriptTable);
            }
            if (nextStateTable.isnil()) {
                return null;
            }
            throw new LuaError("the return of function 'transition' must be table or nil");
        }
        return null;
    }

    private LuaFunction checkLuaFunction(String funcName) {
        LuaValue value = this.stateTable.get(funcName);
        if (value.isfunction()) {
            return (LuaFunction)value;
        }
        if (value.isnil()) {
            return null;
        }
        throw new LuaError("the type of field '" + funcName + "' must be function or nil");
    }
}

