/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.network;

import com.scarasol.sona.util.SonaMath;
import com.scarasol.zombiekit.entity.mechanics.HeavyMachineGunEntity;
import com.scarasol.zombiekit.entity.mechanics.MortarEntity;
import com.scarasol.zombiekit.init.ZombieKitItems;
import com.scarasol.zombiekit.item.armor.ExoArmor;
import com.scarasol.zombiekit.item.weapon.Flamethrower;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record MouseInputPacket(int type, double value) {
    public static MouseInputPacket decode(FriendlyByteBuf buf) {
        return new MouseInputPacket(buf.readInt(), buf.readDouble());
    }

    public static void encode(MouseInputPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.type);
        buf.writeDouble(msg.value);
    }

    public static void handler(MouseInputPacket msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (msg != null) {
                ((NetworkEvent.Context)context.get()).enqueueWork(() -> MouseInputPacket.lambda$handler$1((Supplier)context, msg));
            }
        });
        context.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handler$1(Supplier context, MouseInputPacket msg) {
        if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isServer()) {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            Entity patt1657$temp = player.m_20202_();
            if (patt1657$temp instanceof HeavyMachineGunEntity) {
                HeavyMachineGunEntity heavyMachineGunEntity = (HeavyMachineGunEntity)patt1657$temp;
                if (msg.type == 0) {
                    heavyMachineGunEntity.setFire(msg.value == 1.0);
                }
            } else {
                Entity patt1931$temp = player.m_20202_();
                if (patt1931$temp instanceof MortarEntity) {
                    MortarEntity mortarEntity = (MortarEntity)patt1931$temp;
                    if (msg.type == 2) {
                        mortarEntity.setAngle((float)((double)mortarEntity.getAngle() + msg.value));
                        boolean flag = player.m_150109_().m_216874_(itemStack -> itemStack.m_150930_((Item)ZombieKitItems.SHOOTING_PARAMETER.get()));
                        if (flag || ExoArmor.numberOfSuit((LivingEntity)player) >= 4 && ExoArmor.getPower(player.m_6844_(EquipmentSlot.CHEST)) > 0) {
                            double x = SonaMath.parabolaXDistanceCalculate((double)(-mortarEntity.getAngle()), (double)3.5);
                            player.m_5661_((Component)Component.m_237113_((String)(Component.m_237110_((String)"gui.zombiekit.mortar.angle", (Object[])new Object[]{Float.valueOf(-mortarEntity.getAngle())}).getString() + Component.m_237110_((String)"gui.zombiekit.mortar.distance", (Object[])new Object[]{Math.round(x)}).getString())), true);
                        } else {
                            player.m_5661_((Component)Component.m_237110_((String)"gui.zombiekit.mortar.angle", (Object[])new Object[]{Float.valueOf(-mortarEntity.getAngle())}), true);
                        }
                    }
                } else {
                    Item patt3125$temp = player.m_21205_().m_41720_();
                    if (patt3125$temp instanceof Flamethrower) {
                        Flamethrower flamethrower = (Flamethrower)patt3125$temp;
                        ItemStack itemStack2 = player.m_21120_(InteractionHand.MAIN_HAND);
                        if (msg.value == 1.0) {
                            if (player.m_9236_().m_46467_() - flamethrower.getReloadTime(itemStack2) > 47L) {
                                flamethrower.putUsing(itemStack2, true);
                                flamethrower.putStartUsingTick(itemStack2, player.m_9236_().m_46467_());
                            }
                        } else {
                            flamethrower.putUsing(itemStack2, false);
                        }
                    }
                }
            }
        }
    }
}

