/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.network;

import com.scarasol.zombiekit.api.MortarLevel;
import com.scarasol.zombiekit.data.LaunchSchedule;
import com.scarasol.zombiekit.init.ZombieKitSounds;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CoverFirePacket {
    private final BlockPos blockPos;

    public CoverFirePacket(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public static CoverFirePacket decode(FriendlyByteBuf buf) {
        return new CoverFirePacket(buf.m_130135_());
    }

    public static void encode(CoverFirePacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.getBlockPos());
    }

    public static void handler(CoverFirePacket msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (msg != null) {
                ((NetworkEvent.Context)context.get()).enqueueWork(() -> CoverFirePacket.lambda$handler$0((Supplier)context, msg));
            }
        });
        context.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handler$0(Supplier context, CoverFirePacket msg) {
        Level level;
        ServerPlayer player;
        if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isServer() && (player = ((NetworkEvent.Context)context.get()).getSender()) != null && (level = player.m_9236_()) instanceof MortarLevel) {
            MortarLevel mortarLevel = (MortarLevel)level;
            if (player.m_21211_().m_150930_(Items.f_151059_)) {
                player.m_5810_();
                player.m_36335_().m_41524_(Items.f_151059_, 100);
            } else if (ForgeRegistries.ITEMS.getKey((Object)player.m_21205_().m_41720_()).toString().equals("superbwarfare:monitor")) {
                if (!player.m_21205_().m_41784_().m_128471_("Using")) {
                    return;
                }
                player.m_36335_().m_41524_(player.m_21205_().m_41720_(), 100);
            }
            level.m_5594_(null, BlockPos.m_274446_((Position)player.m_20182_()), (SoundEvent)ZombieKitSounds.radio_response.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            mortarLevel.getMortarManager().postSchedule(new LaunchSchedule(level.m_46467_(), msg.getBlockPos()));
        }
    }
}

