/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.mixin;

import com.scarasol.zombiekit.api.FixedVehicle;
import com.scarasol.zombiekit.item.api.ModifiableWeapon;
import com.scarasol.zombiekit.item.weapon.Knife;
import com.scarasol.zombiekit.item.weapon.SweepWeapon;
import com.scarasol.zombiekit.item.weapon.parts.BattleParts;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Unique
    private boolean battleEffect;

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Unique
    public void m_146926_(float xRot) {
        FixedVehicle fixedVehicle;
        Entity entity = this.m_20202_();
        if (entity instanceof FixedVehicle && !(fixedVehicle = (FixedVehicle)entity).validXRot(this, xRot)) {
            return;
        }
        super.m_146926_(xRot);
    }

    @Unique
    public void m_146922_(float yRot) {
        FixedVehicle fixedVehicle;
        Entity entity = this.m_20202_();
        if (entity instanceof FixedVehicle && !(fixedVehicle = (FixedVehicle)entity).validYRot(this, yRot)) {
            return;
        }
        super.m_146922_(yRot);
    }

    @Unique
    @OnlyIn(value=Dist.CLIENT)
    public boolean m_20329_(Entity vehicle) {
        if (vehicle instanceof FixedVehicle) {
            FixedVehicle fixedVehicle = (FixedVehicle)vehicle;
            if (this.m_9236_().f_46443_) {
                Minecraft.m_91087_().f_91066_.m_92157_(fixedVehicle.getVehicleCameraType());
            }
        }
        return super.m_20329_(vehicle);
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void onAttackSweepTarget(Entity entity, CallbackInfo ci, float f, float f1, float f2, boolean flag, boolean flag1, float i, boolean flag2, CriticalHitEvent hitResult, boolean flag3, double d0, float f4, boolean flag4, int j, Vec3 vec3, boolean flag5, float f3, Iterator var19, LivingEntity livingentity) {
        ModifiableWeapon modifiableWeapon;
        Item parts;
        ItemStack stack;
        Item item;
        Item item2 = this.m_21205_().m_41720_();
        if (item2 instanceof SweepWeapon) {
            SweepWeapon sweepWeapon = (SweepWeapon)item2;
            sweepWeapon.sweepEffect(livingentity, this, f);
        }
        if (this.battleEffect && (item = (stack = this.m_21205_()).m_41720_()) instanceof ModifiableWeapon && (parts = (modifiableWeapon = (ModifiableWeapon)item).getBattleParts(stack)) instanceof BattleParts) {
            BattleParts battleParts = (BattleParts)parts;
            battleParts.partsEffect(this, livingentity, f);
        }
    }

    @Inject(method={"attack"}, at={@At(value="TAIL")})
    private void onAttackTail(Entity entity, CallbackInfo ci) {
        this.battleEffect = false;
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")})
    private void onAttackHead(Entity entity, CallbackInfo ci) {
        ItemStack stack = this.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof ModifiableWeapon) {
            BattleParts battleParts;
            Item parts;
            ModifiableWeapon modifiableWeapon = (ModifiableWeapon)item;
            if (!this.m_9236_().m_5776_() && (parts = modifiableWeapon.getBattleParts(stack)) instanceof BattleParts && (battleParts = (BattleParts)parts).draw()) {
                this.battleEffect = true;
            }
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void onAttackMainTarget(Entity entity, CallbackInfo ci, float f, float f1, float f2, boolean flag, boolean flag1, float i, boolean flag2, CriticalHitEvent hitResult, boolean flag3, double d0, float f4, boolean flag4, int j, Vec3 vec3) {
        if (this.battleEffect && entity instanceof LivingEntity) {
            ModifiableWeapon modifiableWeapon;
            Item parts;
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack stack = this.m_21205_();
            Item item = stack.m_41720_();
            if (item instanceof ModifiableWeapon && (parts = (modifiableWeapon = (ModifiableWeapon)item).getBattleParts(stack)) instanceof BattleParts) {
                BattleParts battleParts = (BattleParts)parts;
                ((BattleParts)parts).partsEffect(this, livingEntity, f);
            }
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private void onAttackMainTargetWithKnife(Entity entity, CallbackInfo ci) {
        ItemStack stack = this.m_21205_();
        if (stack.m_41720_() instanceof Knife) {
            entity.getPersistentData().m_128379_("CancelKnockback", true);
        }
    }
}

