/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.manager;

import com.scarasol.zombiekit.api.MortarLevel;
import com.scarasol.zombiekit.data.LaunchSchedule;
import com.scarasol.zombiekit.entity.ai.goal.MortarUsingGoal;
import com.scarasol.zombiekit.entity.mechanics.MortarEntity;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ChunkPos;

public class MortarManager {
    private final Set<MortarUsingGoal<? extends MortarEntity>> artillerymen = new LinkedHashSet<MortarUsingGoal<? extends MortarEntity>>();
    private final Set<LaunchSchedule> onGoingSchedules = new LinkedHashSet<LaunchSchedule>();
    private final MortarLevel level;

    public MortarManager(MortarLevel level) {
        this.level = level;
    }

    public void subscribe(MortarUsingGoal<? extends MortarEntity> artilleryman, long gameTime) {
        this.checkGoal();
        this.artillerymen.add(artilleryman);
        this.checkSchedules(gameTime);
        this.syncSchedule(artilleryman);
    }

    public void unsubscribe(MortarUsingGoal<? extends MortarEntity> artilleryman, long gameTime) {
        this.checkGoal();
        this.artillerymen.remove(artilleryman);
        this.checkSchedules(gameTime);
    }

    public void checkGoal() {
        new ArrayList<MortarUsingGoal<? extends MortarEntity>>(this.artillerymen).stream().filter(e -> e.getMob().m_9236_().m_6815_(e.getMob().m_19879_()) == null).forEach(this::abortGoal);
    }

    public void syncSchedule(MortarUsingGoal<? extends Mob> artilleryman) {
        artilleryman.syncSchedule(new ArrayList<LaunchSchedule>(this.onGoingSchedules));
    }

    public void checkSchedules(long gameTime) {
        new ArrayList<LaunchSchedule>(this.onGoingSchedules).stream().filter(launchSchedule -> launchSchedule.isTimeout(gameTime)).forEach(this::abortSchedule);
    }

    public void postSchedule(LaunchSchedule launchSchedule) {
        this.checkSchedules(launchSchedule.getCreateTime());
        if (this.onGoingSchedules.add(launchSchedule)) {
            this.addForceLoadRange(launchSchedule);
            this.broadcastSchedule(launchSchedule);
        }
    }

    public void broadcastSchedule(LaunchSchedule launchSchedule) {
        this.artillerymen.forEach(goal -> goal.pushSchedule(launchSchedule));
    }

    public void abortSchedule(LaunchSchedule launchSchedule) {
        this.onGoingSchedules.remove(launchSchedule);
        this.endForceLoadRange(launchSchedule);
    }

    public void abortGoal(MortarUsingGoal<? extends Mob> artilleryman) {
        this.artillerymen.remove(artilleryman);
    }

    public void addForceLoadRange(LaunchSchedule launchSchedule) {
        ChunkPos chunkPos = new ChunkPos(launchSchedule.getCoordinate());
        this.level.getServerChunkCache().f_8325_.m_143145_().m_140840_(TicketType.f_9445_, chunkPos, 15, (Object)chunkPos);
    }

    public void endForceLoadRange(LaunchSchedule launchSchedule) {
        ChunkPos chunkPos = new ChunkPos(launchSchedule.getCoordinate());
        this.level.getServerChunkCache().f_8325_.m_143145_().m_140849_(TicketType.f_9445_, chunkPos, 15, (Object)chunkPos);
    }
}

