/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.item.weapon.parts;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.scarasol.zombiekit.item.api.Parts;
import com.scarasol.zombiekit.item.weapon.SweepWeapon;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;

public class GripParts
extends Item
implements Parts {
    private final int partsLevel;
    private final Material material;
    private final UUID attackDamage = UUID.fromString("398DCA24-D818-EE96-04E8-1FB7A6806016");
    private final UUID attackSpeed = UUID.fromString("06939188-AA3B-5C4F-B50D-3E72E3382673");
    private final UUID attackRange = UUID.fromString("ABF05969-A291-B7EF-45BD-E970D417EA19");

    public GripParts(Item.Properties properties, int partsLevel, Material material) {
        super(properties);
        this.partsLevel = partsLevel;
        this.material = material;
    }

    public void m_7373_(@NotNull ItemStack itemstack, Level world, @NotNull List<Component> list, @NotNull TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"item.zombiekit.general_parts.description"));
        if (this.material == Material.LIGHT_WEIGHTED) {
            list.add((Component)Component.m_237115_((String)("item.zombiekit.light_weighted_parts.description_" + (this.getPartsLevel() + 1))));
        } else if (this.material == Material.HEAVY_WEIGHTED) {
            list.add((Component)Component.m_237115_((String)("item.zombiekit.heavy_weighted_parts.description_" + (this.getPartsLevel() + 1))));
        } else {
            list.add((Component)Component.m_237115_((String)("item.zombiekit.extend_weighted_parts.description_" + (this.getPartsLevel() + 1))));
        }
    }

    @Override
    public int getPartsLevel() {
        return this.partsLevel;
    }

    @Override
    public Parts.PartsType getPartsType() {
        return Parts.PartsType.GRIP;
    }

    public static boolean unlock(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean canUse(ItemStack itemStack) {
        TieredItem tieredItem;
        Tier tier;
        Item item = itemStack.m_41720_();
        if (item instanceof TieredItem && (tier = (tieredItem = (TieredItem)item).m_43314_()) instanceof Tiers) {
            Tiers tiers = (Tiers)tier;
            if (tiers == Tiers.NETHERITE) {
                return true;
            }
            return this.partsLevel < 2;
        }
        return false;
    }

    public double getAttackSpeed() {
        if (this.material == Material.LIGHT_WEIGHTED) {
            if (this.partsLevel == 0) {
                return 0.1;
            }
            if (this.partsLevel == 1) {
                return 0.2;
            }
            return 0.3;
        }
        if (this.material == Material.EXTEND) {
            return -0.15;
        }
        return -0.1;
    }

    public double getAttackDamage() {
        if (this.material == Material.HEAVY_WEIGHTED) {
            if (this.partsLevel == 0) {
                return 0.1;
            }
            if (this.partsLevel == 1) {
                return 0.15;
            }
            return 0.2;
        }
        if (this.material == Material.EXTEND) {
            return -0.1;
        }
        return -0.05;
    }

    public double getSweepRange() {
        if (this.material == Material.EXTEND) {
            if (this.partsLevel == 0) {
                return 1.2;
            }
            if (this.partsLevel == 1) {
                return 1.35;
            }
            return 1.5;
        }
        return 0.0;
    }

    public float getDurabilityModifier() {
        if (this.partsLevel == 0) {
            return 1.2f;
        }
        if (this.partsLevel == 1) {
            return 1.4f;
        }
        return 1.6f;
    }

    private double getAttackRange() {
        if (this.material == Material.EXTEND) {
            if (this.partsLevel == 0) {
                return 0.1;
            }
            if (this.partsLevel == 1) {
                return 0.175;
            }
            return 0.25;
        }
        return 0.0;
    }

    public Multimap<Attribute, AttributeModifier> getWeaponModifiers(Item item) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(this.attackDamage, "Grip Modifier", this.getAttackDamage(), AttributeModifier.Operation.MULTIPLY_BASE));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(this.attackSpeed, "Grip Modifier", this.getAttackSpeed(), AttributeModifier.Operation.MULTIPLY_BASE));
        double attackRangeModifier = item instanceof SweepWeapon ? this.getAttackRange() * 0.5 : this.getAttackRange();
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(this.attackRange, "Grip Modifier", attackRangeModifier, AttributeModifier.Operation.MULTIPLY_BASE));
        return builder.build();
    }

    public static enum Material {
        LIGHT_WEIGHTED,
        HEAVY_WEIGHTED,
        EXTEND;

    }
}

