/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.item.weapon.parts;

import com.scarasol.sona.util.SonaMath;
import com.scarasol.zombiekit.item.api.DoubleHandWeapon;
import com.scarasol.zombiekit.item.api.ModifiableWeapon;
import com.scarasol.zombiekit.item.api.Parts;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class ChargingParts
extends Item
implements Parts {
    private final int partsLevel;
    private final int chargingTime = 200;

    public ChargingParts(Item.Properties properties, int partsLevel) {
        super(properties);
        this.partsLevel = partsLevel;
    }

    public abstract void partsEffect(LivingEntity var1, LivingEntity var2, float var3);

    public boolean isOnCoolDown(ItemStack itemStack, long currentTime) {
        return currentTime - this.getCooldownTime(itemStack) < (long)this.getChargingTime();
    }

    public int getChargingTime() {
        if (this.partsLevel == 0) {
            return 200;
        }
        if (this.partsLevel == 1) {
            return 180;
        }
        return 160;
    }

    public long getCooldownTime(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof ModifiableWeapon && itemStack.m_41782_()) {
            return itemStack.m_41783_().m_128454_("ReleaseTime");
        }
        return -1L;
    }

    public void setCooldownTime(ItemStack itemStack, long releaseTime) {
        itemStack.m_41784_().m_128356_("ReleaseTime", releaseTime);
    }

    public abstract double getRange();

    @Override
    public int getPartsLevel() {
        return this.partsLevel;
    }

    @Override
    public Parts.PartsType getPartsType() {
        return Parts.PartsType.CHARGING;
    }

    public void attack(ServerLevel serverLevel, LivingEntity attacker, float damage) {
        ItemStack itemStack = attacker.m_21205_();
        if (this.isOnCoolDown(itemStack, serverLevel.m_46467_())) {
            return;
        }
        Vec3 center = attacker.m_20097_().m_252807_();
        this.sweepAttack(attacker);
        this.setCooldownTime(itemStack, serverLevel.m_46467_());
        serverLevel.m_6443_(LivingEntity.class, new AABB(center, center).m_82400_(this.getRange()), target -> this.shouldTakeEffect(attacker, (LivingEntity)target)).forEach(target -> this.partsEffect((LivingEntity)target, attacker, damage));
    }

    public void sweepAttack(LivingEntity attacker) {
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12317_, attacker.m_5720_(), 1.0f, 1.0f);
        double d0 = -Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180)));
        double d1 = Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)));
        Level level = attacker.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, attacker.m_20185_() + d0, attacker.m_20227_(0.5), attacker.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public boolean shouldTakeEffect(LivingEntity attacker, LivingEntity target) {
        Vec3 vec3;
        if (target.equals((Object)attacker)) {
            return false;
        }
        if (!target.m_142582_((Entity)attacker)) {
            return false;
        }
        Vec3 position = attacker.m_20182_();
        Vec3 lookAngle = attacker.m_20252_(1.0f);
        return SonaMath.vectorDegreeCalculate((Vec3)lookAngle, (Vec3)(vec3 = target.m_20182_().m_82546_(position))) < 75.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean unlock(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof TieredItem)) return false;
        TieredItem tieredItem = (TieredItem)item;
        if (itemStack.m_41720_() instanceof DoubleHandWeapon) return true;
        if (tieredItem.m_43314_() != Tiers.NETHERITE) return false;
        return true;
    }

    @Override
    public boolean canUse(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof TieredItem) {
            Tier tier;
            TieredItem tieredItem = (TieredItem)item;
            if ((itemStack.m_41720_() instanceof DoubleHandWeapon || tieredItem.m_43314_() == Tiers.NETHERITE) && (tier = tieredItem.m_43314_()) instanceof Tiers) {
                Tiers tiers = (Tiers)tier;
                if (tiers == Tiers.NETHERITE) {
                    return true;
                }
                return this.partsLevel < 2;
            }
        }
        return false;
    }
}

