/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.item.weapon.parts;

import com.scarasol.sona.init.SonaMobEffects;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.init.ZombieKitDamageTypes;
import com.scarasol.zombiekit.item.weapon.parts.ChargingParts;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BurningChargingParts
extends ChargingParts {
    private final double range = 5.0;

    public BurningChargingParts(Item.Properties properties, int partsLevel) {
        super(properties, partsLevel);
    }

    public void m_7373_(@NotNull ItemStack itemstack, Level world, @NotNull List<Component> list, @NotNull TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"item.zombiekit.general_parts.description"));
        list.add((Component)Component.m_237115_((String)("item.zombiekit.burning_charging_parts.description_" + (this.getPartsLevel() + 1))));
    }

    @Override
    public void partsEffect(LivingEntity target, LivingEntity attacker, float damage) {
        float actualDamage;
        float lostHealth = target.m_21233_() - target.m_21223_();
        int amplifier = target.m_21023_((MobEffect)SonaMobEffects.IGNITION.get()) ? target.m_21124_((MobEffect)SonaMobEffects.IGNITION.get()).m_19564_() : -1;
        int duration = 120;
        int partsLevel = this.getPartsLevel();
        if (partsLevel == 0) {
            amplifier = Math.min(amplifier + 1, 2);
            actualDamage = damage * 0.98f + lostHealth * 0.084f * Math.max(1.0f + damage * 0.04f, 2.5f);
        } else if (partsLevel == 1) {
            amplifier = Math.min(amplifier + 2, 2);
            actualDamage = damage * 1.19f + lostHealth * 0.126f * Math.max(1.0f + damage * 0.04f, 2.5f);
        } else {
            amplifier = Math.min(amplifier + 3, 2);
            actualDamage = damage * 1.4f + lostHealth * 0.168f * Math.max(1.0f + damage * 0.04f, 2.5f);
        }
        target.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.IGNITION.get(), duration, amplifier, false, false));
        target.m_6469_(this.getDamageSource(attacker.m_9236_(), attacker), (float)((double)actualDamage * (Double)CommonConfig.DAMAGE_COEFFICIENT.get()));
        Level level = target.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), 30, 0.2, 0.2, 0.2, 0.1);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), 10, 0.2, 0.2, 0.2, 0.1);
        }
    }

    public DamageSource getDamageSource(Level level, LivingEntity attacker) {
        return ZombieKitDamageTypes.damageSource(level.m_9598_(), (ResourceKey<DamageType>)DamageTypes.f_268631_, (Entity)attacker);
    }

    @Override
    public double getRange() {
        return this.range;
    }
}

