/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.item.weapon.parts;

import com.scarasol.sona.util.SonaLottery;
import com.scarasol.zombiekit.item.api.Parts;
import com.scarasol.zombiekit.item.api.SingleHandWeapon;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;

public abstract class BattleParts
extends Item
implements Parts {
    private final int partsLevel;
    private final SonaLottery lottery;

    public BattleParts(Item.Properties properties, int partsLevel) {
        super(properties);
        this.partsLevel = partsLevel;
        this.lottery = new SonaLottery(100, (int)(this.getPercentage() * 100.0));
    }

    public abstract void partsEffect(LivingEntity var1, LivingEntity var2, float var3);

    @Override
    public int getPartsLevel() {
        return this.partsLevel;
    }

    @Override
    public Parts.PartsType getPartsType() {
        return Parts.PartsType.BATTLE;
    }

    public double getPercentage() {
        if (this.partsLevel == 0) {
            return 0.2;
        }
        if (this.partsLevel == 1) {
            return 0.35;
        }
        return 0.5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean unlock(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof TieredItem)) return false;
        TieredItem tieredItem = (TieredItem)item;
        if (itemStack.m_41720_() instanceof SingleHandWeapon) return true;
        if (tieredItem.m_43314_() != Tiers.NETHERITE) return false;
        return true;
    }

    @Override
    public boolean canUse(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof TieredItem) {
            Tier tier;
            TieredItem tieredItem = (TieredItem)item;
            if ((itemStack.m_41720_() instanceof SingleHandWeapon || tieredItem.m_43314_() == Tiers.NETHERITE) && (tier = tieredItem.m_43314_()) instanceof Tiers) {
                Tiers tiers = (Tiers)tier;
                if (tiers == Tiers.NETHERITE) {
                    return true;
                }
                return this.partsLevel < 2;
            }
        }
        return false;
    }

    public boolean draw() {
        return this.lottery.draw();
    }
}

