/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.scarasol.sona.item.IRustItem;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.init.ZombieKitKeyMappings;
import com.scarasol.zombiekit.item.api.DoubleHandWeapon;
import com.scarasol.zombiekit.item.weapon.parts.GripParts;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;

public class Rake
extends HoeItem
implements IRustItem,
DoubleHandWeapon {
    private Multimap<Attribute, AttributeModifier> weaponModifiers;

    public Rake(Tier tier, int attackDamage, float speed, Item.Properties properties) {
        super(tier, attackDamage, speed, properties);
    }

    public float m_41008_() {
        double damage = this.m_43314_() == Tiers.NETHERITE ? (Double)CommonConfig.NETHERITE_RAKE_DAMAGE.get() : (Double)CommonConfig.RAKE_DAMAGE.get();
        return (float)(damage * 0.5);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        this.initModifier();
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.weaponModifiers : super.m_7167_(equipmentSlot);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, stack));
            Item grip = this.getGripParts(stack);
            if (grip instanceof GripParts) {
                GripParts gripParts = (GripParts)grip;
                builder.putAll(gripParts.getWeaponModifiers((Item)this));
            }
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public void initModifier() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        double damage = this.m_43314_() == Tiers.NETHERITE ? (Double)CommonConfig.NETHERITE_RAKE_DAMAGE.get() : (Double)CommonConfig.RAKE_DAMAGE.get();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon Modifier", damage - 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon Modifier", (Double)CommonConfig.RAKE_SPEED.get() - 4.0, AttributeModifier.Operation.ADDITION));
        double amplifier = this.m_43314_() == Tiers.NETHERITE ? (Double)CommonConfig.NETHERITE_RAKE_RANGE_INCREASE.get() : (Double)CommonConfig.RAKE_RANGE_INCREASE.get();
        builder.put((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)new AttributeModifier(UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3"), "Rake Modifier", amplifier, AttributeModifier.Operation.MULTIPLY_BASE));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA4"), "Rake Modifier", amplifier, AttributeModifier.Operation.MULTIPLY_BASE));
        this.weaponModifiers = builder.build();
    }

    public void m_7373_(@NotNull ItemStack itemstack, Level world, @NotNull List<Component> list, @NotNull TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"item.zombiekit.rake.description"));
        list.add((Component)Component.m_237110_((String)"item.zombiekit.modification", (Object[])new Object[]{ZombieKitKeyMappings.MODIFICATION_GUI.getKey().m_84875_()}));
        if (this.m_43314_() != Tiers.NETHERITE) {
            list.add((Component)Component.m_237115_((String)"item.zombiekit.level_limit"));
        }
    }

    public int getMaxDamage(ItemStack itemStack) {
        float modifier = 1.0f;
        Item item = this.getGripParts(itemStack);
        if (item instanceof GripParts) {
            GripParts gripParts = (GripParts)item;
            modifier *= gripParts.getDurabilityModifier();
        }
        return Math.round((float)super.getMaxDamage(itemStack) * modifier);
    }
}

