/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.scarasol.sona.item.IRustItem;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.init.ZombieKitKeyMappings;
import com.scarasol.zombiekit.item.api.SingleHandWeapon;
import com.scarasol.zombiekit.item.weapon.SweepWeapon;
import com.scarasol.zombiekit.item.weapon.parts.GripParts;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Machete
extends SwordItem
implements SweepWeapon,
IRustItem,
SingleHandWeapon {
    private Multimap<Attribute, AttributeModifier> weaponModifiers;

    public Machete(Tier tier, int damage, float speed, Item.Properties properties) {
        super(tier, damage, speed, properties);
    }

    public float m_43299_() {
        double damage = this.m_43314_() == Tiers.NETHERITE ? (Double)CommonConfig.NETHERITE_MACHETE_DAMAGE.get() : (Double)CommonConfig.MACHETE_DAMAGE.get();
        return (float)(damage * 0.5);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        this.initModifier();
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.weaponModifiers : super.m_7167_(equipmentSlot);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, stack));
            Item grip = this.getGripParts(stack);
            if (grip instanceof GripParts) {
                GripParts gripParts = (GripParts)grip;
                builder.putAll(gripParts.getWeaponModifiers((Item)this));
            }
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public void initModifier() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        double damage = this.m_43314_() == Tiers.NETHERITE ? (Double)CommonConfig.NETHERITE_MACHETE_DAMAGE.get() : (Double)CommonConfig.MACHETE_DAMAGE.get();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", damage - 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (Double)CommonConfig.MACHETE_SPEED.get() - 4.0, AttributeModifier.Operation.ADDITION));
        this.weaponModifiers = builder.build();
    }

    public void m_7373_(@NotNull ItemStack itemstack, Level world, @NotNull List<Component> list, @NotNull TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"item.zombiekit.machete.description"));
        list.add((Component)Component.m_237110_((String)"item.zombiekit.modification", (Object[])new Object[]{ZombieKitKeyMappings.MODIFICATION_GUI.getKey().m_84875_()}));
        if (this.m_43314_() != Tiers.NETHERITE) {
            list.add((Component)Component.m_237115_((String)"item.zombiekit.level_limit"));
        }
    }

    public int getMaxDamage(ItemStack itemStack) {
        float modifier = 1.0f;
        Item item = this.getGripParts(itemStack);
        if (item instanceof GripParts) {
            GripParts gripParts = (GripParts)item;
            modifier *= gripParts.getDurabilityModifier();
        }
        return Math.round((float)super.getMaxDamage(itemStack) * modifier);
    }

    public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        GripParts gripParts;
        double range;
        Item item = this.getGripParts(stack);
        if (item instanceof GripParts && (range = (gripParts = (GripParts)item).getSweepRange()) != 0.0) {
            Vec3 lookAngle = new Vec3(player.m_20252_((float)1.0f).f_82479_, 0.0, player.m_20252_((float)1.0f).f_82481_).m_82541_().m_82490_(range + 0.5);
            return player.m_20191_().m_82377_(range, 0.25, range).m_82383_(lookAngle);
        }
        return super.getSweepHitBox(stack, player, target);
    }
}

