/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.scarasol.sona.item.IRustItem;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.init.ZombieKitItems;
import com.scarasol.zombiekit.init.ZombieKitKeyMappings;
import com.scarasol.zombiekit.item.api.SingleHandWeapon;
import com.scarasol.zombiekit.item.weapon.parts.GripParts;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;

public class Knife
extends SwordItem
implements IRustItem,
SingleHandWeapon {
    private Multimap<Attribute, AttributeModifier> weaponModifiers;

    public Knife(Tier tier, int damage, float speed, Item.Properties properties) {
        super(tier, damage, speed, properties);
    }

    public float m_43299_() {
        double damage = this.m_43314_() == Tiers.NETHERITE ? (Double)CommonConfig.NETHERITE_KNIFE_DAMAGE.get() : (Double)CommonConfig.KNIFE_DAMAGE.get();
        return (float)(damage * 0.5);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        this.initModifier();
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.weaponModifiers : super.m_7167_(equipmentSlot);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, stack));
            Item grip = this.getGripParts(stack);
            if (grip instanceof GripParts) {
                GripParts gripParts = (GripParts)grip;
                builder.putAll(gripParts.getWeaponModifiers((Item)this));
            }
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public void initModifier() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        double damage = this.equals(ZombieKitItems.TRIANGULAR_THORN.get()) ? ((Double)CommonConfig.TRIANGULAR_THORN_DAMAGE.get()).doubleValue() : (this.m_43314_() == Tiers.NETHERITE ? (Double)CommonConfig.NETHERITE_KNIFE_DAMAGE.get() : (Double)CommonConfig.KNIFE_DAMAGE.get()).doubleValue();
        double speed = this.m_43314_() == Tiers.NETHERITE ? (Double)CommonConfig.NETHERITE_KNIFE_SPEED.get() : (Double)CommonConfig.KNIFE_SPEED.get();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", damage - 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", speed - 4.0, AttributeModifier.Operation.ADDITION));
        this.weaponModifiers = builder.build();
    }

    public InteractionResult m_6880_(ItemStack itemstack, Player player, LivingEntity livingEntity, InteractionHand interactionHand) {
        Mob mob;
        super.m_6880_(itemstack, player, livingEntity, interactionHand);
        if (!player.m_36335_().m_41519_(itemstack.m_41720_()) && livingEntity instanceof Mob && !player.equals((Object)(mob = (Mob)livingEntity).m_5448_())) {
            double damage = player.m_21133_(Attributes.f_22281_);
            livingEntity.getPersistentData().m_128379_("CancelKnockback", true);
            livingEntity.m_6469_(player.m_9236_().m_269111_().m_269075_(player), (float)((Double)CommonConfig.ASSASSINATE_MULTIPLIER.get() * damage));
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41622_(5, (LivingEntity)player, consumer -> consumer.m_21190_(interactionHand));
                player.m_36335_().m_41524_(itemstack.m_41720_(), 140);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        if (toolAction == ToolActions.SWORD_SWEEP) {
            return false;
        }
        return super.canPerformAction(stack, toolAction);
    }

    public void m_7373_(@NotNull ItemStack itemstack, Level world, @NotNull List<Component> list, @NotNull TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"item.zombiekit.knife.description"));
        list.add((Component)Component.m_237110_((String)"item.zombiekit.modification", (Object[])new Object[]{ZombieKitKeyMappings.MODIFICATION_GUI.getKey().m_84875_()}));
        if (this.m_43314_() != Tiers.NETHERITE) {
            list.add((Component)Component.m_237115_((String)"item.zombiekit.level_limit"));
        }
    }

    public int getMaxDamage(ItemStack itemStack) {
        float modifier = 1.0f;
        Item item = this.getGripParts(itemStack);
        if (item instanceof GripParts) {
            GripParts gripParts = (GripParts)item;
            modifier *= gripParts.getDurabilityModifier();
        }
        return Math.round((float)super.getMaxDamage(itemStack) * modifier);
    }
}

