/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.item.weapon;

import com.scarasol.sona.init.SonaMobEffects;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.init.ZombieKitParticleTypes;
import com.scarasol.zombiekit.item.api.BaseFuelCanister;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class FuelCanister
extends Item
implements BaseFuelCanister {
    private final FuelType fuelType;

    public FuelCanister(Item.Properties properties, FuelType fuelType) {
        super(properties);
        this.fuelType = fuelType;
    }

    @Override
    public void canisterEffect(LivingEntity target) {
        int damage = 0;
        if (this.fuelType == FuelType.NORMAL) {
            damage = (Integer)CommonConfig.FUEL_DAMAGE.get();
            target.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.IGNITION.get(), 110, 1, false, false));
        } else if (this.fuelType == FuelType.HIGH_TEMPERATURE) {
            damage = (Integer)CommonConfig.HIGH_TEMPERATURE_FUEL_DAMAGE.get();
            target.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.IGNITION.get(), 150, 3, false, false));
        } else if (this.fuelType == FuelType.NAPALM) {
            damage = (Integer)CommonConfig.NAPALM_FUEL_DAMAGE.get();
            target.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.IGNITION.get(), 230, Math.max(damage - 1, 1), false, false));
            target.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.SLIMINESS.get(), 230, 0, false, false));
        }
        target.m_6469_(target.m_9236_().m_269111_().m_269387_(), (float)damage);
    }

    @Override
    @NotNull
    public ParticleType<?> getParticleType() {
        return switch (this.fuelType) {
            case FuelType.HIGH_TEMPERATURE -> (ParticleType)ZombieKitParticleTypes.LARGE_SOUL_FLAME.get();
            case FuelType.NAPALM -> (ParticleType)ZombieKitParticleTypes.LARGE_NAPALM_FLAME.get();
            default -> (ParticleType)ZombieKitParticleTypes.LARGE_FLAME.get();
        };
    }

    @Override
    @NotNull
    public String getTexture() {
        return switch (this.fuelType) {
            case FuelType.HIGH_TEMPERATURE -> "flamethrower_high_temperature";
            case FuelType.NAPALM -> "flamethrower_napalm";
            default -> "flamethrower";
        };
    }

    public static enum FuelType {
        NORMAL,
        HIGH_TEMPERATURE,
        NAPALM;

    }
}

