/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.item.weapon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.scarasol.sona.util.SonaMath;
import com.scarasol.zombiekit.client.model.ZombieKitGeoItemModel;
import com.scarasol.zombiekit.client.renderer.FlameThrowerRenderer;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.init.ZombieKitItems;
import com.scarasol.zombiekit.init.ZombieKitSounds;
import com.scarasol.zombiekit.item.api.BaseFuelCanister;
import com.scarasol.zombiekit.item.api.BaseZombieKitGeoItem;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Flamethrower
extends Item
implements BaseZombieKitGeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation RELOAD = RawAnimation.begin().thenPlay("reload");
    private static final RawAnimation RELOAD_EMPTY = RawAnimation.begin().thenPlay("reload_empty");
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");

    public Flamethrower(Item.Properties properties) {
        super(properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack itemStack, int tick) {
        if (this.getPressure(itemStack) <= 0.0) {
            return;
        }
        Vec3 lookAngle = player.m_20252_(1.0f).m_82490_(1.5);
        Vec3 position = player.m_204034_((Item)ZombieKitItems.FLAMETHROWER.get()).m_82524_(-20.0f).m_82549_(player.m_146892_()).m_82549_(lookAngle);
        double x = position.m_7096_();
        double y = position.m_7098_();
        double z = position.m_7094_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.putPressure(itemStack, Math.max(this.getPressure(itemStack) - (Double)CommonConfig.FUEL_CONSUME.get(), 0.0));
            Vec3 center = player.m_20097_().m_252807_();
            double range = Math.min((double)tick * 1.5, 18.0);
            serverLevel.m_6443_(LivingEntity.class, new AABB(center, center).m_82400_(range), e -> this.shouldBeBurned(player, (LivingEntity)e)).forEach(target -> this.burn((LivingEntity)target, itemStack));
            BaseFuelCanister fuelCanister = this.getCanister(itemStack);
            if (fuelCanister != null) {
                serverLevel.m_8795_(e -> e.m_20270_((Entity)player) < 60.0f).forEach(serverPlayer -> serverLevel.m_8624_(serverPlayer, (ParticleOptions)((SimpleParticleType)fuelCanister.getParticleType()), true, x, y, z, 0, lookAngle.f_82479_, lookAngle.f_82480_, lookAngle.f_82481_, 1.0));
            }
            this.burnBlock(player, range);
            serverLevel.m_5594_(null, player.m_20097_(), (SoundEvent)ZombieKitSounds.flamethrower.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
        }
    }

    public boolean shouldBeBurned(LivingEntity attacker, LivingEntity target) {
        Vec3 vec3;
        if (attacker instanceof AbstractIllager && target instanceof AbstractIllager) {
            return false;
        }
        String id = ForgeRegistries.ENTITY_TYPES.getKey((Object)attacker.m_6095_()).toString();
        if (id.contains("recruits") || id.contains("guardvillagers")) {
            String targetId = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_()).toString();
            if (target instanceof AbstractVillager || targetId.contains("recruits") || targetId.contains("guardvillagers")) {
                return false;
            }
        }
        if (target.equals((Object)attacker)) {
            return false;
        }
        if (!target.m_142582_((Entity)attacker)) {
            return false;
        }
        Vec3 position = attacker.m_20182_();
        Vec3 lookAngle = attacker.m_20252_(1.0f);
        return SonaMath.vectorDegreeCalculate((Vec3)lookAngle, (Vec3)(vec3 = target.m_20182_().m_82546_(position))) < 10.0;
    }

    private void burn(LivingEntity target, ItemStack itemStack) {
        BaseFuelCanister canister = this.getCanister(itemStack);
        if (canister != null) {
            canister.canisterEffect(target);
        }
    }

    public void reload(Player player, Level level, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        List<ItemStack> list = player.m_150109_().f_35974_.stream().filter(stack -> stack.m_41720_() instanceof BaseFuelCanister).toList();
        boolean flag = false;
        BaseFuelCanister baseFuelCanister = this.getCanister(itemStack);
        if (!list.isEmpty()) {
            canister = list.get(0);
            this.putCanister(itemStack, canister);
            if (!player.m_7500_()) {
                canister.m_41774_(1);
            }
            flag = true;
        } else if (player.m_7500_()) {
            canister = baseFuelCanister == null ? new ItemStack((ItemLike)ZombieKitItems.FUEL_CANISTER.get()) : new ItemStack((ItemLike)((Item)baseFuelCanister));
            this.putCanister(itemStack, canister);
            flag = true;
        }
        if (flag && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.putReloadTime(itemStack, serverLevel.m_46467_());
            String anime = baseFuelCanister == null ? "reload_empty" : "reload";
            SoundEvent soundEvent = baseFuelCanister == null ? (SoundEvent)ZombieKitSounds.flamethrower_reload_empty.get() : (SoundEvent)ZombieKitSounds.flamethrower_reload.get();
            serverLevel.m_6269_(null, (Entity)player, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)itemStack, (ServerLevel)serverLevel), "procedureController", anime);
        }
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        if (level.m_46467_() - this.getReloadTime(stack) > 21L) {
            this.changeTexture(stack);
        }
        if (this.getUsing(stack) && selectedIndex == slotIndex) {
            this.m_5929_(level, (LivingEntity)player, stack, (int)(level.m_46467_() - this.getStartUsingTime(stack)));
        }
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
    }

    public void changeTexture(ItemStack itemStack) {
        BaseFuelCanister baseFuelCanister = this.getCanister(itemStack);
        if (baseFuelCanister != null) {
            String newTexture = baseFuelCanister.getTexture();
            if (!newTexture.equals(this.getCurrentTexture(itemStack))) {
                this.putCurrentTexture(itemStack, newTexture);
            }
        } else if (!"flamethrower_empty".equals(this.getCurrentTexture(itemStack))) {
            this.putCurrentTexture(itemStack, "flamethrower_empty");
        }
    }

    public void putStartUsingTick(ItemStack itemStack, long time) {
        itemStack.m_41784_().m_128356_("StartUsingTime", time);
    }

    public long getStartUsingTime(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            return itemStack.m_41783_().m_128454_("StartUsingTime");
        }
        return 0L;
    }

    public void putUsing(ItemStack itemStack, boolean using) {
        itemStack.m_41784_().m_128379_("Using", using);
    }

    public boolean getUsing(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            return itemStack.m_41783_().m_128471_("Using");
        }
        return false;
    }

    public void putCurrentTexture(ItemStack itemStack, String currentTexture) {
        itemStack.m_41784_().m_128359_("CurrentTexture", currentTexture);
    }

    public String getCurrentTexture(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            return "".equals(itemStack.m_41783_().m_128461_("CurrentTexture")) ? "flamethrower_empty" : itemStack.m_41783_().m_128461_("CurrentTexture");
        }
        return "flamethrower_empty";
    }

    public void putReloadTime(ItemStack itemStack, long reloadTime) {
        itemStack.m_41784_().m_128356_("ReloadTime", reloadTime);
    }

    public long getReloadTime(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            return itemStack.m_41783_().m_128454_("ReloadTime");
        }
        return 0L;
    }

    @Nullable
    public BaseFuelCanister getCanister(ItemStack itemStack) {
        String canisterStr;
        Item canister;
        if (itemStack.m_41782_() && (canister = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(canisterStr = itemStack.m_41783_().m_128461_("Canister")))) instanceof BaseFuelCanister) {
            BaseFuelCanister baseFuelCanister = (BaseFuelCanister)canister;
            return baseFuelCanister;
        }
        return null;
    }

    public double getPressure(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            return itemStack.m_41783_().m_128459_("Pressure");
        }
        return 0.0;
    }

    public void putPressure(ItemStack itemStack, double pressure) {
        itemStack.m_41784_().m_128347_("Pressure", pressure);
    }

    public void putCanister(ItemStack itemStack, ItemStack canister) {
        if (canister.m_41619_()) {
            itemStack.m_41784_().m_128359_("Canister", "");
            itemStack.m_41784_().m_128347_("Pressure", 0.0);
        }
        itemStack.m_41784_().m_128359_("Canister", ForgeRegistries.ITEMS.getKey((Object)canister.m_41720_()).toString());
        itemStack.m_41784_().m_128347_("Pressure", (double)(canister.m_41776_() - canister.m_41773_()));
    }

    public void burnBlock(LivingEntity player, double range) {
        Vec3 lookAngle = player.m_20252_(1.0f);
        Vec3 position = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Level level = player.m_9236_();
        int i = 0;
        while ((double)i < range) {
            BlockPos pos = BlockPos.m_274446_((Position)(position = position.m_82549_(lookAngle)));
            BlockState state = level.m_8055_(pos);
            if (!state.m_60795_()) {
                if (state.m_61138_((Property)BlockStateProperties.f_61443_)) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 3);
                    break;
                }
                BlockPos firePos = BlockPos.m_274446_((Position)position.m_82546_(lookAngle));
                if (!level.m_8055_(firePos).m_60795_() || !BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)firePos).m_60710_((LevelReader)level, firePos)) break;
                BlockState fire = BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)firePos);
                level.m_7731_(firePos, fire, 11);
                level.m_142346_((Entity)player, GameEvent.f_157797_, pos);
                break;
            }
            ++i;
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack itemstack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new FlameThrowerRenderer(new ZombieKitGeoItemModel());

            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                if (itemInHand == player.m_21211_()) {
                    int i = arm == HumanoidArm.RIGHT ? 1 : -1;
                    poseStack.m_252880_((float)i * 0.56f, -0.52f, -0.72f);
                    return true;
                }
                return false;
            }

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    private PlayState procedurePredicate(AnimationState<Flamethrower> event) {
        AnimationController controller = event.getController();
        if (!controller.isPlayingTriggeredAnimation() && (controller.getCurrentRawAnimation() == null || event.getController().hasAnimationFinished())) {
            controller.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedureController", 0, this::procedurePredicate).triggerableAnim("reload", RELOAD).triggerableAnim("reload_empty", RELOAD_EMPTY).receiveTriggeredAnimations()});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("zombiekit", "textures/item/flamethrower.png");
    }

    @Override
    public ResourceLocation getModel() {
        if (FlameThrowerRenderer.transformType.m_269069_()) {
            return new ResourceLocation("zombiekit", "geo/flamethrower.geo.json");
        }
        return new ResourceLocation("zombiekit", "geo/flamethrower_third.geo.json");
    }

    public ResourceLocation getTexture(ItemStack stack) {
        return new ResourceLocation("zombiekit", "textures/item/" + this.getCurrentTexture(stack) + ".png");
    }
}

