/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.item.armor;

import com.google.common.collect.Iterables;
import com.scarasol.zombiekit.client.model.SkiingSuitModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class SkiingArmor
extends ArmorItem {
    public SkiingArmor(ArmorMaterial armorMaterial, ArmorItem.Type equipmentSlot, Item.Properties properties) {
        super(armorMaterial, equipmentSlot, properties);
    }

    public void onInventoryTick(ItemStack itemStack, Level level, Player player, int slotIndex, int selectedIndex) {
        super.onInventoryTick(itemStack, level, player, slotIndex, selectedIndex);
        if (this.m_40402_() == EquipmentSlot.HEAD && Iterables.contains((Iterable)player.m_6168_(), (Object)itemStack)) {
            player.m_21195_(MobEffects.f_19610_);
        }
    }

    public boolean canWalkOnPowderedSnow(ItemStack itemStack, LivingEntity livingEntity) {
        return this.m_40402_() == EquipmentSlot.FEET;
    }

    public String getArmorTexture(ItemStack itemStack, Entity entity, EquipmentSlot slot, String type) {
        return "zombiekit:textures/entities/skiing_suit.png";
    }

    public HumanoidModel getArmorModel() {
        HashMap<String, ModelPart> map = new HashMap<String, ModelPart>(Map.of("head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap())));
        switch (this.m_40402_()) {
            case HEAD: {
                map.put("head", new SkiingSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SkiingSuitModel.LAYER_LOCATION)).Head);
                break;
            }
            case CHEST: {
                map.put("body", new SkiingSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SkiingSuitModel.LAYER_LOCATION)).Body);
                map.put("right_arm", new SkiingSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SkiingSuitModel.LAYER_LOCATION)).RightArm);
                map.put("left_arm", new SkiingSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SkiingSuitModel.LAYER_LOCATION)).LeftArm);
                break;
            }
            case LEGS: {
                map.put("right_leg", new SkiingSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SkiingSuitModel.LAYER_LOCATION)).RightLeg);
                map.put("left_leg", new SkiingSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SkiingSuitModel.LAYER_LOCATION)).LeftLeg);
                break;
            }
            default: {
                map.put("right_leg", new SkiingSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SkiingSuitModel.LAYER_LOCATION)).RightShoes);
                map.put("left_leg", new SkiingSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SkiingSuitModel.LAYER_LOCATION)).LeftShoes);
            }
        }
        return new HumanoidModel(new ModelPart(Collections.emptyList(), Map.copyOf(map)));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                HumanoidModel armorModel = SkiingArmor.this.getArmorModel();
                armorModel.f_102817_ = living.m_6144_();
                armorModel.f_102609_ = defaultModel.f_102609_;
                armorModel.f_102610_ = living.m_6162_();
                return armorModel;
            }
        });
    }
}

