/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.item.armor;

import com.google.common.collect.Iterables;
import com.scarasol.sona.init.SonaMobEffects;
import com.scarasol.zombiekit.client.model.ExoSuitModel;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.init.ZombieKitSounds;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ExoArmor
extends ArmorItem {
    public static AttributeModifier COMBAT_MOVEMENT = new AttributeModifier(UUID.fromString("5987CE5F-1549-3D44-EA5E-33BA82D76A95"), "ExoCombat", 0.15, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public ExoArmor(ArmorMaterial armorMaterial, ArmorItem.Type equipmentSlot, Item.Properties properties) {
        super(armorMaterial, equipmentSlot, properties);
    }

    public void onInventoryTick(ItemStack itemStack, Level level, Player player, int slotIndex, int selectedIndex) {
        Level level2;
        super.onInventoryTick(itemStack, level, player, slotIndex, selectedIndex);
        if (this.m_40402_() == EquipmentSlot.CHEST && Iterables.contains((Iterable)player.m_6168_(), (Object)itemStack) && ExoArmor.numberOfSuit((LivingEntity)player) == 4 && (level2 = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            if (ExoArmor.getPower(itemStack) > 0) {
                this.fallProtect(itemStack, player, serverLevel);
                this.modeFunction(itemStack, player, serverLevel);
            } else {
                ExoArmor.setReactiveArmor(itemStack, -1);
                ExoArmor.switchRadar(itemStack, 0);
                ExoArmor.switchMode(itemStack, 0);
            }
            if (!((Boolean)CommonConfig.FLY_FUNCTION.get()).booleanValue()) {
                ExoArmor.setFlyMode(itemStack, false);
            }
        }
    }

    public void fallProtect(ItemStack itemStack, Player player, ServerLevel serverLevel) {
        if (!player.m_20072_() && !player.m_21255_() && player.f_19789_ > 5.0f && !player.m_21023_(MobEffects.f_19591_)) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 100, 0.5, 0.2, 0.5, 0.1);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 0, false, false));
            ExoArmor.addPower(itemStack, -1);
        }
        if (!player.m_20096_() && player.m_21023_(MobEffects.f_19591_) && serverLevel.m_46467_() % 10L == 0L) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 5, 0.0, 0.2, 0.0, 0.05);
        }
    }

    public void modeFunction(ItemStack itemStack, Player player, ServerLevel serverLevel) {
        int radar;
        switch (ExoArmor.getMode(itemStack)) {
            case 1: {
                if (!player.m_21023_((MobEffect)SonaMobEffects.EXPOSURE.get())) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 20, 0, false, false));
                    player.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.CAMOUFLAGE.get(), 20, 4, false, false));
                    if (serverLevel.m_46467_() % 240L != 0L) break;
                    ExoArmor.addPower(itemStack, -1);
                    break;
                }
                ExoArmor.switchMode(player, 1);
                break;
            }
            case 2: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 20, 1, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 20, 0, false, false));
                if (serverLevel.m_46467_() % 120L != 0L) break;
                ExoArmor.addPower(itemStack, -1);
            }
        }
        int reactiveArmor = ExoArmor.getReactiveArmor(itemStack);
        if (reactiveArmor >= 0) {
            ExoArmor.addReactiveArmor(itemStack, 1);
            if (reactiveArmor >= 160) {
                if (serverLevel.m_46467_() % 60L == 0L) {
                    serverLevel.m_6269_(null, (Entity)player, (SoundEvent)ZombieKitSounds.reactive_armor_ready.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), 1, 0.2, 0.5, 0.2, 0.05);
            }
            if (serverLevel.m_46467_() % 120L == 0L) {
                ExoArmor.addPower(itemStack, -1);
            }
        }
        if ((radar = ExoArmor.getRadar(itemStack)) > 0) {
            if (radar == 1) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 210, 0, false, false));
            }
            if (serverLevel.m_46467_() % (long)(480 / radar) == 0L) {
                ExoArmor.addPower(itemStack, -1);
            }
        }
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return ExoArmor.numberOfSuit(entity) == 4 && ExoArmor.getFlyMode(stack) && ExoArmor.getPower(stack) > 5 && (Boolean)CommonConfig.FLY_FUNCTION.get() != false;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (ExoArmor.numberOfSuit(entity) < 4 || !((Boolean)CommonConfig.FLY_FUNCTION.get()).booleanValue() || !ExoArmor.getFlyMode(stack)) {
            return false;
        }
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (flightTicks % 120 == 0) {
                ExoArmor.addPower(stack, -1);
            }
            if (entity.m_20142_()) {
                if (flightTicks % 10 == 0) {
                    serverLevel.m_6269_(null, (Entity)entity, (SoundEvent)ZombieKitSounds.exo_fly.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (flightTicks % 2 == 0) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123815_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1, entity.m_217043_().m_188583_() * 0.05, -entity.m_20184_().f_82480_ * 0.5, entity.m_217043_().m_188583_() * 0.05, 0.01);
                }
            } else {
                return !entity.m_6144_();
            }
        }
        return true;
    }

    public String getArmorTexture(ItemStack itemStack, Entity entity, EquipmentSlot slot, String type) {
        return "zombiekit:textures/entities/exo_suit.png";
    }

    public HumanoidModel getArmorModel(LivingEntity livingEntity) {
        HashMap<String, ModelPart> map = new HashMap<String, ModelPart>(Map.of("head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap())));
        if (!livingEntity.m_21023_(MobEffects.f_19609_) || ExoArmor.numberOfSuit(livingEntity) != 4 || ExoArmor.getMode(livingEntity.m_6844_(EquipmentSlot.CHEST)) != 1) {
            switch (this.m_40402_()) {
                case HEAD: {
                    map.put("head", new ExoSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ExoSuitModel.LAYER_LOCATION)).Head);
                    break;
                }
                case CHEST: {
                    map.put("body", new ExoSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ExoSuitModel.LAYER_LOCATION)).Body);
                    map.put("right_arm", new ExoSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ExoSuitModel.LAYER_LOCATION)).RightArm);
                    map.put("left_arm", new ExoSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ExoSuitModel.LAYER_LOCATION)).LeftArm);
                    break;
                }
                case LEGS: {
                    map.put("right_leg", new ExoSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ExoSuitModel.LAYER_LOCATION)).RightLeg);
                    map.put("left_leg", new ExoSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ExoSuitModel.LAYER_LOCATION)).LeftLeg);
                    break;
                }
                default: {
                    map.put("right_leg", new ExoSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ExoSuitModel.LAYER_LOCATION)).RightShoes);
                    map.put("left_leg", new ExoSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ExoSuitModel.LAYER_LOCATION)).LeftShoes);
                }
            }
        }
        return new HumanoidModel(new ModelPart(Collections.emptyList(), Map.copyOf(map)));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                HumanoidModel armorModel = ExoArmor.this.getArmorModel(living);
                armorModel.f_102817_ = living.m_6144_();
                armorModel.f_102609_ = defaultModel.f_102609_;
                armorModel.f_102610_ = living.m_6162_();
                return armorModel;
            }
        });
    }

    public static int numberOfSuit(LivingEntity livingEntity) {
        int count = 0;
        for (ItemStack itemStack : livingEntity.m_6168_()) {
            if (!(itemStack.m_41720_() instanceof ExoArmor)) continue;
            ++count;
        }
        return count;
    }

    public static void switchMode(Player livingEntity, int mode) {
        if (ExoArmor.numberOfSuit((LivingEntity)livingEntity) < 4) {
            return;
        }
        ItemStack chest = livingEntity.m_6844_(EquipmentSlot.CHEST);
        if (ExoArmor.getPower(chest) <= 0) {
            livingEntity.m_5661_((Component)Component.m_237115_((String)"item.zombiekit.exo.no_power"), true);
            return;
        }
        int currentMode = ExoArmor.getMode(chest);
        if (mode == 3) {
            if (currentMode == 1) {
                livingEntity.m_5661_((Component)Component.m_237115_((String)"item.zombiekit.exo.no_reactive_armor"), true);
            } else if (ExoArmor.getReactiveArmor(chest) >= 0) {
                livingEntity.m_5661_((Component)Component.m_237115_((String)"item.zombiekit.exo.reactive_armor_off"), true);
                ExoArmor.setReactiveArmor(chest, -1);
            } else {
                livingEntity.m_5661_((Component)Component.m_237115_((String)"item.zombiekit.exo.reactive_armor_on"), true);
                ExoArmor.setReactiveArmor(chest, 0);
            }
        } else if (mode == 4) {
            int radar = ExoArmor.getRadar(chest);
            if (radar == 2) {
                livingEntity.m_5661_((Component)Component.m_237115_((String)"item.zombiekit.exo.radar_off"), true);
            } else if (radar == 1) {
                livingEntity.m_5661_((Component)Component.m_237115_((String)"item.zombiekit.exo.radar_on"), true);
                livingEntity.m_9236_().m_6269_(null, (Entity)livingEntity, (SoundEvent)ZombieKitSounds.radar_activated.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                livingEntity.m_21195_(MobEffects.f_19611_);
            } else {
                livingEntity.m_5661_((Component)Component.m_237115_((String)"item.zombiekit.exo.radar_night_vision"), true);
                livingEntity.m_9236_().m_6269_(null, (Entity)livingEntity, (SoundEvent)ZombieKitSounds.radar_activated.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            ExoArmor.switchRadar(chest, (radar + 1) % 3);
        } else if (mode == 5) {
            if (!((Boolean)CommonConfig.FLY_FUNCTION.get()).booleanValue()) {
                livingEntity.m_5661_((Component)Component.m_237115_((String)"item.zombiekit.exo.forbidden_fly_mode"), true);
                return;
            }
            if (ExoArmor.getMode(chest) == 1) {
                livingEntity.m_5661_((Component)Component.m_237115_((String)"item.zombiekit.exo.no_fly_mode"), true);
            } else {
                boolean flag = ExoArmor.getFlyMode(chest);
                if (flag) {
                    livingEntity.m_5661_((Component)Component.m_237115_((String)"item.zombiekit.exo.fly_mode_off"), true);
                    ExoArmor.setFlyMode(chest, false);
                } else {
                    livingEntity.m_5661_((Component)Component.m_237115_((String)"item.zombiekit.exo.fly_mode_on"), true);
                    ExoArmor.setFlyMode(chest, true);
                }
            }
        } else {
            if (currentMode == mode) {
                ExoArmor.switchMode(chest, 0);
                livingEntity.m_21051_(Attributes.f_22279_).m_22130_(COMBAT_MOVEMENT);
                livingEntity.m_5661_((Component)Component.m_237115_((String)"item.zombiekit.exo.exit_mode"), true);
            } else {
                ExoArmor.switchMode(chest, mode);
                if (mode == 1) {
                    ExoArmor.setFlyMode(chest, false);
                    ExoArmor.setReactiveArmor(chest, -1);
                    livingEntity.m_21051_(Attributes.f_22279_).m_22130_(COMBAT_MOVEMENT);
                    livingEntity.m_5661_((Component)Component.m_237115_((String)"item.zombiekit.exo.sneak_mode"), true);
                } else if (mode == 2) {
                    livingEntity.m_21051_(Attributes.f_22279_).m_22130_(COMBAT_MOVEMENT);
                    livingEntity.m_21051_(Attributes.f_22279_).m_22125_(COMBAT_MOVEMENT);
                    livingEntity.m_5661_((Component)Component.m_237115_((String)"item.zombiekit.exo.combat_mode"), true);
                }
            }
            livingEntity.m_9236_().m_6269_(null, (Entity)livingEntity, (SoundEvent)ZombieKitSounds.mode_switch.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static boolean reactiveArmor(LivingEntity target, Entity attacker) {
        int count = ExoArmor.numberOfSuit(target);
        if (count == 4 && ExoArmor.getReactiveArmor(target.m_6844_(EquipmentSlot.CHEST)) >= 160) {
            Projectile projectile;
            Vec3 vec3 = attacker instanceof Projectile && (projectile = (Projectile)attacker).m_19749_() != null ? new Vec3(projectile.m_19749_().m_20185_() - target.m_20185_(), projectile.m_19749_().m_20186_() - target.m_20186_(), projectile.m_19749_().m_20189_() - target.m_20189_()).m_82490_((double)(1.0f / attacker.m_20270_((Entity)target))) : new Vec3(attacker.m_20185_() - target.m_20185_(), 0.0, attacker.m_20189_() - target.m_20189_()).m_82490_(1.5);
            attacker.m_20256_(vec3);
            ExoArmor.setReactiveArmor(target.m_6844_(EquipmentSlot.CHEST), 0);
            target.m_9236_().m_6269_(null, (Entity)target, (SoundEvent)ZombieKitSounds.reactive_armor_release.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (attacker instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)attacker;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.STUN.get(), 100, 0, false, false));
            }
            return true;
        }
        return false;
    }

    public static void updateModifier(LivingEntity livingEntity) {
        int count = ExoArmor.numberOfSuit(livingEntity);
        if (count < 4 || ExoArmor.getMode(livingEntity.m_6844_(EquipmentSlot.CHEST)) != 2) {
            livingEntity.m_21051_(Attributes.f_22279_).m_22130_(COMBAT_MOVEMENT);
        }
    }

    public static void addPower(ItemStack itemStack, int power) {
        int currentPower = itemStack.m_41784_().m_128451_("Power");
        power = power > 0 ? Math.min(currentPower + power, 100) : Math.max(currentPower + power, 0);
        ExoArmor.setPower(itemStack, power);
    }

    public static void setPower(ItemStack itemStack, int power) {
        itemStack.m_41784_().m_128405_("Power", power);
    }

    public static void setFlyMode(ItemStack itemStack, boolean fly) {
        itemStack.m_41784_().m_128379_("FlyMode", fly);
    }

    public static boolean getFlyMode(ItemStack itemStack) {
        return itemStack.m_41784_().m_128471_("FlyMode");
    }

    public static int getPower(ItemStack itemStack) {
        return itemStack.m_41784_().m_128451_("Power");
    }

    public static void switchMode(ItemStack itemStack, int mode) {
        itemStack.m_41784_().m_128405_("Mode", mode);
    }

    public static int getMode(ItemStack itemStack) {
        return itemStack.m_41784_().m_128451_("Mode");
    }

    public static int getRadar(ItemStack itemStack) {
        return itemStack.m_41784_().m_128451_("Radar");
    }

    public static void switchRadar(ItemStack itemStack, int radar) {
        itemStack.m_41784_().m_128405_("Radar", radar);
    }

    public static int getReactiveArmor(ItemStack itemStack) {
        return itemStack.m_41784_().m_128451_("ReactiveArmor");
    }

    public static void setReactiveArmor(ItemStack itemStack, int reactiveArmor) {
        itemStack.m_41784_().m_128405_("ReactiveArmor", reactiveArmor);
    }

    public static void addReactiveArmor(ItemStack itemStack, int reactiveArmor) {
        int coolDown = itemStack.m_41784_().m_128451_("ReactiveArmor");
        reactiveArmor = reactiveArmor > 0 ? Math.min(coolDown + reactiveArmor, 160) : Math.max(coolDown + reactiveArmor, 0);
        ExoArmor.setReactiveArmor(itemStack, reactiveArmor);
    }
}

