/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.item.armor;

import com.google.common.collect.Iterables;
import com.scarasol.sona.init.SonaMobEffects;
import com.scarasol.zombiekit.init.ZombieKitTags;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class CamouflageArmor
extends ArmorItem {
    private final int camouflage;

    public CamouflageArmor(ArmorMaterial armorMaterial, ArmorItem.Type equipmentSlot, Item.Properties properties, int camouflage) {
        super(armorMaterial, equipmentSlot, properties);
        this.camouflage = camouflage;
    }

    public int getCamouflage() {
        return this.camouflage;
    }

    public void onInventoryTick(ItemStack itemStack, Level level, Player player, int slotIndex, int selectedIndex) {
        super.onInventoryTick(itemStack, level, player, slotIndex, selectedIndex);
        if (this.m_40402_() == EquipmentSlot.CHEST && Iterables.contains((Iterable)player.m_6168_(), (Object)itemStack)) {
            if (this.camouflage == 0 || player.m_20142_() || player.m_21023_((MobEffect)SonaMobEffects.EXPOSURE.get())) {
                return;
            }
            BlockPos blockPos = player.m_20183_();
            if (!this.isProperPlace(blockPos, level)) {
                return;
            }
            for (ItemStack armor : player.m_6168_()) {
                Item item = armor.m_41720_();
                if (item instanceof CamouflageArmor) {
                    CamouflageArmor camouflageSuit = (CamouflageArmor)item;
                    if (camouflageSuit.camouflage == this.camouflage) continue;
                }
                return;
            }
            int amplifier = 0;
            if (player.m_6144_()) {
                ++amplifier;
            }
            if (level.m_46803_(blockPos) < 7 || level.m_46471_() && level.m_46861_(blockPos)) {
                ++amplifier;
            }
            player.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.CAMOUFLAGE.get(), 20, amplifier, false, false));
        }
    }

    public boolean isProperPlace(BlockPos blockPos, Level level) {
        switch (this.camouflage) {
            case 1: {
                if (level.m_204166_(blockPos).m_203656_(ZombieKitTags.DESERT_CAVE)) {
                    return true;
                }
                if (!level.m_204166_(blockPos).m_203656_(ZombieKitTags.DESERT)) break;
                return level.m_46861_(blockPos) || blockPos.m_123342_() > 63;
            }
            case 2: {
                if (level.m_204166_(blockPos).m_203656_(ZombieKitTags.FOREST_CAVE)) {
                    return true;
                }
                if (!level.m_204166_(blockPos).m_203656_(ZombieKitTags.FOREST)) break;
                return level.m_46861_(blockPos) || blockPos.m_123342_() > 63;
            }
            case 3: {
                if (level.m_204166_(blockPos).m_203656_(ZombieKitTags.SNOW_CAVE)) {
                    return true;
                }
                if (!level.m_204166_(blockPos).m_203656_(ZombieKitTags.SNOW)) break;
                return level.m_46861_(blockPos) || blockPos.m_123342_() > 63;
            }
            default: {
                return false;
            }
        }
        return false;
    }
}

