/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.item.armor;

import com.scarasol.zombiekit.client.model.BombSuitModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class BombArmor
extends ArmorItem {
    public static AttributeModifier ATTACK_SPEED = new AttributeModifier(UUID.fromString("0753E5E5-B0B5-6828-0B38-350A5885B144"), "bombArmorAttackSpeed", -0.3, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static AttributeModifier SLOWNESS = new AttributeModifier(UUID.fromString("CE35FE84-FF47-B780-0EC6-9164DCF1CED6"), "bombArmorSlowness", -0.3, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static AttributeModifier HEALTH_BOOST = new AttributeModifier(UUID.fromString("bec5f226-4b78-5014-b906-2fb397957925"), "bombArmorHealthBoost", 20.0, AttributeModifier.Operation.ADDITION);

    public BombArmor(ArmorMaterial armorMaterial, ArmorItem.Type equipmentSlot, Item.Properties properties) {
        super(armorMaterial, equipmentSlot, properties);
    }

    public String getArmorTexture(ItemStack itemStack, Entity entity, EquipmentSlot slot, String type) {
        return "zombiekit:textures/entities/bomb_suit.png";
    }

    public HumanoidModel getArmorModel() {
        HashMap<String, ModelPart> map = new HashMap<String, ModelPart>(Map.of("head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap())));
        switch (this.m_40402_()) {
            case HEAD: {
                map.put("head", new BombSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)BombSuitModel.LAYER_LOCATION)).Head);
                break;
            }
            case CHEST: {
                map.put("body", new BombSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)BombSuitModel.LAYER_LOCATION)).Body);
                map.put("right_arm", new BombSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)BombSuitModel.LAYER_LOCATION)).RightArm);
                map.put("left_arm", new BombSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)BombSuitModel.LAYER_LOCATION)).LeftArm);
                break;
            }
            case LEGS: {
                map.put("right_leg", new BombSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)BombSuitModel.LAYER_LOCATION)).RightLeg);
                map.put("left_leg", new BombSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)BombSuitModel.LAYER_LOCATION)).LeftLeg);
                break;
            }
            default: {
                map.put("right_leg", new BombSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)BombSuitModel.LAYER_LOCATION)).RightShoes);
                map.put("left_leg", new BombSuitModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)BombSuitModel.LAYER_LOCATION)).LeftShoes);
            }
        }
        return new HumanoidModel(new ModelPart(Collections.emptyList(), Map.copyOf(map)));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                HumanoidModel armorModel = BombArmor.this.getArmorModel();
                armorModel.f_102817_ = living.m_6144_();
                armorModel.f_102609_ = defaultModel.f_102609_;
                armorModel.f_102610_ = living.m_6162_();
                return armorModel;
            }
        });
    }

    public static void updateModifier(LivingEntity livingEntity) {
        int count = BombArmor.numberOfSuit(livingEntity);
        if (count == 0) {
            livingEntity.m_21051_(Attributes.f_22276_).m_22130_(HEALTH_BOOST);
            livingEntity.m_21051_(Attributes.f_22279_).m_22130_(SLOWNESS);
            if (livingEntity instanceof Player) {
                livingEntity.m_21051_(Attributes.f_22283_).m_22130_(ATTACK_SPEED);
            }
        } else if (count == 4) {
            livingEntity.m_21051_(Attributes.f_22276_).m_22130_(HEALTH_BOOST);
            livingEntity.m_21051_(Attributes.f_22276_).m_22125_(HEALTH_BOOST);
        } else if (count == 1) {
            livingEntity.m_21051_(Attributes.f_22279_).m_22130_(SLOWNESS);
            livingEntity.m_21051_(Attributes.f_22279_).m_22125_(SLOWNESS);
            if (livingEntity instanceof Player) {
                livingEntity.m_21051_(Attributes.f_22283_).m_22130_(ATTACK_SPEED);
                livingEntity.m_21051_(Attributes.f_22283_).m_22125_(ATTACK_SPEED);
            }
        } else if (count == 3) {
            livingEntity.m_21051_(Attributes.f_22276_).m_22130_(HEALTH_BOOST);
        }
    }

    public static int numberOfSuit(LivingEntity livingEntity) {
        int count = 0;
        for (ItemStack itemStack : livingEntity.m_6168_()) {
            if (!(itemStack.m_41720_() instanceof BombArmor)) continue;
            ++count;
        }
        return count;
    }
}

