/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.item;

import com.scarasol.zombiekit.block.ShortwaveRadioBlock;
import com.scarasol.zombiekit.block.entity.ShortwaveRadioBlockEntity;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.init.ZombieKitSounds;
import com.scarasol.zombiekit.init.ZombieKitTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PocketRadio
extends Item {
    public PocketRadio(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.m_7203_(world, entity, hand);
        ItemStack itemstack = (ItemStack)ar.m_19095_();
        this.findNearestShelter(entity, itemstack);
        return ar;
    }

    public void findNearestShelter(Player entity, ItemStack itemstack) {
        if (entity == null) {
            return;
        }
        if (!entity.m_9236_().f_46443_) {
            double distance;
            ServerLevel level = (ServerLevel)entity.m_9236_();
            BlockPos entityPos = new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_());
            BlockPos structurePos = level.m_215011_(ZombieKitTags.SHELTER, entityPos, 100, false);
            BlockPos shortwaveRadio = ShortwaveRadioBlock.findNearestRadio(entityPos, (Level)level);
            double distance1 = Double.MAX_VALUE;
            double distance2 = Double.MAX_VALUE;
            String info = "";
            if (structurePos != null) {
                distance1 = Math.pow(entity.m_20185_() - (double)structurePos.m_123341_(), 2.0) + Math.pow(entity.m_20189_() - (double)structurePos.m_123343_(), 2.0);
            }
            if (shortwaveRadio != null) {
                distance2 = Math.pow(entity.m_20185_() - (double)shortwaveRadio.m_123341_(), 2.0) + Math.pow(entity.m_20189_() - (double)shortwaveRadio.m_123343_(), 2.0);
            }
            if (distance1 <= distance2 && structurePos != null) {
                distance = distance1;
                info = Component.m_237110_((String)"zombiekit.message.response1", (Object[])new Object[]{structurePos.m_123341_(), structurePos.m_123343_()}).getString();
            } else {
                BlockEntity blockEntity;
                distance = distance2;
                if (shortwaveRadio != null && (blockEntity = level.m_7702_(shortwaveRadio)) instanceof ShortwaveRadioBlockEntity) {
                    ShortwaveRadioBlockEntity shortwaveRadioBlockEntity = (ShortwaveRadioBlockEntity)blockEntity;
                    info = shortwaveRadioBlockEntity.getContent();
                }
            }
            if (distance <= Math.pow(((Integer)CommonConfig.SIGNAL_RANGE.get()).intValue(), 2.0)) {
                entity.m_213846_((Component)Component.m_237113_((String)info));
                level.m_5594_(null, entityPos, (SoundEvent)ZombieKitSounds.radio_response.get(), SoundSource.PLAYERS, 1.2f, 1.0f);
            } else {
                entity.m_213846_((Component)Component.m_237115_((String)"zombiekit.message.response_none"));
                level.m_5594_(null, entityPos, (SoundEvent)ZombieKitSounds.radio_static_long.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            entity.m_36335_().m_41524_(itemstack.m_41720_(), 100);
        }
    }
}

