/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.inventory;

import com.scarasol.zombiekit.init.ZombieKitItems;
import com.scarasol.zombiekit.init.ZombieKitMenus;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class VacuumPackagingMachineMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guiState = new HashMap();
    public final Level level;
    public final Player player;
    public int x;
    public int y;
    public int z;
    private final ContainerLevelAccess access;
    private final ContainerData data;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private final BlockEntity boundBlockEntity;

    public VacuumPackagingMachineMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, extraData, (ContainerData)new SimpleContainerData(2));
    }

    public VacuumPackagingMachineMenu(int id, Inventory inv, FriendlyByteBuf extraData, ContainerData dataAccess) {
        super((MenuType)ZombieKitMenus.VACUUM_PACKAGING_MACHINE_GUI.get(), id);
        int si;
        this.player = inv.f_35978_;
        this.level = inv.f_35978_.m_9236_();
        this.internal = new ItemStackHandler(4);
        this.data = dataAccess;
        BlockPos pos = extraData.m_130135_();
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.access = ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)pos);
        this.boundBlockEntity = this.level.m_7702_(pos);
        if (this.boundBlockEntity != null) {
            this.boundBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> {
                this.internal = capability;
            });
        }
        this.customSlots.put(0, this.m_38897_((Slot)new SlotItemHandler(this.internal, 0, 31, 21){

            public void m_6654_() {
                super.m_6654_();
                if (VacuumPackagingMachineMenu.this.boundBlockEntity != null) {
                    VacuumPackagingMachineMenu.this.boundBlockEntity.m_6596_();
                }
            }

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41614_();
            }
        }));
        this.customSlots.put(1, this.m_38897_((Slot)new SlotItemHandler(this.internal, 1, 81, 40){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        }));
        this.customSlots.put(2, this.m_38897_((Slot)new SlotItemHandler(this.internal, 2, 31, 61){

            public void m_6654_() {
                super.m_6654_();
                if (VacuumPackagingMachineMenu.this.boundBlockEntity != null) {
                    VacuumPackagingMachineMenu.this.boundBlockEntity.m_6596_();
                }
            }

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() == ZombieKitItems.PLASTIC_BAG.get();
            }
        }));
        this.customSlots.put(3, this.m_38897_((Slot)new SlotItemHandler(this.internal, 3, 133, 61){

            public void m_6654_() {
                super.m_6654_();
                if (VacuumPackagingMachineMenu.this.boundBlockEntity != null) {
                    VacuumPackagingMachineMenu.this.boundBlockEntity.m_6596_();
                }
            }

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() == ZombieKitItems.BATTERY.get();
            }
        }));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.m_38897_(new Slot((Container)inv, sj + (si + 1) * 9, 10 + sj * 18, 93 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.m_38897_(new Slot((Container)inv, si, 10 + si * 18, 151));
        }
        this.m_38884_(dataAccess);
    }

    public double getPackagingProgress() {
        double i = this.data.m_6413_(0);
        double j = this.data.m_6413_(1);
        return i != 0.0 && j != 0.0 ? i / j : 0.0;
    }

    public boolean m_6875_(Player player) {
        if (this.boundBlockEntity != null) {
            return AbstractContainerMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)this.boundBlockEntity.m_58900_().m_60734_());
        }
        return player.m_6084_();
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 0) {
                if (!this.m_38903_(itemstack1, 0, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (!this.m_38903_(itemstack1, 0, 0, false)) {
                if (index < 27 ? !this.m_38903_(itemstack1, 27, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 27, false)) {
                    return ItemStack.f_41583_;
                }
                slot.m_6654_();
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean m_38903_(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.m_41753_()) {
            while (!p_38904_.m_41619_() && !(!p_38907_ ? i >= p_38906_ : i < p_38905_)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.f_38839_.get(i);
                if (slot.m_5857_(itemstack = slot.m_7993_()) && !itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + p_38904_.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), p_38904_.m_41741_()))) {
                        p_38904_.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_5852_(itemstack);
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        p_38904_.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_5852_(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.m_41619_()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (!(!p_38907_ ? i >= p_38906_ : i < p_38905_)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemStack1 = slot1.m_7993_();
                if (itemStack1.m_41619_() && slot1.m_5857_(p_38904_)) {
                    if (p_38904_.m_41613_() > slot1.m_6641_()) {
                        slot1.m_269060_(p_38904_.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_269060_(p_38904_.m_41620_(p_38904_.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

