/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.event;

import com.scarasol.sona.init.SonaMobEffects;
import com.scarasol.sona.manager.RustManager;
import com.scarasol.zombiekit.block.InjectorBlock;
import com.scarasol.zombiekit.block.ShortwaveRadioBlock;
import com.scarasol.zombiekit.client.renderer.FlameThrowerRenderer;
import com.scarasol.zombiekit.combat.SBWCombat;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.entity.ai.goal.FlamethrowerUsingGoal;
import com.scarasol.zombiekit.entity.ai.goal.HeavyMachineGunUsingGoal;
import com.scarasol.zombiekit.entity.mechanics.HeavyMachineGunEntity;
import com.scarasol.zombiekit.entity.mechanics.MortarEntity;
import com.scarasol.zombiekit.entity.mechanics.UvLampEntity;
import com.scarasol.zombiekit.init.ZombieKitItems;
import com.scarasol.zombiekit.init.ZombieKitTags;
import com.scarasol.zombiekit.item.armor.BombArmor;
import com.scarasol.zombiekit.item.armor.ExoArmor;
import com.scarasol.zombiekit.item.weapon.Flamethrower;
import com.scarasol.zombiekit.network.MapVariables;
import com.scarasol.zombiekit.network.MouseInputPacket;
import com.scarasol.zombiekit.network.NetworkHandler;
import com.scarasol.zombiekit.network.SavedDataSyncPacket;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.event.GeoRenderEvent;

@Mod.EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public static void livingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        if (event.getSlot() == EquipmentSlot.MAINHAND || event.getSlot() == EquipmentSlot.OFFHAND) {
            return;
        }
        if (event.getFrom().m_41720_() instanceof BombArmor || event.getTo().m_41720_() instanceof BombArmor) {
            BombArmor.updateModifier(event.getEntity());
        }
        if (event.getFrom().m_41720_() instanceof ExoArmor || event.getTo().m_41720_() instanceof ExoArmor) {
            ExoArmor.updateModifier(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void getAttack(LivingAttackEvent event) {
        Entity entity = event.getSource().m_7640_();
        if (entity != null) {
            event.setCanceled(ExoArmor.reactiveArmor(event.getEntity(), entity));
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        ShortwaveRadioBlock.loadRadioString(event.getLevel());
        InjectorBlock.init();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(EntityJoinLevelEvent event) {
        Entity entity;
        Level level = event.getEntity().m_9236_();
        if (!level.m_5776_() && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            MapVariables mapData = MapVariables.get((LevelAccessor)level);
            if (mapData != null) {
                NetworkHandler.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SavedDataSyncPacket(mapData));
            }
        }
    }

    @SubscribeEvent
    public static void KnockbackEvent(LivingKnockBackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.getPersistentData().m_128471_("CancelKnockback")) {
            livingEntity.getPersistentData().m_128379_("CancelKnockback", false);
            event.setStrength(event.getStrength() * 0.1f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void switchAngleOfMortar(InputEvent.MouseScrollingEvent event) {
        if (Minecraft.m_91087_().f_91074_.m_20202_() instanceof MortarEntity && Minecraft.m_91087_().f_91066_.f_92091_.m_90857_()) {
            NetworkHandler.PACKET_HANDLER.sendToServer((Object)new MouseInputPacket(2, event.getScrollDelta()));
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void mouseInput(InputEvent.MouseButton.Pre event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!(event.getButton() != 0 || player == null || Minecraft.m_91087_().f_91080_ != null || player.m_21023_((MobEffect)SonaMobEffects.STUN.get()) || player.m_21023_((MobEffect)SonaMobEffects.SLIMINESS.get()) && player.m_21023_((MobEffect)SonaMobEffects.FROST.get()))) {
            Entity entity = player.m_20202_();
            if (entity instanceof HeavyMachineGunEntity) {
                HeavyMachineGunEntity heavyMachineGunEntity = (HeavyMachineGunEntity)entity;
                NetworkHandler.PACKET_HANDLER.sendToServer((Object)new MouseInputPacket(0, event.getAction()));
                event.setCanceled(true);
                heavyMachineGunEntity.setFire(event.getAction() == 1);
            } else if (player.m_21205_().m_41720_() instanceof Flamethrower) {
                NetworkHandler.PACKET_HANDLER.sendToServer((Object)new MouseInputPacket(0, event.getAction()));
                event.setCanceled(true);
            } else if (event.getAction() == 1 && ForgeRegistries.ITEMS.getKey((Object)player.m_21205_().m_41720_()).toString().equals("superbwarfare:monitor") && Minecraft.m_91087_().f_91066_.f_92091_.m_90857_() && SBWCombat.droneCover((Player)player, player.m_21205_(), player.m_9236_())) {
                event.setCanceled(true);
            }
        }
    }

    public static boolean illagerWhiteList(Mob mob) {
        return com.scarasol.sona.configuration.CommonConfig.findIndex((String)ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_()).toString(), (List)((List)CommonConfig.ILLAGER_WHITELIST.get())) != -1;
    }

    @SubscribeEvent
    public static void onEntityJoined(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        Level level = entity.m_9236_();
        if (entity instanceof Mob) {
            Mob newSpawn = (Mob)entity;
            if (newSpawn.m_6095_().m_204039_(ZombieKitTags.MACHINE_GUNNER)) {
                if ((newSpawn instanceof Raider || EventHandler.illagerWhiteList(newSpawn)) && ((Boolean)CommonConfig.RAIDER_INDEPENDENCE.get()).booleanValue()) {
                    newSpawn.f_21345_.m_25352_(1, new HeavyMachineGunUsingGoal<Mob>(newSpawn, livingEntity -> {
                        Mob mob;
                        return livingEntity instanceof Mob && ((mob = (Mob)livingEntity).m_6095_().m_204039_(ZombieKitTags.SURVIVORS) || livingEntity instanceof IronGolem || livingEntity instanceof AbstractVillager || livingEntity instanceof Enemy && !(livingEntity instanceof Creeper) && !(livingEntity instanceof NeutralMob) && !EventHandler.illagerWhiteList(mob));
                    }, true));
                } else if (newSpawn instanceof Enemy) {
                    newSpawn.f_21345_.m_25352_(1, new HeavyMachineGunUsingGoal<Mob>(newSpawn, null, true));
                } else {
                    newSpawn.f_21345_.m_25352_(1, new HeavyMachineGunUsingGoal<Mob>(newSpawn, livingEntity -> livingEntity instanceof Enemy && !(livingEntity instanceof Creeper) && !(livingEntity instanceof NeutralMob), false));
                }
            }
            if (newSpawn.m_6095_().m_204039_(ZombieKitTags.FLAMETHROWER)) {
                newSpawn.f_21345_.m_25352_(1, new FlamethrowerUsingGoal<Mob>(newSpawn));
            }
            if ((newSpawn instanceof Raider || EventHandler.illagerWhiteList(newSpawn)) && ((Boolean)CommonConfig.RAIDER_INDEPENDENCE.get()).booleanValue()) {
                newSpawn.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(newSpawn, Mob.class, 5, false, false, livingEntity -> {
                    Mob mob;
                    return livingEntity instanceof Enemy && !(livingEntity instanceof Raider) && !(livingEntity instanceof Creeper) && !(livingEntity instanceof NeutralMob) && (!(livingEntity instanceof Mob) || !EventHandler.illagerWhiteList(mob = (Mob)livingEntity));
                }));
            } else if (newSpawn instanceof Enemy && !(newSpawn instanceof Creeper) && !(newSpawn instanceof NeutralMob)) {
                if (newSpawn.m_6095_().m_204039_(ZombieKitTags.UV_RESISTANCE)) {
                    newSpawn.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal(newSpawn, Mob.class, 5, false, false, livingEntity -> livingEntity instanceof UvLampEntity));
                }
                if (((Boolean)CommonConfig.RAIDER_INDEPENDENCE.get()).booleanValue()) {
                    newSpawn.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(newSpawn, Mob.class, 5, false, false, livingEntity -> {
                        Mob mob;
                        return livingEntity instanceof Raider || livingEntity instanceof Mob && EventHandler.illagerWhiteList(mob = (Mob)livingEntity);
                    }));
                }
                if (newSpawn instanceof Zombie && !(newSpawn instanceof ZombieVillager) && !event.loadedFromDisk()) {
                    if ((double)Mth.m_216271_((RandomSource)level.m_213780_(), (int)1, (int)100) <= (Double)CommonConfig.EQUIPMENT_INITIALIZATION.get() * 100.0) {
                        double i = Mth.m_216271_((RandomSource)level.m_213780_(), (int)1, (int)4);
                        if (1.0 == i) {
                            ItemStack setStack = new ItemStack((ItemLike)ZombieKitItems.MACHETE.get());
                            setStack.m_41764_(1);
                            RustManager.putRust((ItemStack)setStack, (double)75.0);
                            newSpawn.m_21008_(InteractionHand.MAIN_HAND, setStack);
                        } else if (2.0 == i) {
                            ItemStack setStack = new ItemStack((ItemLike)ZombieKitItems.CROWBAR.get());
                            setStack.m_41764_(1);
                            RustManager.putRust((ItemStack)setStack, (double)75.0);
                            newSpawn.m_21008_(InteractionHand.MAIN_HAND, setStack);
                        } else if (3.0 == i) {
                            ItemStack setStack = new ItemStack((ItemLike)ZombieKitItems.FIRE_AXE.get());
                            setStack.m_41764_(1);
                            RustManager.putRust((ItemStack)setStack, (double)75.0);
                            newSpawn.m_21008_(InteractionHand.MAIN_HAND, setStack);
                        } else {
                            ItemStack setStack = new ItemStack((ItemLike)ZombieKitItems.KNIFE.get());
                            setStack.m_41764_(1);
                            RustManager.putRust((ItemStack)setStack, (double)75.0);
                            newSpawn.m_21008_(InteractionHand.MAIN_HAND, setStack);
                        }
                    }
                    if ((double)Mth.m_216271_((RandomSource)level.m_213780_(), (int)1, (int)100) <= (Double)CommonConfig.BOMB_ARMOR_INITIALIZATION.get() * 100.0) {
                        if (Mth.m_216271_((RandomSource)level.m_213780_(), (int)1, (int)100) <= 40) {
                            newSpawn.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ZombieKitItems.BOMB_BOOTS.get()));
                        }
                        if (Mth.m_216271_((RandomSource)level.m_213780_(), (int)1, (int)100) <= 20) {
                            newSpawn.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ZombieKitItems.BOMB_LEGGINGS.get()));
                        }
                        if (Mth.m_216271_((RandomSource)level.m_213780_(), (int)1, (int)100) <= 10) {
                            newSpawn.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ZombieKitItems.BOMB_CHESTPLATE.get()));
                        }
                        if (Mth.m_216271_((RandomSource)level.m_213780_(), (int)1, (int)100) <= 30) {
                            newSpawn.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ZombieKitItems.BOMB_HELMET.get()));
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntitySpawned(MobSpawnEvent.PositionCheck event) {
        ServerLevel serverLevel;
        StructureManager structureFeatureManager;
        Structure configuredStructureFeature;
        ServerLevelAccessor serverLevelAccessor;
        Mob newSpawn = event.getEntity();
        if (newSpawn instanceof Enemy && !(newSpawn instanceof Vex) && (serverLevelAccessor = event.getLevel()) instanceof ServerLevel && (configuredStructureFeature = (Structure)(structureFeatureManager = (serverLevel = (ServerLevel)serverLevelAccessor).m_215010_()).m_220521_().m_175515_(Registries.f_256944_).m_6246_(ZombieKitTags.STRUCTURE)) != null && (event.getSpawnType() == MobSpawnType.NATURAL || event.getSpawnType() == MobSpawnType.STRUCTURE || event.getSpawnType() == MobSpawnType.REINFORCEMENT) && structureFeatureManager.m_220494_(BlockPos.m_274561_((double)event.getX(), (double)event.getY(), (double)event.getZ()), configuredStructureFeature).m_73603_()) {
            BlockState state;
            if (!(newSpawn instanceof Raider) && !(newSpawn instanceof HeavyMachineGunEntity)) {
                event.setResult(Event.Result.DENY);
                event.getEntity().m_146870_();
            }
            if ((state = serverLevel.m_8055_(BlockPos.m_274561_((double)event.getX(), (double)event.getY(), (double)event.getZ()).m_7495_())).m_60734_() == Blocks.f_50470_ || state.m_60734_() == Blocks.f_50069_) {
                for (int i = 0; i < new Random().nextInt(3) + 1; ++i) {
                    PatrollingMonster patrollingMonster = serverLevel.m_213780_().m_188500_() < 0.5 ? (PatrollingMonster)EntityType.f_20513_.m_20615_((Level)serverLevel) : (PatrollingMonster)EntityType.f_20493_.m_20615_((Level)serverLevel);
                    patrollingMonster.m_6034_(event.getX(), event.getY(), event.getZ());
                    patrollingMonster.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(BlockPos.m_274561_((double)event.getX(), (double)event.getY(), (double)event.getZ())), MobSpawnType.EVENT, null, null);
                    serverLevel.m_7967_((Entity)patrollingMonster);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (ExoArmor.numberOfSuit((LivingEntity)player) == 4 && player.m_21255_() && player.m_20142_()) {
            Vec3 vec31 = player.m_20154_();
            Vec3 vec32 = player.m_20184_();
            player.m_20256_(vec32.m_82520_(vec31.f_82479_ * 0.1 + (vec31.f_82479_ * 1.5 - vec32.f_82479_) * 0.5, vec31.f_82480_ * 0.1 + (vec31.f_82480_ * 1.5 - vec32.f_82480_) * 0.5, vec31.f_82481_ * 0.1 + (vec31.f_82481_ * 1.5 - vec32.f_82481_) * 0.5));
        }
    }

    @SubscribeEvent
    public static void projectileHit(ProjectileImpactEvent event) {
        LivingEntity livingEntity;
        EntityHitResult entityHitResult;
        Entity target;
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult && (target = (entityHitResult = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity && ExoArmor.reactiveArmor(livingEntity = (LivingEntity)target, (Entity)event.getProjectile())) {
            event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void flameThrowerRender(GeoRenderEvent.Item.Pre event) {
        ItemStack itemStack = event.getItemStack();
        if (FlameThrowerRenderer.transformType != null && FlameThrowerRenderer.transformType.m_269069_()) {
            event.setCanceled(Minecraft.m_91087_().f_91074_.m_21206_() == itemStack);
        }
    }
}

