/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.entity.projectile;

import com.scarasol.sona.init.SonaMobEffects;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.init.ZombieKitDamageTypes;
import com.scarasol.zombiekit.init.ZombieKitEntities;
import com.scarasol.zombiekit.init.ZombieKitItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class WrenchEntity
extends AbstractArrow
implements ItemSupplier {
    private boolean dealtDamage;
    private boolean accumulating;
    private ItemStack wrenchItem = new ItemStack((ItemLike)ZombieKitItems.WRENCH.get());

    public WrenchEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)ZombieKitEntities.WRENCH.get(), world);
    }

    public WrenchEntity(EntityType<? extends WrenchEntity> type, Level world) {
        super(type, world);
    }

    public WrenchEntity(EntityType<? extends WrenchEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public WrenchEntity(EntityType<? extends WrenchEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public WrenchEntity(Level p_37569_, LivingEntity p_37570_, ItemStack p_37571_) {
        super((EntityType)ZombieKitEntities.WRENCH.get(), p_37570_, p_37569_);
        this.wrenchItem = p_37571_.m_41777_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 p_37575_, Vec3 p_37576_) {
        return this.dealtDamage ? null : super.m_6351_(p_37575_, p_37576_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return ItemStack.f_41583_;
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ZombieKitItems.WRENCH.get());
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        super.m_8119_();
    }

    protected void m_5790_(EntityHitResult p_37573_) {
        Entity entity = p_37573_.m_82443_();
        float f = ((Double)CommonConfig.WRENCH_DAMAGE.get()).floatValue();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.wrenchItem, (MobType)livingentity.m_6336_());
        }
        Entity entity1 = this.m_19749_();
        DamageSource damageSource = ZombieKitDamageTypes.damageSource(entity.m_9236_().m_9598_(), ZombieKitDamageTypes.WRENCH, (Entity)this, (Entity)(entity1 == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.f_12514_;
        if (entity.m_6469_(damageSource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vec3 vec3;
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                if (this.m_150123_() > 0 && (vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.m_150123_() * 0.6)).m_82556_() > 0.0) {
                    livingentity1.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                }
                if (this.accumulating) {
                    livingentity1.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.STUN.get(), 100, 0));
                    livingentity1.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.CONFUSION.get(), 100, 0));
                }
                this.m_7761_(livingentity1);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_(soundevent, 1.0f, 1.0f);
    }

    public static WrenchEntity shoot(Level world, LivingEntity entity, Random random, float power, double damage, int knockback) {
        WrenchEntity entityarrow = new WrenchEntity((EntityType<? extends WrenchEntity>)((EntityType)ZombieKitEntities.WRENCH.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static WrenchEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback, boolean accu) {
        WrenchEntity entityarrow = new WrenchEntity((EntityType<? extends WrenchEntity>)((EntityType)ZombieKitEntities.WRENCH.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        entityarrow.accumulating = accu;
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static WrenchEntity shoot(LivingEntity entity, LivingEntity target) {
        WrenchEntity entityarrow = new WrenchEntity((EntityType<? extends WrenchEntity>)((EntityType)ZombieKitEntities.WRENCH.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(5.0);
        entityarrow.m_36735_(5);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (new Random().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
            super.m_6901_();
        }
    }

    public void m_7378_(CompoundTag p_37578_) {
        super.m_7378_(p_37578_);
        if (p_37578_.m_128425_("Wrench", 10)) {
            this.wrenchItem = ItemStack.m_41712_((CompoundTag)p_37578_.m_128469_("Wrench"));
        }
        this.dealtDamage = p_37578_.m_128471_("DealtDamage");
        this.accumulating = p_37578_.m_128471_("Accumulating");
    }

    public void m_7380_(CompoundTag p_37582_) {
        super.m_7380_(p_37582_);
        p_37582_.m_128365_("Wrench", (Tag)this.wrenchItem.m_41739_(new CompoundTag()));
        p_37582_.m_128379_("DealtDamage", this.dealtDamage);
        p_37582_.m_128379_("Accumulating", this.accumulating);
    }
}

