/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.entity.projectile;

import com.scarasol.sona.init.SonaMobEffects;
import com.scarasol.zombiekit.api.NoAttenuationProjectile;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.data.LaunchSchedule;
import com.scarasol.zombiekit.entity.projectile.LandmineEntity;
import com.scarasol.zombiekit.entity.projectile.ModProjectile;
import com.scarasol.zombiekit.entity.projectile.MolotovCocktailEntity;
import com.scarasol.zombiekit.init.ZombieKitEntities;
import com.scarasol.zombiekit.init.ZombieKitParticleTypes;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MortarShellEntity
extends ModProjectile
implements ItemSupplier,
NoAttenuationProjectile,
GeoEntity {
    @Nullable
    private LaunchSchedule launchSchedule;
    @Nullable
    private ChunkPos currentChunkPos;
    private final ShellEffect effect;
    private boolean firstHit;
    private int lifeTime;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final ShellEffect DEFAULT_EFFECT = shellEntity -> {
        Level.ExplosionInteraction explosionInteraction = (Boolean)CommonConfig.MORTAR_BREAK_BLOCK.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE;
        shellEntity.m_9236_().m_254849_((Entity)shellEntity, shellEntity.m_20185_(), shellEntity.m_20186_(), shellEntity.m_20189_(), (float)((Integer)CommonConfig.MORTAR_EXPLOSION_LEVEL.get()).intValue(), explosionInteraction);
        shellEntity.m_146870_();
    };

    public MortarShellEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<? extends MortarShellEntity>)((EntityType)ZombieKitEntities.MORTAR_SHELL.get()), world, (MortarShellEntity shell) -> {});
    }

    public MortarShellEntity(EntityType<? extends MortarShellEntity> type, Level world) {
        this(type, world, DEFAULT_EFFECT);
    }

    public MortarShellEntity(EntityType<? extends MortarShellEntity> type, LivingEntity owner, Level world, ShellEffect shellEffect) {
        super(type, owner, world);
        this.effect = shellEffect;
        this.noGround = false;
    }

    public MortarShellEntity(EntityType<? extends MortarShellEntity> type, Level world, ShellEffect shellEffect) {
        super(type, world);
        this.effect = shellEffect;
        this.noGround = false;
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("LifeTime")) {
            this.lifeTime = compoundTag.m_128451_("LifeTime");
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("LifeTime", this.lifeTime);
    }

    public void mineLaying() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Random random = new Random();
            serverLevel.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, Level.ExplosionInteraction.NONE);
            for (int i = 0; i < 8; ++i) {
                Vec3 angle = new Vec3(random.nextGaussian(), Math.abs(random.nextGaussian()), random.nextGaussian()).m_82541_();
                LandmineEntity landmine = new LandmineEntity((EntityType<? extends LandmineEntity>)((EntityType)ZombieKitEntities.LANDMINE.get()), (Level)serverLevel);
                landmine.m_146884_(this.m_20182_());
                ModProjectile.initProjectileEntity((AbstractArrow)landmine, (Level)serverLevel, angle, serverLevel.f_46441_, 0.3f, 0.0, 0);
            }
        }
        this.m_146870_();
    }

    public void burn() {
        Level level = this.m_9236_();
        MolotovCocktailEntity.burn(level, this.m_20185_(), this.m_20186_(), this.m_20189_(), ((Integer)CommonConfig.NAPALM_RANGE.get()).intValue());
        level.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, Level.ExplosionInteraction.NONE);
        level.m_6443_(LivingEntity.class, new AABB(this.m_20097_()).m_82400_((double)((Integer)CommonConfig.NAPALM_RANGE.get()).intValue()), target -> !target.m_5825_()).forEach(target -> {
            target.m_6469_(level.m_269111_().m_269387_(), (float)((Integer)CommonConfig.NAPALM_DAMAGE.get()).intValue());
            int time = (Integer)CommonConfig.NAPALM_BURN_TIME.get() * 20;
            target.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.IGNITION.get(), time, 3, false, false));
            target.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.SLIMINESS.get(), time, 0, false, false));
        });
        this.m_146870_();
    }

    public void smoke() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.firstHit) {
                serverLevel.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, Level.ExplosionInteraction.NONE);
                Random random = new Random();
                for (int i = 0; i < 20; ++i) {
                    double x = this.m_20185_() + random.nextDouble(-8.0, 8.0);
                    double z = this.m_20189_() + random.nextDouble(-8.0, 8.0);
                    BlockPos spawnPos = serverLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BlockPos.m_274561_((double)x, (double)this.m_20186_(), (double)z));
                    double y = Math.abs((double)spawnPos.m_123342_() - this.m_20186_()) < 4.0 ? (double)(spawnPos.m_123342_() + 1) : this.m_20186_();
                    serverLevel.m_6443_(LivingEntity.class, new AABB(this.m_20097_()).m_82400_(10.0), target -> !target.m_5825_() && target.m_142582_((Entity)this)).forEach(target -> target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 600, 0, false, false)));
                    serverLevel.m_8795_(player -> true).forEach(player -> serverLevel.m_8624_(player, (ParticleOptions)((SimpleParticleType)ZombieKitParticleTypes.LARGE_SMOKE.get()), true, x, y, z, 1, 0.0, 0.0, 0.0, 0.0));
                }
                this.firstHit = true;
            } else {
                this.m_9236_().m_45976_(LivingEntity.class, new AABB(this.m_20097_()).m_82400_(10.0)).forEach(target -> {
                    target.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.CAMOUFLAGE.get(), 20, 4, false, false));
                    if (!(target instanceof Player)) {
                        target.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.CONFUSION.get(), 20, 0, false, false));
                    }
                });
                if (this.lifeTime++ > 1000) {
                    this.m_146870_();
                }
            }
        }
    }

    @Nullable
    public LaunchSchedule getLaunchSchedule() {
        return this.launchSchedule;
    }

    public void setLaunchSchedule(@Nullable LaunchSchedule launchSchedule) {
        this.launchSchedule = launchSchedule;
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_(x, y, z);
        this.updateForceRegion();
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public ItemStack m_7846_() {
        return ItemStack.f_41583_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.updateForceRegion();
        if (this.f_36703_ && this.firstHit) {
            this.effect.shellEffect(this);
        }
    }

    @Override
    public void doEffects(Level level, double x, double y, double z) {
        Level level2 = this.m_9236_();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            if (this.launchSchedule != null) {
                this.launchSchedule.completeSchedule(serverLevel);
            } else if (this.currentChunkPos != null) {
                serverLevel.m_7726_().f_8325_.m_143145_().m_140849_(TicketType.f_9445_, this.currentChunkPos, 3, (Object)this.currentChunkPos);
            }
            this.effect.shellEffect(this);
        }
    }

    public void updateForceRegion() {
        Level level;
        ChunkPos pos = new ChunkPos(this.m_20097_());
        if (this.launchSchedule == null && !pos.equals((Object)this.currentChunkPos) && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7726_().f_8325_.m_143145_().m_140840_(TicketType.f_9445_, pos, 3, (Object)pos);
            if (this.currentChunkPos != null) {
                serverLevel.m_7726_().f_8325_.m_143145_().m_140849_(TicketType.f_9445_, this.currentChunkPos, 3, (Object)this.currentChunkPos);
            }
            this.currentChunkPos = pos;
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        Level level;
        super.m_142687_(reason);
        if ((reason == Entity.RemovalReason.DISCARDED || reason == Entity.RemovalReason.KILLED) && this.currentChunkPos != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7726_().f_8325_.m_143145_().m_140849_(TicketType.f_9445_, this.currentChunkPos, 3, (Object)this.currentChunkPos);
        }
    }

    public static MortarShellEntity shoot(Level world, LivingEntity entity, double x, double y, double z, RandomSource random, float power, @Nullable LaunchSchedule launchSchedule, ShellEffect effect) {
        MortarShellEntity shell = new MortarShellEntity((EntityType<? extends MortarShellEntity>)((EntityType)ZombieKitEntities.MORTAR_SHELL.get()), entity, world, effect);
        shell.m_146884_(entity.m_20182_().m_82549_(entity.m_20154_().m_82490_(2.0)));
        shell.m_6686_(x, y, z, power, 0.0f);
        shell.m_20225_(true);
        shell.m_36762_(false);
        shell.m_36781_(1.0);
        shell.m_36735_(0);
        shell.setLaunchSchedule(launchSchedule);
        world.m_7967_((Entity)shell);
        return shell;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @FunctionalInterface
    public static interface ShellEffect {
        public void shellEffect(MortarShellEntity var1);
    }
}

