/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.entity.projectile;

import com.scarasol.zombiekit.entity.projectile.ModProjectile;
import com.scarasol.zombiekit.init.ZombieKitEntities;
import com.scarasol.zombiekit.init.ZombieKitItems;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class MolotovCocktailEntity
extends ModProjectile {
    public MolotovCocktailEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public MolotovCocktailEntity(EntityType<? extends MolotovCocktailEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public MolotovCocktailEntity(EntityType<? extends MolotovCocktailEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public MolotovCocktailEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends AbstractArrow>)((EntityType)ZombieKitEntities.MOLOTOV_COCKTAIL.get()), world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)ZombieKitItems.MOLOTOV_COCKTAIL.get());
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ZombieKitItems.MOLOTOV_COCKTAIL.get());
    }

    public static MolotovCocktailEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        MolotovCocktailEntity entityArrow = new MolotovCocktailEntity((EntityType<? extends MolotovCocktailEntity>)((EntityType)ZombieKitEntities.MOLOTOV_COCKTAIL.get()), entity, world);
        entityArrow.m_20254_(100);
        ModProjectile.initProjectileEntity((AbstractArrow)entityArrow, world, entity, random, power, damage, knockback);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityArrow;
    }

    public static void burn(Level level, double x, double y, double z, double radius) {
        double cst_pi = Math.acos(-1.0);
        double cst_tha1 = 2.0 * cst_pi;
        double kx = Mth.m_14107_((double)x);
        double ky = Mth.m_14107_((double)y);
        double kz = Mth.m_14107_((double)z);
        for (double tha1 = 0.0; tha1 <= cst_tha1; tha1 += cst_tha1 / 36.0) {
            block1: for (double tha2 = 0.0; tha2 <= cst_pi; tha2 += cst_pi / 18.0) {
                double sr = 0.0;
                while (sr <= radius) {
                    double sx = sr * Math.sin(tha2) * Math.cos(tha1);
                    double sz = sr * Math.sin(tha2) * Math.sin(tha1);
                    double sy = sr * Math.cos(tha2);
                    BlockPos blockPos = BlockPos.m_274561_((double)(sx = kx + sx), (double)(sy = ky + sy), (double)(sz = kz + sz));
                    if (level.m_8055_(blockPos).m_60734_() instanceof BaseFireBlock) {
                        sr += 1.0;
                        continue;
                    }
                    if (BaseFireBlock.m_49255_((Level)level, (BlockPos)blockPos, (Direction)Direction.DOWN)) {
                        Random random = new Random();
                        if (random.nextInt(10) <= 7) continue block1;
                        level.m_7731_(blockPos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)blockPos), 3);
                        continue block1;
                    }
                    if (!level.m_46859_(blockPos) && !level.m_8055_(blockPos).m_60815_()) continue block1;
                    sr += 1.0;
                }
            }
        }
    }

    @Override
    public void doEffects(Level level, double x, double y, double z) {
        MolotovCocktailEntity.burn(level, x, y, z, 3.0);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), SoundEvents.f_11983_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 500, 1.0, 1.0, 1.0, 0.05);
        }
    }
}

