/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.entity.projectile;

import com.scarasol.zombiekit.api.NoAttenuationProjectile;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.entity.projectile.ModProjectile;
import com.scarasol.zombiekit.init.ZombieKitDamageTypes;
import com.scarasol.zombiekit.init.ZombieKitEntities;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class HeavyMachineGunAmmoEntity
extends ModProjectile
implements NoAttenuationProjectile {
    private int life = 0;

    public HeavyMachineGunAmmoEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends AbstractArrow>)((EntityType)ZombieKitEntities.HEAVY_MACHINE_GUN_AMMO.get()), world);
    }

    public HeavyMachineGunAmmoEntity(EntityType<? extends HeavyMachineGunAmmoEntity> type, Level world) {
        super(type, world);
    }

    public HeavyMachineGunAmmoEntity(EntityType<? extends HeavyMachineGunAmmoEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public HeavyMachineGunAmmoEntity(EntityType<? extends HeavyMachineGunAmmoEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)Blocks.f_50016_);
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (++this.life > 60) {
            this.m_146870_();
        }
    }

    @Override
    public void m_5790_(EntityHitResult entityHitResult) {
        DamageSource ammo2;
        DamageSource ammo1;
        super.m_5790_(entityHitResult);
        Entity entity = entityHitResult.m_82443_();
        Entity owner = this.m_19749_();
        if (owner != null) {
            ammo1 = ZombieKitDamageTypes.damageSource(this.m_9236_().m_9598_(), ZombieKitDamageTypes.HEAVY_MACHINE_GUN, (Entity)this, owner);
            ammo2 = ZombieKitDamageTypes.damageSource(this.m_9236_().m_9598_(), ZombieKitDamageTypes.HEAVY_MACHINE_GUN_BYPASS_ARMOR, (Entity)this, owner);
        } else {
            ammo1 = ZombieKitDamageTypes.damageSource(this.m_9236_().m_9598_(), ZombieKitDamageTypes.HEAVY_MACHINE_GUN, (Entity)this, (Entity)this);
            ammo2 = ZombieKitDamageTypes.damageSource(this.m_9236_().m_9598_(), ZombieKitDamageTypes.HEAVY_MACHINE_GUN_BYPASS_ARMOR, (Entity)this, (Entity)this);
        }
        float armorIgnored = (float)((double)((Integer)CommonConfig.HEAVY_MACHINE_GUN_DAMAGE.get()).intValue() * (Double)CommonConfig.ARMOR_PIERCING_RATE.get());
        float hurt = (float)((Integer)CommonConfig.HEAVY_MACHINE_GUN_DAMAGE.get()).intValue() - armorIgnored;
        int invulnerableTime = entity.f_19802_;
        if (((Boolean)CommonConfig.IGNORING_INVULNERABILITY.get()).booleanValue()) {
            entity.f_19802_ = 0;
        }
        entity.m_6469_(ammo1, hurt);
        if (invulnerableTime <= 10 || ((Boolean)CommonConfig.IGNORING_INVULNERABILITY.get()).booleanValue()) {
            entity.f_19802_ = 0;
        }
        entity.m_6469_(ammo2, armorIgnored);
        this.m_146870_();
    }

    @Override
    public void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        BlockState blockState = this.m_9236_().m_8055_(blockHitResult.m_82425_());
        if (blockState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("forge:glass"))) || blockState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("forge:glass_panes")))) {
            this.m_9236_().m_46953_(blockHitResult.m_82425_(), false, (Entity)this);
        }
    }

    @Override
    public void doEffects(Level level, double x, double y, double z) {
    }

    public static void shoot(Level world, LivingEntity entity, float power, double damage, int knockback) {
        HeavyMachineGunAmmoEntity entityArrow = new HeavyMachineGunAmmoEntity((EntityType<? extends HeavyMachineGunAmmoEntity>)((EntityType)ZombieKitEntities.HEAVY_MACHINE_GUN_AMMO.get()), entity, world);
        entityArrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power, 0.0f);
        entityArrow.m_20225_(true);
        entityArrow.m_36762_(false);
        entityArrow.m_36781_(damage);
        entityArrow.m_36735_(knockback);
        entityArrow.m_20242_(true);
        world.m_7967_((Entity)entityArrow);
    }
}

