/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.entity.projectile;

import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.entity.projectile.FlaresEntity;
import com.scarasol.zombiekit.entity.projectile.ModProjectile;
import com.scarasol.zombiekit.init.ZombieKitEntities;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class FlareGunEntity
extends ModProjectile {
    private int life = 0;

    public FlareGunEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends AbstractArrow>)((EntityType)ZombieKitEntities.FLARE_GUN.get()), world);
    }

    public FlareGunEntity(EntityType<? extends FlareGunEntity> type, Level world) {
        super(type, world);
    }

    public FlareGunEntity(EntityType<? extends FlareGunEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public FlareGunEntity(EntityType<? extends FlareGunEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)Blocks.f_50016_);
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.life > 20) {
            this.doEffects(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_146870_();
        } else {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123815_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.m_188583_() * 0.05, -this.m_20184_().f_82480_ * 0.5, this.f_19796_.m_188583_() * 0.05);
            ++this.life;
        }
        if (this.f_36703_) {
            this.m_146870_();
        }
    }

    @Override
    public void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        this.m_146870_();
    }

    @Override
    public void doEffects(Level level, double x, double y, double z) {
        for (int i = 0; i < (Integer)CommonConfig.WARHEAD_NUMBER.get(); ++i) {
            FlaresEntity flaresEntity = new FlaresEntity((EntityType<? extends FlaresEntity>)((EntityType)ZombieKitEntities.FLARES.get()), level);
            flaresEntity.m_36781_(0.0);
            flaresEntity.m_36735_(0);
            flaresEntity.m_20225_(true);
            flaresEntity.m_20254_(100);
            flaresEntity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            flaresEntity.m_6686_(Mth.m_216263_((RandomSource)level.m_213780_(), (double)-2.0, (double)2.0), Mth.m_216263_((RandomSource)level.m_213780_(), (double)-2.0, (double)2.0), Mth.m_216263_((RandomSource)level.m_213780_(), (double)-2.0, (double)2.0), 1.0f, 0.0f);
            level.m_7967_((Entity)flaresEntity);
        }
        if (level instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            _level.m_7654_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), Vec2.f_82462_, _level, 4, "", (Component)Component.m_237113_((String)""), _level.m_7654_(), null).m_81324_(), "particle minecraft:flame ~ ~ ~ 1 1 1 0.05 500 force");
        }
    }

    public static FlareGunEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        FlareGunEntity entityArrow = new FlareGunEntity((EntityType<? extends FlareGunEntity>)((EntityType)ZombieKitEntities.FLARE_GUN.get()), entity, world);
        ModProjectile.initProjectileEntity((AbstractArrow)entityArrow, world, entity, random, power, damage, knockback);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("zombiekit:flare_gun_fire")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityArrow;
    }
}

