/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.entity.projectile;

import com.scarasol.sona.init.SonaMobEffects;
import com.scarasol.zombiekit.entity.projectile.ModProjectile;
import com.scarasol.zombiekit.init.ZombieKitEntities;
import com.scarasol.zombiekit.init.ZombieKitItems;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class BileJarEntity
extends ModProjectile {
    private final DustParticleOptions bile = new DustParticleOptions(new Vector3f((Vector3fc)Vec3.m_82501_((int)5597999).m_252839_()), 1.0f);

    public BileJarEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public BileJarEntity(EntityType<? extends BileJarEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public BileJarEntity(EntityType<? extends BileJarEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public BileJarEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends AbstractArrow>)((EntityType)ZombieKitEntities.BILE_JAR.get()), world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)ZombieKitItems.BILE_JAR.get());
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ZombieKitItems.BILE_JAR.get());
    }

    @Override
    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public static AbstractArrow shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        BileJarEntity entityArrow = new BileJarEntity((EntityType<? extends BileJarEntity>)((EntityType)ZombieKitEntities.BILE_JAR.get()), entity, world);
        ModProjectile.initProjectileEntity((AbstractArrow)entityArrow, world, entity, random, power, damage, knockback);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityArrow;
    }

    @Override
    public void doEffects(Level level, double x, double y, double z) {
        Vec3 _center = new Vec3(x, y, z);
        List _entfound = level.m_6443_(LivingEntity.class, new AABB(_center, _center).m_82400_(3.5), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).collect(Collectors.toList());
        for (LivingEntity entityiterator : _entfound) {
            entityiterator.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.CONFUSION.get(), 200, 0));
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), SoundEvents.f_11983_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            serverLevel.m_8767_((ParticleOptions)this.bile, x, y, z, 1000, 2.0, 2.0, 2.0, 0.005);
        }
    }
}

