/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.entity.mechanics;

import com.google.common.collect.Sets;
import com.scarasol.sona.init.SonaMobEffects;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.entity.mechanics.Mechanics;
import com.scarasol.zombiekit.init.ZombieKitBlocks;
import com.scarasol.zombiekit.init.ZombieKitEntities;
import com.scarasol.zombiekit.init.ZombieKitItems;
import com.scarasol.zombiekit.init.ZombieKitSounds;
import com.scarasol.zombiekit.init.ZombieKitTags;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class UvLampEntity
extends Mechanics {
    public static final EntityDataAccessor<Boolean> hasBattery = SynchedEntityData.m_135353_(UvLampEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> power = SynchedEntityData.m_135353_(UvLampEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> lightswitch = SynchedEntityData.m_135353_(UvLampEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int RANGE = 6;
    private int time;
    public final Set<BlockPos> posNeedToUpdate = Sets.newHashSet();

    public UvLampEntity(EntityType<? extends Mechanics> type, Level world) {
        super(type, world);
    }

    public UvLampEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<? extends Mechanics>)((EntityType)ZombieKitEntities.UV_LAMP.get()), world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(hasBattery, (Object)false);
        this.f_19804_.m_135372_(power, (Object)0);
        this.f_19804_.m_135372_(lightswitch, (Object)false);
    }

    public boolean isHasBattery() {
        return (Boolean)this.f_19804_.m_135370_(hasBattery);
    }

    public void setHasBattery(boolean hasBattery) {
        this.f_19804_.m_135381_(UvLampEntity.hasBattery, (Object)hasBattery);
    }

    public int getPower() {
        return (Integer)this.f_19804_.m_135370_(power);
    }

    public void setPower(int power) {
        this.f_19804_.m_135381_(UvLampEntity.power, (Object)power);
    }

    public boolean isLightswitch() {
        return (Boolean)this.f_19804_.m_135370_(lightswitch);
    }

    public void setLightswitch(boolean lightswitch) {
        this.f_19804_.m_135381_(UvLampEntity.lightswitch, (Object)lightswitch);
    }

    public void addBlockPos(BlockPos blockPos) {
        if (this.isLightswitch() && this.checkStep(blockPos)) {
            this.posNeedToUpdate.add(blockPos);
        }
    }

    public boolean checkStep(BlockPos blockPos) {
        BlockPos location = this.m_20097_().m_7494_();
        int dx = blockPos.m_123341_() - location.m_123341_();
        int dy = blockPos.m_123342_() - location.m_123342_();
        int dz = blockPos.m_123343_() - location.m_123343_();
        int steps = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        return steps <= 6;
    }

    public void updatePos() {
        if (!this.posNeedToUpdate.isEmpty()) {
            HashSet posNeedToUpdateCopy = Sets.newHashSet(this.posNeedToUpdate);
            Level level = this.m_9236_();
            Vec3 location = this.m_20097_().m_7494_().m_252807_();
            HashSet checkedPos = Sets.newHashSet();
            for (BlockPos pos : posNeedToUpdateCopy) {
                BlockPos checkPos;
                Vec3 direction = pos.m_252807_().m_82546_(location).m_82541_();
                if (direction.equals((Object)Vec3.f_82478_)) continue;
                boolean flag = false;
                int i = 1;
                while (this.checkStep(checkPos = BlockPos.m_274446_((Position)location.m_82549_(direction.m_82490_((double)i))))) {
                    BlockState blockState = level.m_8055_(checkPos);
                    if (!checkPos.equals((Object)this.m_20097_().m_7494_())) {
                        if (blockState.m_60739_((BlockGetter)level, checkPos) != 0) {
                            flag = true;
                        } else if (!checkedPos.contains(checkPos)) {
                            checkedPos.add(checkPos);
                            if (!flag) {
                                BlockHitResult result = level.m_45547_(new ClipContext(this.m_20097_().m_7494_().m_252807_(), checkPos.m_252807_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
                                if (result.m_6662_() == HitResult.Type.MISS && blockState.m_60795_()) {
                                    level.m_7731_(checkPos, ((Block)ZombieKitBlocks.SPREAD_LIGHT.get()).m_49966_(), 3);
                                } else if (result.m_6662_() != HitResult.Type.MISS && blockState.m_60713_((Block)ZombieKitBlocks.SPREAD_LIGHT.get())) {
                                    level.m_7471_(checkPos, false);
                                }
                            } else if (blockState.m_60713_((Block)ZombieKitBlocks.SPREAD_LIGHT.get())) {
                                level.m_7471_(checkPos, false);
                            }
                        }
                    }
                    ++i;
                }
            }
            this.posNeedToUpdate.removeAll(checkedPos);
        }
    }

    public void fillLight() {
        Level level = this.m_9236_();
        for (int x = -6; x <= 6; ++x) {
            for (int y = -6; y <= 6; ++y) {
                for (int z = -6; z <= 6; ++z) {
                    BlockHitResult result;
                    BlockPos blockPos = this.m_20097_().m_7494_().m_7918_(x, y, z);
                    if (blockPos == this.m_20097_().m_7494_() || !level.m_8055_(blockPos).m_60795_() || (result = level.m_45547_(new ClipContext(this.m_20097_().m_7494_().m_252807_(), blockPos.m_252807_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null))).m_6662_() != HitResult.Type.MISS) continue;
                    level.m_7731_(blockPos, ((Block)ZombieKitBlocks.SPREAD_LIGHT.get()).m_49966_(), 3);
                }
            }
        }
    }

    public void clearLight() {
        Level level = this.m_9236_();
        for (int x = -6; x <= 6; ++x) {
            for (int y = -6; y <= 6; ++y) {
                for (int z = -6; z <= 6; ++z) {
                    BlockPos blockPos = this.m_20097_().m_7494_().m_7918_(x, y, z);
                    if (!level.m_8055_(blockPos).m_60713_((Block)ZombieKitBlocks.SPREAD_LIGHT.get())) continue;
                    level.m_7471_(blockPos, false);
                }
            }
        }
    }

    public void popBattery() {
        ItemStack itemStack = new ItemStack((ItemLike)ZombieKitItems.BATTERY.get(), 1);
        itemStack.m_41721_(100 - this.getPower());
        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), itemStack);
        itemEntity.m_32010_(10);
        this.m_9236_().m_7967_((Entity)itemEntity);
        this.setHasBattery(false);
        this.setPower(0);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        Level level = this.m_9236_();
        if (!this.isHasBattery() && player.m_21206_().m_41720_() == ZombieKitItems.WRENCH.get() && player.m_21205_().m_41720_() == ZombieKitItems.BATTERY.get()) {
            this.setHasBattery(true);
            this.setPower(100 - player.m_21205_().m_41773_());
            if (!player.m_7500_()) {
                player.m_21205_().m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isHasBattery() && player.m_21206_().m_41720_() == ZombieKitItems.WRENCH.get()) {
            this.popBattery();
            return InteractionResult.SUCCESS;
        }
        if (player.m_21205_().m_41720_() == ZombieKitItems.WRENCH.get()) {
            if (this.isHasBattery()) {
                this.popBattery();
            }
            if (this.isLightswitch()) {
                this.clearLight();
            }
            ItemStack itemStack = new ItemStack((ItemLike)ZombieKitItems.UV_LAMP.get(), 1);
            itemStack.m_41721_(20 - Mth.m_14143_((float)this.m_21223_()));
            ItemEntity itemEntity = new ItemEntity(level, this.m_20185_(), this.m_20186_(), this.m_20189_(), itemStack);
            itemEntity.m_32010_(10);
            level.m_7967_((Entity)itemEntity);
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (this.isLightswitch()) {
            this.m_9236_().m_46961_(this.m_20097_().m_7494_(), false);
            this.m_9236_().m_46961_(this.m_20097_().m_7494_().m_7494_(), false);
        }
        if (this.isHasBattery()) {
            this.popBattery();
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("HasBattery")) {
            this.setHasBattery(compoundTag.m_128471_("HasBattery"));
        }
        if (compoundTag.m_128441_("Power")) {
            this.setPower(compoundTag.m_128451_("Power"));
        }
        if (compoundTag.m_128441_("Lightswitch")) {
            this.setLightswitch(compoundTag.m_128471_("Lightswitch"));
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Power", this.getPower());
        compoundTag.m_128379_("HasBattery", this.isHasBattery());
        compoundTag.m_128379_("Lightswitch", this.isLightswitch());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20096_()) {
            this.m_21557_(true);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isHasBattery()) {
                if (this.m_9236_().m_277086_(this.m_20097_()) > 0) {
                    if (this.isLightswitch()) {
                        this.setLightswitch(false);
                        this.clearLight();
                        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ZombieKitSounds.turn_on.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    if (this.m_9236_().m_46467_() % (long)((Integer)CommonConfig.LAMP_POWER.get()).intValue() == 0L) {
                        this.setPower(Math.min(this.getPower() + 1, 100));
                    }
                } else if (this.getPower() > 0) {
                    if (!this.isLightswitch()) {
                        this.setLightswitch(true);
                        this.fillLight();
                        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ZombieKitSounds.turn_on.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    this.time = (this.time + 1) % 5;
                    if (this.time == 0) {
                        this.searchUndead();
                    }
                    if (this.m_9236_().m_46467_() % (long)((Integer)CommonConfig.LAMP_POWER.get()).intValue() == 0L) {
                        this.setPower(Math.max(this.getPower() - 1, 0));
                    }
                } else if (this.isLightswitch()) {
                    this.setLightswitch(false);
                    this.clearLight();
                    this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ZombieKitSounds.turn_on.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            } else if (this.isLightswitch()) {
                this.setLightswitch(false);
                this.clearLight();
                this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ZombieKitSounds.turn_on.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            if (this.isLightswitch()) {
                this.updatePos();
            }
        }
    }

    public void searchUndead() {
        Vec3 _center = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        ArrayList entFound = new ArrayList(this.m_9236_().m_6443_(Mob.class, new AABB(_center, _center).m_82377_(13.0, 4.0, 13.0), e -> true));
        for (Mob entityIterator : entFound) {
            if (entityIterator.m_6336_() != MobType.f_21641_ && com.scarasol.sona.configuration.CommonConfig.findIndex((String)ForgeRegistries.ENTITY_TYPES.getKey((Object)entityIterator.m_6095_()).toString(), (List)((List)com.scarasol.sona.configuration.CommonConfig.INFECTION_SOURCE_MOB.get())) == -1 || entityIterator.m_6095_().m_204039_(ZombieKitTags.UV_RESISTANCE) || !entityIterator.m_142582_((Entity)this)) continue;
            if (((Boolean)CommonConfig.HIGH_PERFORMANCE_MODE.get()).booleanValue()) {
                entityIterator.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.IGNITION.get(), 20, 2, false, false));
            }
            entityIterator.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20, 1, false, false));
            entityIterator.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 1, false, false));
            entityIterator.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.FRAGILITY.get(), 20, 2, false, false));
            if (entityIterator.m_5448_() != null && entityIterator.m_5448_().m_6084_() && !entityIterator.m_6095_().m_204039_(ZombieKitTags.UV_NONRESISTANCE)) continue;
            entityIterator.m_6710_(null);
            BlockPos blockPos = entityIterator.m_20097_();
            BlockPos uvPos = this.m_20097_();
            BlockPos newPos = blockPos.m_7918_(blockPos.m_123341_() - uvPos.m_123341_(), blockPos.m_123342_() - uvPos.m_123342_(), blockPos.m_123343_() - uvPos.m_123343_());
            entityIterator.m_21573_().m_26519_((double)newPos.m_123341_(), (double)newPos.m_123342_(), (double)newPos.m_123343_(), 1.0);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 10.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }
}

