/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.entity.mechanics;

import com.scarasol.sona.util.SonaMath;
import com.scarasol.zombiekit.api.FixedVehicle;
import com.scarasol.zombiekit.block.entity.MortarRackBlockEntity;
import com.scarasol.zombiekit.data.LaunchSchedule;
import com.scarasol.zombiekit.entity.ai.control.MortarLookControl;
import com.scarasol.zombiekit.entity.ai.goal.MortarUsingGoal;
import com.scarasol.zombiekit.entity.mechanics.Mechanics;
import com.scarasol.zombiekit.entity.projectile.MortarShellEntity;
import com.scarasol.zombiekit.init.ZombieKitEntities;
import com.scarasol.zombiekit.init.ZombieKitItems;
import com.scarasol.zombiekit.init.ZombieKitSounds;
import com.scarasol.zombiekit.init.ZombieKitTags;
import com.scarasol.zombiekit.item.projectile.MortarShell;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MortarEntity
extends Mechanics
implements GeoEntity,
FixedVehicle {
    public static final EntityDataAccessor<Float> ANGLE = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> AZIMUTH = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> SHELL = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private long launchTimestamp;
    private int launchWaiting = 20;
    private LaunchSchedule currentSchedule;
    public static final float VELOCITY = 3.5f;
    private BlockPos rack;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MortarEntity(EntityType<? extends Mechanics> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21530_();
        this.f_21365_ = new MortarLookControl(this);
    }

    public MortarEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<? extends Mechanics>)((EntityType)ZombieKitEntities.MORTAR.get()), world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, new MortarUsingGoal<MortarEntity>(this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGLE, (Object)Float.valueOf(-45.0f));
        this.f_19804_.m_135372_(AZIMUTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TEXTURE, (Object)"mortar");
        this.f_19804_.m_135372_(SHELL, (Object)"Empty");
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("Angle")) {
            this.setAngle(compoundTag.m_128457_("Angle"));
        }
        if (compoundTag.m_128441_("Azimuth")) {
            this.setAzimuth(compoundTag.m_128457_("Azimuth"));
        }
        if (compoundTag.m_128441_("Shell")) {
            this.setShell(compoundTag.m_128461_("Shell"));
        }
        if (compoundTag.m_128441_("LaunchTimestamp")) {
            this.launchTimestamp = compoundTag.m_128454_("LaunchTimestamp");
        }
        if (compoundTag.m_128441_("RackX")) {
            this.rack = new BlockPos(compoundTag.m_128451_("RackX"), compoundTag.m_128451_("RackY"), compoundTag.m_128451_("RackZ"));
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128350_("Angle", this.getAngle());
        compoundTag.m_128350_("Azimuth", this.getAzimuth());
        compoundTag.m_128359_("Shell", this.getShellStr());
        compoundTag.m_128356_("LaunchTimestamp", this.launchTimestamp);
        if (this.rack != null) {
            compoundTag.m_128405_("RackX", this.rack.m_123341_());
            compoundTag.m_128405_("RackY", this.rack.m_123342_());
            compoundTag.m_128405_("RackZ", this.rack.m_123343_());
        }
    }

    public BlockPos getRack() {
        return this.rack;
    }

    public void setRack(BlockPos rack) {
        this.rack = rack;
    }

    public LaunchSchedule getCurrentSchedule() {
        return this.currentSchedule;
    }

    public void setCurrentSchedule(LaunchSchedule currentSchedule) {
        this.currentSchedule = currentSchedule;
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public String getModel() {
        if (this.getShell() == null) {
            return "mortar_without_shell";
        }
        return "mortar_with_shell";
    }

    public float getAngle() {
        return ((Float)this.f_19804_.m_135370_(ANGLE)).floatValue();
    }

    public void setAngle(float angle) {
        angle = Math.max(Math.min(-45.0f, angle), -85.0f);
        this.f_19804_.m_135381_(ANGLE, (Object)Float.valueOf(angle));
    }

    public void setAzimuth(float azimuth) {
        this.f_19804_.m_135381_(AZIMUTH, (Object)Float.valueOf(azimuth));
    }

    public float getAzimuth() {
        return ((Float)this.f_19804_.m_135370_(AZIMUTH)).floatValue();
    }

    @Nullable
    public Item getShell() {
        String str = this.getShellStr();
        if ("Empty".equals(str)) {
            return null;
        }
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(str));
    }

    public String getShellStr() {
        return (String)this.f_19804_.m_135370_(SHELL);
    }

    public void setShell(String shell) {
        this.f_19804_.m_135381_(SHELL, (Object)shell);
    }

    public void setShell(@Nullable Item item) {
        if (item == null) {
            this.setShell("Empty");
            return;
        }
        this.setShell(ForgeRegistries.ITEMS.getKey((Object)item).toString());
    }

    public void setShell(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            this.setShell((Item)null);
            return;
        }
        this.setShell(itemStack.m_41720_());
    }

    public boolean reload(Item item) {
        if (item instanceof MortarShell) {
            this.setShell(item);
            this.launchWaiting = 20;
            return true;
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_146926_(this.getAngle());
        this.m_5616_(this.getAzimuth());
        this.m_5618_(this.m_6080_());
        this.m_146922_(this.m_6080_());
        List passengers = this.m_20197_();
        if (passengers.size() == 0) {
            this.tryMakeMobRide();
        } else {
            Object e = passengers.get(0);
            if (e instanceof Player) {
                Player player = (Player)e;
                this.turnMortar(player);
            }
            if (this.checkLaunch() && this.launchWaiting-- == 0) {
                this.executeLaunch((Entity)passengers.get(0));
                this.launchWaiting = -1;
            }
        }
    }

    public void turnMortar(Player player) {
        Vec3 passengerViewer = player.m_20252_(1.0f);
        Vec3 horizontalVec = new Vec3((double)(-Mth.m_14031_((float)(-this.getAzimuth() * ((float)Math.PI / 180) - (float)Math.PI))), 0.0, (double)(-Mth.m_14089_((float)(-this.getAzimuth() * ((float)Math.PI / 180) - (float)Math.PI)))).m_82541_();
        Vec3 horizontalViewer = new Vec3(passengerViewer.f_82479_, 0.0, passengerViewer.f_82481_).m_82541_();
        Vec3 limit1 = horizontalVec.m_82524_((float)Math.toRadians(-30.0));
        Vec3 limit2 = horizontalVec.m_82524_((float)Math.toRadians(30.0));
        float degree = (float)SonaMath.vectorDegreeCalculate((Vec3)horizontalVec, (Vec3)horizontalViewer);
        if (degree >= 30.0f) {
            if (SonaMath.vectorDegreeCalculate((Vec3)limit1, (Vec3)horizontalViewer) < SonaMath.vectorDegreeCalculate((Vec3)limit2, (Vec3)horizontalViewer)) {
                this.setAzimuth(Mth.m_14177_((float)(this.getAzimuth() + Math.min((degree + 30.0f) / 2.0f, 2.5f))));
            } else {
                this.setAzimuth(Mth.m_14177_((float)(this.getAzimuth() - Math.min((degree - 30.0f) / 2.0f, 2.5f))));
            }
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        return null;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_((Item)ZombieKitItems.WRENCH.get())) {
            ItemEntity entityToSpawn = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ZombieKitItems.MORTAR_SUMMON.get()));
            entityToSpawn.m_32010_(10);
            this.m_9236_().m_7967_((Entity)entityToSpawn);
            this.m_146870_();
        } else if (!player.m_6144_()) {
            if (!this.m_20197_().isEmpty()) {
                ((Entity)this.m_20197_().get(0)).m_8127_();
            }
            player.m_146922_(this.getAzimuth());
            player.m_20329_((Entity)this);
        } else {
            this.setAzimuth(player.m_146908_());
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public void tryMakeMobRide() {
        List list = this.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148353_().m_26883_(5.0), (LivingEntity)this, this.m_20191_().m_82377_(2.0, 2.0, 2.0));
        if (!list.isEmpty()) {
            list.sort((l1, l2) -> {
                double a = Math.pow(l1.m_20185_() - this.m_20185_(), 2.0) + Math.pow(l1.m_20189_() - this.m_20189_(), 2.0);
                double b = Math.pow(l2.m_20185_() - this.m_20185_(), 2.0) + Math.pow(l2.m_20189_() - this.m_20189_(), 2.0);
                return Double.compare(a, b);
            });
            for (LivingEntity entity : list) {
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                if (!entity.m_6095_().m_204039_(ZombieKitTags.ARTILLERY) || mob.m_21525_() || mob.m_20202_() != null) continue;
                mob.m_20329_((Entity)this);
                mob.m_146922_(this.f_20883_);
                mob.m_5616_(this.f_20883_);
                mob.m_5618_(this.f_20883_);
                mob.m_21530_();
                break;
            }
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void m_5634_(float amount) {
    }

    @Nullable
    public static BlockPos getCoverPos(Entity player) {
        Vec3 position = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 vec3 = player.m_20154_();
        Level level = player.m_9236_();
        for (int i = 0; i < 200; ++i) {
            BlockPos pos = BlockPos.m_274446_((Position)(position = position.m_82549_(vec3)));
            BlockState blockState = level.m_8055_(pos);
            if (!blockState.m_60815_()) continue;
            return pos;
        }
        return null;
    }

    public static Vec3 calculateDroneVector(float x, float y) {
        float f = x * ((float)Math.PI / 180);
        float f1 = -y * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public boolean reload() {
        BlockEntity blockEntity;
        if (this.rack != null && (blockEntity = this.m_9236_().m_7702_(this.rack)) instanceof MortarRackBlockEntity) {
            MortarRackBlockEntity mortarRackBlockEntity = (MortarRackBlockEntity)blockEntity;
            ItemStack itemStack = mortarRackBlockEntity.popShell();
            if (!itemStack.m_41619_()) {
                return this.reload(itemStack.m_41720_());
            }
        } else {
            this.rack = null;
        }
        return false;
    }

    public boolean checkLaunch() {
        return this.getShell() instanceof MortarShell && this.m_9236_().m_46467_() - this.launchTimestamp > 80L;
    }

    public void launch(boolean accurate) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 angle = this.m_20154_();
            RandomSource randomSource = serverLevel.m_213780_();
            double x = angle.f_82479_;
            double y = angle.f_82480_;
            double z = angle.f_82481_;
            float power = 3.5f;
            if (!accurate) {
                x += randomSource.m_188583_() * 0.02;
                y += randomSource.m_188583_() * 0.02;
                z += randomSource.m_188583_() * 0.02;
                power = (float)((double)power + randomSource.m_188583_() * 0.02);
            }
            this.launchTimestamp = serverLevel.m_46467_();
            serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ZombieKitSounds.mortar_launch.get(), SoundSource.PLAYERS, 2.0f, 0.0f);
            MortarShellEntity.shoot((Level)serverLevel, (LivingEntity)this, x, y, z, serverLevel.m_213780_(), power, this.currentSchedule, ((MortarShell)this.getShell()).getEffect());
            this.currentSchedule = null;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + angle.f_82479_ * 2.0, this.m_20186_() + angle.f_82480_ * 2.0, this.m_20189_() + angle.f_82481_ * 2.0, 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 40, 1.5, 0.2, 1.5, 0.01);
            this.setShell("Empty");
        }
    }

    public void executeLaunch(Entity passenger) {
        MortarRackBlockEntity blockEntity;
        BlockEntity blockEntity2;
        if (passenger instanceof Player || this.getRack() != null && (blockEntity2 = this.m_9236_().m_7702_(this.getRack())) instanceof MortarRackBlockEntity && (blockEntity = (MortarRackBlockEntity)blockEntity2).hasTable()) {
            this.launch(true);
        } else {
            this.launch(false);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 0.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1000.0);
        return builder;
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(entity)) {
            Vec3 angle = new Vec3(this.m_20154_().f_82479_, 0.0, this.m_20154_().f_82481_).m_82524_(0.7853982f).m_82541_().m_82490_(1.2);
            moveFunction.m_20372_(entity, this.m_20185_() + angle.f_82479_, this.m_20186_(), this.m_20189_() + angle.f_82481_);
        }
    }

    public double m_6048_() {
        return 0.0;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
    }

    private PlayState procedurePredicate(AnimationState event) {
        AnimationController controller = event.getController();
        if (!controller.isPlayingTriggeredAnimation() && (controller.getCurrentRawAnimation() == null || event.getController().hasAnimationFinished())) {
            controller.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)ZombieKitItems.MORTAR_COMPONENTS.get()));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedureController", 0, this::procedurePredicate).receiveTriggeredAnimations()});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean validXRot(LivingEntity livingEntity, float xRot) {
        return true;
    }

    @Override
    public boolean validYRot(LivingEntity livingEntity, float yRot) {
        Vec3 horizontalViewer;
        Vec3 passengerViewer = this.m_20171_(livingEntity.m_146909_(), yRot);
        Vec3 horizontalVec = new Vec3((double)(-Mth.m_14031_((float)(-this.getAzimuth() * ((float)Math.PI / 180) - (float)Math.PI))), 0.0, (double)(-Mth.m_14089_((float)(-this.getAzimuth() * ((float)Math.PI / 180) - (float)Math.PI)))).m_82541_();
        return SonaMath.vectorDegreeCalculate((Vec3)horizontalVec, (Vec3)(horizontalViewer = new Vec3(passengerViewer.f_82479_, 0.0, passengerViewer.f_82481_).m_82541_())) <= 45.0;
    }

    public int m_8132_() {
        return 2;
    }

    public int m_8085_() {
        return 0;
    }

    public int m_21529_() {
        return 3;
    }

    @Override
    public CameraType getVehicleCameraType() {
        return CameraType.THIRD_PERSON_BACK;
    }
}

