/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.entity.mechanics;

import com.scarasol.sona.init.SonaMobEffects;
import com.scarasol.sona.util.SonaMath;
import com.scarasol.zombiekit.api.FixedVehicle;
import com.scarasol.zombiekit.entity.mechanics.Mechanics;
import com.scarasol.zombiekit.entity.projectile.HeavyMachineGunAmmoEntity;
import com.scarasol.zombiekit.init.ZombieKitEntities;
import com.scarasol.zombiekit.init.ZombieKitItems;
import com.scarasol.zombiekit.init.ZombieKitSounds;
import com.scarasol.zombiekit.init.ZombieKitTags;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HeavyMachineGunEntity
extends Mechanics
implements GeoEntity,
FixedVehicle {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(HeavyMachineGunEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> OVERLOAD = SynchedEntityData.m_135353_(HeavyMachineGunEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(HeavyMachineGunEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final AttributeModifier ATTRIBUTE_MODIFIER = new AttributeModifier(UUID.fromString("1CCA8D2D-9A0B-3FF2-E505-EF4A439570C3"), "machine_gun", 20.0, AttributeModifier.Operation.ADDITION);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation SHOOT_ANI = RawAnimation.begin().thenPlay("shoot");
    private static final RawAnimation IDLE_ANI = RawAnimation.begin().thenLoop("idle");
    private boolean init;
    private double temperature = 0.0;
    private int cloudTime;
    private boolean fire;
    private int coolDownTime;

    public HeavyMachineGunEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<HeavyMachineGunEntity>)((EntityType)ZombieKitEntities.HEAVY_MACHINE_GUN.get()), world);
    }

    public HeavyMachineGunEntity(EntityType<HeavyMachineGunEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21530_();
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_8119_() {
        Object e;
        super.m_8119_();
        this.heat();
        if (this.m_20202_() == null) {
            this.m_5618_(this.f_20884_);
        } else {
            Entity entity = this.m_20202_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.m_5618_(livingEntity.f_20883_);
                this.f_20884_ = livingEntity.f_20883_;
            }
        }
        List passengers = this.m_20197_();
        if (passengers.size() != 0 && (e = passengers.get(0)) instanceof LivingEntity) {
            LivingEntity passenger = (LivingEntity)e;
            this.turnGunpoint(passenger);
            if (passenger instanceof Player) {
                Player player = (Player)passenger;
                if (this.fire) {
                    if (this.coolDownTime++ % 4 != 0) return;
                    if (this.checkCanFire(player)) {
                        this.fire();
                        return;
                    }
                    if (this.m_9236_().m_5776_()) return;
                    this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ZombieKitSounds.heavy_machine_gun_trigger.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    return;
                }
            }
            this.coolDownTime = 0;
            return;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.init) {
                BlockState state;
                StructureManager structureFeatureManager = serverLevel.m_215010_();
                Structure configuredStructureFeature = (Structure)structureFeatureManager.m_220521_().m_175515_(Registries.f_256944_).m_6246_(ZombieKitTags.STRUCTURE);
                if (configuredStructureFeature != null && structureFeatureManager.m_220494_(BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()), configuredStructureFeature).m_73603_() && (state = serverLevel.m_8055_(BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()).m_7495_())).m_60734_().m_49965_().m_61081_("facing") instanceof EnumProperty) {
                    GunDirection direction = GunDirection.getDirection(state.m_60734_().m_49965_().m_61081_("facing").toString().toUpperCase());
                    this.m_5618_(direction.getAngle());
                    this.f_20884_ = direction.getAngle();
                    this.m_5616_(direction.getAngle());
                }
                this.init = true;
            }
        }
        this.tryMakeMobRide();
    }

    public boolean isFire() {
        return this.fire;
    }

    public void setFire(boolean fire) {
        this.fire = fire;
    }

    public boolean checkCanFire(Player player) {
        if (this.getOverload()) {
            return false;
        }
        if (player.m_7500_()) {
            return true;
        }
        List<ItemStack> ammo = player.m_150109_().f_35974_.stream().filter(itemStack -> itemStack.m_204117_(ZombieKitTags.MACHINE_GUN_AMMO)).toList();
        if (!ammo.isEmpty()) {
            if (!this.m_9236_().m_5776_()) {
                ammo.get(0).m_41774_(1);
            }
            return true;
        }
        return false;
    }

    public void heat() {
        Level level;
        if (this.getOverload()) {
            this.temperature = Math.max(this.temperature - 0.05, 0.0);
            if (this.temperature < 50.0) {
                this.setOverload(false);
            }
        } else {
            this.temperature = Math.max(this.temperature - 0.1, 0.0);
        }
        this.cloudTime = (this.cloudTime + 1) % 10;
        Vec3 angle = this.m_20252_(1.0f);
        if (this.temperature > 50.0 && this.cloudTime % 10 == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + angle.f_82479_, this.m_20186_() + 1.5, this.m_20189_() + angle.f_82481_, 0, 0.0, 2.0, 0.0, 0.1);
            return;
        }
        if (this.temperature > 75.0 && this.cloudTime % 5 == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + angle.f_82479_, this.m_20186_() + 1.5, this.m_20189_() + angle.f_82481_, 0, 0.0, 2.0, 0.0, 0.1);
            if (this.temperature > 99.0) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ZombieKitSounds.heavy_machine_gun_overload.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.setOverload(true);
            }
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("Temperature")) {
            this.temperature = compoundTag.m_128459_("Temperature");
        }
        if (compoundTag.m_128441_("Overload")) {
            this.setOverload(compoundTag.m_128471_("Overload"));
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128347_("Temperature", this.temperature);
        compoundTag.m_128379_("Overload", this.getOverload());
    }

    public void turnGunpoint(LivingEntity passenger) {
        float x;
        Vec3 passengerViewer = passenger.m_20252_(1.0f);
        Vec3 horizontalVec = new Vec3((double)(-Mth.m_14031_((float)(-this.f_20883_ * ((float)Math.PI / 180) - (float)Math.PI))), 0.0, (double)(-Mth.m_14089_((float)(-this.f_20883_ * ((float)Math.PI / 180) - (float)Math.PI)))).m_82541_();
        Vec3 horizontalViewer = new Vec3(passengerViewer.f_82479_, 0.0, passengerViewer.f_82481_).m_82541_();
        passenger.m_5618_(this.f_20883_);
        if (SonaMath.vectorDegreeCalculate((Vec3)horizontalVec, (Vec3)horizontalViewer) <= 60.01) {
            float y = passenger instanceof Player ? passenger.m_146908_() : passenger.m_6080_();
            this.m_146922_(y);
            this.m_5616_(this.m_146908_());
        }
        if ((x = passenger.m_146909_()) <= 30.0f && x >= -50.0f) {
            this.m_146926_(x);
        }
    }

    public void tryMakeMobRide() {
        List list = this.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148353_().m_26883_(5.0), (LivingEntity)this, this.m_20191_().m_82377_(2.0, 2.0, 2.0));
        if (!list.isEmpty()) {
            list.sort((l1, l2) -> {
                double a = Math.pow(l1.m_20185_() - this.m_20185_(), 2.0) + Math.pow(l1.m_20189_() - this.m_20189_(), 2.0);
                double b = Math.pow(l2.m_20185_() - this.m_20185_(), 2.0) + Math.pow(l2.m_20189_() - this.m_20189_(), 2.0);
                return Double.compare(a, b);
            });
            for (LivingEntity entity : list) {
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                if (!entity.m_6095_().m_204039_(ZombieKitTags.MACHINE_GUNNER) || mob.m_21525_() || mob.m_20202_() != null) continue;
                mob.m_20329_((Entity)this);
                mob.m_146922_(this.f_20883_);
                mob.m_5616_(this.f_20883_);
                mob.m_5618_(this.f_20883_);
                AttributeInstance attributeInstance = mob.m_21204_().m_22146_(Attributes.f_22277_);
                if (attributeInstance == null) continue;
                attributeInstance.m_22130_(ATTRIBUTE_MODIFIER);
                attributeInstance.m_22125_(ATTRIBUTE_MODIFIER);
                mob.m_21530_();
                break;
            }
        }
    }

    public void fire() {
        Object e;
        List passengers = this.m_20197_();
        if (passengers.size() != 0 && (e = passengers.get(0)) instanceof LivingEntity) {
            Object e2;
            LivingEntity owner = (LivingEntity)e;
            owner.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.EXPOSURE.get(), 20, 3, false, false));
            if (!this.m_9236_().f_46443_) {
                HeavyMachineGunAmmoEntity.shoot(this.m_9236_(), owner, 8.0f, 0.0, 0);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ZombieKitSounds.heavy_machine_gun_fire.get(), SoundSource.BLOCKS, 4.0f, 1.0f);
                if (!this.m_21023_((MobEffect)SonaMobEffects.FROST.get()) && !this.m_203117_()) {
                    this.temperature = Math.min(this.temperature + 0.9, 100.0);
                }
            }
            if ((e2 = passengers.get(0)) instanceof Player) {
                Player player = (Player)e2;
                player.m_19884_((double)Mth.m_216267_((RandomSource)this.m_9236_().m_213780_(), (float)-8.0f, (float)8.0f), (double)Mth.m_216267_((RandomSource)this.m_9236_().m_213780_(), (float)-10.0f, (float)-5.0f));
            }
        }
        this.triggerAnim("procedureController", "shoot");
    }

    public boolean canSee(Entity livingEntity) {
        Vec3 horizontalDis;
        boolean XRange;
        double x = livingEntity.m_20185_();
        double y = livingEntity.m_20186_();
        double z = livingEntity.m_20189_();
        Vec3 horizontalVec = new Vec3((double)(-Mth.m_14031_((float)(-this.f_20883_ * ((float)Math.PI / 180) - (float)Math.PI))), 0.0, (double)(-Mth.m_14089_((float)(-this.f_20883_ * ((float)Math.PI / 180) - (float)Math.PI))));
        boolean bl = XRange = SonaMath.vectorDegreeCalculate((Vec3)horizontalVec, (Vec3)(horizontalDis = new Vec3(x - this.m_20185_(), 0.0, z - this.m_20189_()))) < 60.0;
        boolean YRange = y > this.m_20186_() ? Math.toDegrees(Math.atan((y - this.m_20186_()) / horizontalDis.m_82553_())) < 30.0 : (y < this.m_20186_() ? Math.toDegrees(Math.atan((this.m_20186_() - y) / horizontalDis.m_82553_())) < 50.0 : true);
        return XRange && YRange;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(OVERLOAD, (Object)false);
        this.f_19804_.m_135372_(TEXTURE, (Object)"m2_machine_gun");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public void setOverload(boolean overload) {
        this.f_19804_.m_135381_(OVERLOAD, (Object)overload);
    }

    public boolean getOverload() {
        return (Boolean)this.f_19804_.m_135370_(OVERLOAD);
    }

    @Override
    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public double m_6048_() {
        return super.m_6048_() - 0.8;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
    }

    public void m_5634_(float p_21116_) {
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        super.m_6071_(sourceentity, hand);
        if (itemstack.m_150930_((Item)ZombieKitItems.WRENCH.get())) {
            ItemEntity entityToSpawn = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ZombieKitItems.HEAVY_MACHINE_GUN_SUMMON.get()));
            entityToSpawn.m_32010_(10);
            this.m_9236_().m_7967_((Entity)entityToSpawn);
            this.m_146870_();
        } else if (itemstack.m_150930_(Items.f_151055_)) {
            this.m_7292_(new MobEffectInstance((MobEffect)SonaMobEffects.FROST.get(), 1200, 0));
            if (!sourceentity.m_150110_().f_35937_) {
                ItemStack setstack = new ItemStack((ItemLike)Items.f_42446_);
                setstack.m_41764_(1);
                ItemHandlerHelper.giveItemToPlayer((Player)sourceentity, (ItemStack)setstack);
                itemstack.m_41764_(itemstack.m_41613_() - 1);
            }
        } else if (!sourceentity.m_6144_()) {
            sourceentity.m_20329_((Entity)this);
            sourceentity.m_5618_(this.f_20883_);
            sourceentity.m_146922_(this.f_20883_);
            sourceentity.m_5616_(this.f_20883_);
            sourceentity.m_146926_(0.0f);
        } else {
            this.m_5618_(sourceentity.m_146908_());
            this.m_5616_(sourceentity.m_146908_());
            this.m_146922_(sourceentity.m_146908_());
            if (!this.m_20197_().isEmpty()) {
                ((Entity)this.m_20197_().get(0)).m_5618_(sourceentity.m_146908_());
                ((Entity)this.m_20197_().get(0)).m_5616_(sourceentity.m_146908_());
            }
        }
        return retval;
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source == this.m_9236_().m_269111_().m_269063_()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)ZombieKitItems.MACHINE_GUN_COMPONENTS.get()));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 0.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1000.0);
        return builder;
    }

    private PlayState procedurePredicate(AnimationState event) {
        AnimationController controller = event.getController();
        if (!controller.isPlayingTriggeredAnimation() && (controller.getCurrentRawAnimation() == null || event.getController().hasAnimationFinished())) {
            controller.setAnimation(IDLE_ANI);
        }
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedureController", 0, this::procedurePredicate).triggerableAnim("shoot", SHOOT_ANI).receiveTriggeredAnimations()});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean validXRot(LivingEntity livingEntity, float xRot) {
        return xRot <= 30.0f && xRot >= -50.0f;
    }

    @Override
    public boolean validYRot(LivingEntity livingEntity, float yRot) {
        Vec3 horizontalViewer;
        Vec3 passengerViewer = this.m_20171_(livingEntity.m_146909_(), yRot);
        Vec3 horizontalVec = new Vec3((double)(-Mth.m_14031_((float)(-this.f_20883_ * ((float)Math.PI / 180) - (float)Math.PI))), 0.0, (double)(-Mth.m_14089_((float)(-this.f_20883_ * ((float)Math.PI / 180) - (float)Math.PI)))).m_82541_();
        return SonaMath.vectorDegreeCalculate((Vec3)horizontalVec, (Vec3)(horizontalViewer = new Vec3(passengerViewer.f_82479_, 0.0, passengerViewer.f_82481_).m_82541_())) <= 60.0;
    }

    @Override
    public CameraType getVehicleCameraType() {
        return CameraType.FIRST_PERSON;
    }

    static enum GunDirection {
        NORTH(180.0f),
        SOUTH(0.0f),
        WEST(90.0f),
        EAST(-90.0f);

        private final float angle;

        private GunDirection(float angle) {
            this.angle = angle;
        }

        public float getAngle() {
            return this.angle;
        }

        public static GunDirection getDirection(String facing) {
            return switch (facing) {
                case "NORTH" -> NORTH;
                case "SOUTH" -> SOUTH;
                case "WEST" -> WEST;
                default -> EAST;
            };
        }
    }
}

