/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.entity.mechanics;

import com.scarasol.sona.init.SonaMobEffects;
import com.scarasol.zombiekit.entity.mechanics.Mechanics;
import com.scarasol.zombiekit.init.ZombieKitEntities;
import com.scarasol.zombiekit.init.ZombieKitItems;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class DroneEntity
extends Mechanics {
    protected BlockPos hoverPlace;
    private boolean hover = false;
    private boolean enemy = false;
    private UUID owner;

    public DroneEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<DroneEntity>)((EntityType)ZombieKitEntities.DRONE.get()), world);
    }

    public DroneEntity(EntityType<DroneEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
        this.f_21342_ = new DroneMoveControl(this);
    }

    public DroneEntity(EntityType<DroneEntity> type, Level world, boolean enemy) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
        this.f_21342_ = new DroneMoveControl(this);
        this.enemy = enemy;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        if (!this.m_20068_() && !this.m_9236_().m_5776_()) {
            if (itemstack.m_150930_((Item)ZombieKitItems.WRENCH.get())) {
                if (player.m_6144_()) {
                    ItemEntity entityToSpawn = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ZombieKitItems.DRONE_SUMMON.get()));
                    entityToSpawn.m_32010_(10);
                    this.m_9236_().m_7967_((Entity)entityToSpawn);
                    this.m_146870_();
                } else {
                    if (this.enemy) {
                        this.enemy = false;
                        player.m_5661_((Component)Component.m_237115_((String)"entity.zombiekit.drone.switch_2"), true);
                    } else {
                        this.enemy = true;
                        player.m_5661_((Component)Component.m_237115_((String)"entity.zombiekit.drone.switch_1"), true);
                    }
                    this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("zombiekit:drone_switch")), SoundSource.HOSTILE, 0.3f, 1.0f);
                }
            } else {
                this.m_20242_(true);
                this.hoverPlace = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() + 10.0), (double)this.m_20189_());
            }
        }
        super.m_6071_(player, hand);
        return retval;
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    public void m_8119_() {
        if (this.m_5448_() == null && this.m_20068_()) {
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("zombiekit:drone_idle")), SoundSource.HOSTILE, 0.05f, 1.0f);
            if (this.hoverPlace == null) {
                this.hoverPlace = BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_());
            } else {
                Vec3 vec3 = new Vec3((double)this.hoverPlace.m_123341_() - this.m_20185_(), (double)this.hoverPlace.m_123342_() - this.m_20186_(), (double)this.hoverPlace.m_123343_() - this.m_20189_());
                if (vec3.m_82553_() > 100.0) {
                    this.hoverPlace = BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_());
                }
                if (vec3.m_82553_() >= 1.0) {
                    if (!this.hover) {
                        this.f_21342_.m_6849_((double)this.hoverPlace.m_123341_(), (double)this.hoverPlace.m_123342_(), (double)this.hoverPlace.m_123343_(), 1.0);
                    } else if (vec3.m_82553_() >= 2.5) {
                        this.hover = false;
                    }
                } else if (vec3.m_82553_() < 1.0) {
                    this.hover = true;
                }
            }
        } else {
            this.hover = false;
        }
        if (this.m_20072_()) {
            this.m_6469_(this.m_9236_().m_269111_().m_269063_(), 1.0f);
        }
        if (this.m_21023_((MobEffect)SonaMobEffects.SLIMINESS.get())) {
            this.m_20242_(false);
        }
        super.m_8119_();
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("HoverX")) {
            this.hoverPlace = new BlockPos(compoundTag.m_128451_("HoverX"), compoundTag.m_128451_("HoverY"), compoundTag.m_128451_("HoverZ"));
        }
        if (compoundTag.m_128441_("Enemy")) {
            this.enemy = compoundTag.m_128471_("Enemy");
        }
        if (compoundTag.m_128441_("DroneOwner")) {
            this.owner = UUID.fromString(compoundTag.m_128461_("DroneOwner"));
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.hoverPlace != null) {
            compoundTag.m_128405_("HoverX", this.hoverPlace.m_123341_());
            compoundTag.m_128405_("HoverY", this.hoverPlace.m_123342_());
            compoundTag.m_128405_("HoverZ", this.hoverPlace.m_123343_());
        }
        if (this.owner != null) {
            compoundTag.m_128359_("DroneOwner", this.owner.toString());
        }
        compoundTag.m_128379_("Enemy", this.enemy);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new DroneAttackGoal());
    }

    public boolean isEnemy() {
        return this.enemy;
    }

    public void setOwner(Player player) {
        this.owner = player.m_20148_();
    }

    public Player getOwner() {
        return this.m_9236_().m_46003_(this.owner);
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    @Override
    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("zombiekit:drone_crush"));
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)ZombieKitItems.DRONE_COMPONENTS.get()));
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (!source.m_276093_(DamageTypes.f_268671_)) {
            return super.m_6469_(source, amount);
        }
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 2.0);
        builder = builder.m_22268_(Attributes.f_22276_, 4.0);
        builder = builder.m_22268_(Attributes.f_22284_, 10.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 25.0);
        builder = builder.m_22268_(Attributes.f_22280_, 2.0);
        return builder;
    }

    class DroneMoveControl
    extends MoveControl {
        public DroneMoveControl(DroneEntity DroneEntity2) {
            super((Mob)DroneEntity2);
        }

        public void hover() {
            Vec3 vec3 = new Vec3(0.0, (double)DroneEntity.this.hoverPlace.m_123342_() - DroneEntity.this.m_20186_(), 0.0);
            if (vec3.m_82553_() > 1.5 && DroneEntity.this.hover) {
                DroneEntity.this.m_20256_(vec3.m_82490_(0.1));
            }
        }

        public void m_8126_() {
            if (!DroneEntity.this.m_20068_()) {
                return;
            }
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.hover();
                return;
            }
            Vec3 vec3 = new Vec3(this.f_24975_ - DroneEntity.this.m_20185_(), this.f_24976_ - DroneEntity.this.m_20186_(), this.f_24977_ - DroneEntity.this.m_20189_());
            double d = vec3.m_82553_();
            if (d < DroneEntity.this.m_20191_().m_82309_()) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                DroneEntity.this.m_20256_(DroneEntity.this.m_20184_().m_82490_(0.5));
            } else {
                DroneEntity.this.m_20256_(DroneEntity.this.m_20184_().m_82549_(vec3.m_82490_(this.f_24978_ * 0.1 / d)));
                if (DroneEntity.this.m_5448_() == null) {
                    Vec3 vec32 = DroneEntity.this.m_20184_();
                    DroneEntity.this.m_146922_(-((float)Mth.m_14136_((double)vec32.f_82479_, (double)vec32.f_82481_)) * 57.295776f);
                    DroneEntity.this.f_20883_ = DroneEntity.this.m_146908_();
                } else {
                    double d2 = DroneEntity.this.m_5448_().m_20185_() - DroneEntity.this.m_20185_();
                    double d3 = DroneEntity.this.m_5448_().m_20189_() - DroneEntity.this.m_20189_();
                    DroneEntity.this.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d3)) * 57.295776f);
                    DroneEntity.this.f_20883_ = DroneEntity.this.m_146908_();
                }
            }
        }
    }

    class DroneAttackGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(25.0);

        public DroneAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!DroneEntity.this.m_20068_()) {
                return false;
            }
            if (DroneEntity.this.m_5448_() != null && DroneEntity.this.m_5448_().m_6084_()) {
                return true;
            }
            if (DroneEntity.this.isEnemy() && this.searchPlayer()) {
                return true;
            }
            return this.searchEntities();
        }

        public boolean searchEntities() {
            List list = DroneEntity.this.m_9236_().m_45971_(LivingEntity.class, this.attackTargeting, (LivingEntity)DroneEntity.this, DroneEntity.this.m_20191_().m_82377_(25.0, 15.0, 25.0));
            if (!list.isEmpty()) {
                list.sort((l1, l2) -> {
                    double a = Math.pow(l1.m_20185_() - DroneEntity.this.m_20185_(), 2.0) + Math.pow(l1.m_20189_() - DroneEntity.this.m_20189_(), 2.0);
                    double b = Math.pow(l2.m_20185_() - DroneEntity.this.m_20185_(), 2.0) + Math.pow(l2.m_20189_() - DroneEntity.this.m_20189_(), 2.0);
                    return Double.compare(a, b);
                });
                for (LivingEntity entity : list) {
                    if (!DroneEntity.this.m_21040_(entity, TargetingConditions.m_148352_())) continue;
                    if (DroneEntity.this.getOwnerUUID() == null) {
                        if (!(entity.m_20186_() < DroneEntity.this.m_20186_()) || !(entity instanceof Enemy) || entity instanceof Raider || entity instanceof NeutralMob || entity instanceof Vex) continue;
                        DroneEntity.this.m_6710_(entity);
                        return true;
                    }
                    if (!(entity.m_20186_() < DroneEntity.this.m_20186_()) || !(entity instanceof Enemy) || entity instanceof NeutralMob) continue;
                    DroneEntity.this.m_6710_(entity);
                    return true;
                }
            }
            return false;
        }

        public boolean searchPlayer() {
            List list = DroneEntity.this.m_9236_().m_45955_(this.attackTargeting, (LivingEntity)DroneEntity.this, DroneEntity.this.m_20191_().m_82377_(16.0, 15.0, 16.0));
            if (!list.isEmpty()) {
                list.sort((l1, l2) -> {
                    double a = Math.pow(l1.m_20185_() - DroneEntity.this.m_20185_(), 2.0) + Math.pow(l1.m_20189_() - DroneEntity.this.m_20189_(), 2.0);
                    double b = Math.pow(l2.m_20185_() - DroneEntity.this.m_20185_(), 2.0) + Math.pow(l2.m_20189_() - DroneEntity.this.m_20189_(), 2.0);
                    return Double.compare(a, b);
                });
                for (Player entity : list) {
                    if (!(entity.m_20186_() < DroneEntity.this.m_20186_()) || !DroneEntity.this.m_21040_((LivingEntity)entity, TargetingConditions.m_148352_()) || entity.m_20148_().equals(DroneEntity.this.getOwnerUUID())) continue;
                    DroneEntity.this.m_6710_((LivingEntity)entity);
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            return DroneEntity.this.m_21566_().m_24995_() && DroneEntity.this.m_5448_() != null && DroneEntity.this.m_5448_().m_6084_() && DroneEntity.this.m_20068_();
        }

        public void m_8056_() {
            LivingEntity livingentity = DroneEntity.this.m_5448_();
            Vec3 vec3d = livingentity.m_20299_(1.0f);
            DroneEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
        }

        public void m_8037_() {
            LivingEntity livingentity = DroneEntity.this.m_5448_();
            Vec3 vec3 = new Vec3(livingentity.m_20185_() - DroneEntity.this.m_20185_(), livingentity.m_20186_() - DroneEntity.this.m_20186_(), livingentity.m_20189_() - DroneEntity.this.m_20189_());
            double d = vec3.m_82553_();
            if (d < 2.5 && this.m_8045_()) {
                DroneEntity.this.m_9236_().m_254849_((Entity)DroneEntity.this, DroneEntity.this.m_20185_(), DroneEntity.this.m_20186_(), DroneEntity.this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
                DroneEntity.this.m_146870_();
            } else {
                double d0 = DroneEntity.this.m_20280_((Entity)livingentity);
                if (d0 < 25.0) {
                    Vec3 vec3d = livingentity.m_20299_(1.0f);
                    DroneEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
                }
                if (!this.m_8045_()) {
                    DroneEntity.this.m_6710_(null);
                }
            }
        }
    }
}

