/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.entity.ai.goal;

import com.scarasol.sona.util.SonaMath;
import com.scarasol.zombiekit.api.MortarLevel;
import com.scarasol.zombiekit.data.LaunchSchedule;
import com.scarasol.zombiekit.entity.ai.control.MortarLookControl;
import com.scarasol.zombiekit.entity.mechanics.MortarEntity;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MortarUsingGoal<T extends MortarEntity>
extends Goal {
    private final T mob;
    private int attackDelay;
    private MortarState mortarState = MortarState.WAITING;
    private final Queue<LaunchSchedule> toDoLaunchSchedules = new LinkedList<LaunchSchedule>();
    private LaunchSchedule currentSchedule;

    public MortarUsingGoal(T mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return ((MortarEntity)this.mob).getRack() != null && this.mob.m_20160_() && !(this.mob.m_20197_().get(0) instanceof Player);
    }

    public boolean m_8045_() {
        return ((MortarEntity)this.mob).getRack() != null && this.mob.m_20160_() && !(this.mob.m_20197_().get(0) instanceof Player);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        super.m_8056_();
        Level level = this.mob.m_9236_();
        if (level instanceof MortarLevel) {
            MortarLevel mortarLevel = (MortarLevel)level;
            mortarLevel.getMortarManager().subscribe(this, this.mob.m_9236_().m_46467_());
        }
    }

    public void m_8041_() {
        super.m_8041_();
        Level level = this.mob.m_9236_();
        if (level instanceof MortarLevel) {
            MortarLevel mortarLevel = (MortarLevel)level;
            mortarLevel.getMortarManager().unsubscribe(this, this.mob.m_9236_().m_46467_());
        }
    }

    public void m_8037_() {
        if (this.mortarState == MortarState.WAITING) {
            LaunchSchedule newSchedule = this.toDoLaunchSchedules.poll();
            if (newSchedule != null && this.isValidSchedule(newSchedule)) {
                newSchedule.acceptSchedule();
                float angle = (float)SonaMath.parabolaAngleCalculate(this.mob, (Vec3)newSchedule.getCoordinate().m_252807_(), (double)3.5);
                if (angle != -1.0f) {
                    this.currentSchedule = newSchedule;
                    this.attackDelay = this.mob.m_217043_().m_188503_(100);
                    BlockPos pos = this.currentSchedule.getCoordinate();
                    double x = (double)pos.m_123341_() - this.mob.m_20185_();
                    double z = (double)pos.m_123343_() - this.mob.m_20189_();
                    float azimuth = (float)(Mth.m_14136_((double)z, (double)x) * 57.2957763671875) - 90.0f;
                    ((MortarLookControl)this.mob.m_21563_()).setLookView(azimuth, (float)(-Math.toDegrees(angle)));
                    this.mortarState = MortarState.RELOAD;
                }
            }
        } else if (this.mortarState == MortarState.RELOAD && !this.mob.m_21563_().m_186069_()) {
            if (this.attackDelay-- <= 0) {
                if (((MortarEntity)this.mob).reload()) {
                    ((MortarEntity)this.mob).setCurrentSchedule(this.currentSchedule);
                    this.mortarState = MortarState.READY_TO_ATTACK;
                } else {
                    this.currentSchedule.failSchedule();
                    this.currentSchedule = null;
                    this.mortarState = MortarState.WAITING;
                }
            }
        } else if (this.mortarState == MortarState.READY_TO_ATTACK && ((MortarEntity)this.mob).getShell() == null) {
            this.mortarState = MortarState.WAITING;
        }
    }

    public void pushSchedule(LaunchSchedule launchSchedule) {
        if (this.isValidSchedule(launchSchedule)) {
            this.toDoLaunchSchedules.offer(launchSchedule);
        }
    }

    public boolean isValidSchedule(LaunchSchedule launchSchedule) {
        return launchSchedule.getCoordinate().m_123331_((Vec3i)this.mob.m_20097_()) < 48400.0 && !launchSchedule.isTimeout(this.mob.m_9236_().m_46467_());
    }

    public void syncSchedule(List<LaunchSchedule> launchSchedules) {
        launchSchedules.stream().filter(this::isValidSchedule).forEach(this.toDoLaunchSchedules::offer);
    }

    public T getMob() {
        return this.mob;
    }

    static enum MortarState {
        WAITING,
        RELOAD,
        READY_TO_ATTACK;

    }
}

