/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.entity.ai.goal;

import com.scarasol.zombiekit.entity.mechanics.HeavyMachineGunEntity;
import com.scarasol.zombiekit.init.ZombieKitSounds;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class HeavyMachineGunUsingGoal<T extends Mob>
extends Goal {
    private final T mob;
    private int seeTime;
    private int attackDelay;
    private int attackTimes;
    private int attackCooldown;
    private MachineGunState machineGunState = MachineGunState.UNCHARGED;
    @Nullable
    private Predicate<LivingEntity> predicate;
    private boolean enemy = false;

    public HeavyMachineGunUsingGoal(T mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public HeavyMachineGunUsingGoal(T mob, @Nullable Predicate<LivingEntity> predicate, boolean enemy) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        this.predicate = predicate;
        this.enemy = enemy;
    }

    public boolean m_8036_() {
        return this.isValidTarget();
    }

    private boolean isInMachineGunSight() {
        Entity entity = this.mob.m_20202_();
        if (entity instanceof HeavyMachineGunEntity) {
            HeavyMachineGunEntity heavyMachineGun = (HeavyMachineGunEntity)entity;
            return heavyMachineGun.canSee((Entity)this.mob.m_5448_());
        }
        return false;
    }

    private boolean isInMachineGunSight(Entity target) {
        Entity entity = this.mob.m_20202_();
        if (entity instanceof HeavyMachineGunEntity) {
            HeavyMachineGunEntity heavyMachineGun = (HeavyMachineGunEntity)entity;
            return heavyMachineGun.canSee(target);
        }
        return false;
    }

    public boolean m_8045_() {
        return this.isValidTarget();
    }

    private boolean isValidTarget() {
        if (this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && this.isInMachineGunSight() && !this.mob.m_5448_().m_6095_().toString().equals("entity.sona.sound_decoy")) {
            return true;
        }
        if (this.enemy && this.searchPlayer()) {
            return true;
        }
        return this.predicate != null && this.searchEntities();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_6710_(null);
        this.seeTime = 0;
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity != null) {
            Entity entity;
            HeavyMachineGunEntity heavyMachineGun;
            boolean flag1;
            this.mob.m_21561_(true);
            boolean flag = this.mob.m_21574_().m_148306_((Entity)livingEntity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            Entity entity2 = this.mob.m_20202_();
            if (entity2 instanceof HeavyMachineGunEntity && (heavyMachineGun = (HeavyMachineGunEntity)entity2).getOverload()) {
                this.machineGunState = MachineGunState.OVERHEAT;
            } else if (this.machineGunState == MachineGunState.OVERHEAT) {
                this.machineGunState = MachineGunState.UNCHARGED;
            }
            double distance = this.mob.m_20280_((Entity)livingEntity);
            double range = this.mob.m_21133_(Attributes.f_22277_);
            boolean flag2 = (distance > range * range || this.seeTime < 5) && this.attackDelay == 0;
            this.mob.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
            if (this.machineGunState == MachineGunState.UNCHARGED && this.attackTimes > 0) {
                this.machineGunState = MachineGunState.CHARGED;
                this.attackDelay = 20 + this.mob.m_217043_().m_188503_(10);
            }
            if (this.machineGunState == MachineGunState.UNCHARGED) {
                if (!flag2) {
                    this.machineGunState = MachineGunState.CHARGED;
                    this.attackDelay = 30 + this.mob.m_217043_().m_188503_(30);
                }
            } else if (this.machineGunState == MachineGunState.CHARGED) {
                --this.attackDelay;
                if (this.attackDelay <= 0) {
                    this.machineGunState = MachineGunState.READY_TO_ATTACK;
                    this.attackTimes = 4 + this.mob.m_217043_().m_188503_(4);
                }
            } else if (this.machineGunState == MachineGunState.READY_TO_ATTACK && flag && (entity = this.mob.m_20202_()) instanceof HeavyMachineGunEntity) {
                HeavyMachineGunEntity heavyMachineGun2 = (HeavyMachineGunEntity)entity;
                if (this.attackCooldown <= 0) {
                    if (this.attackTimes-- <= 0) {
                        this.machineGunState = MachineGunState.UNCHARGED;
                    } else {
                        if (heavyMachineGun2.getOverload()) {
                            livingEntity.m_9236_().m_6263_(null, heavyMachineGun2.m_20185_(), heavyMachineGun2.m_20186_(), heavyMachineGun2.m_20189_(), (SoundEvent)ZombieKitSounds.heavy_machine_gun_trigger.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        } else {
                            heavyMachineGun2.fire();
                        }
                        this.attackCooldown = 4;
                    }
                } else {
                    --this.attackCooldown;
                }
            }
        }
    }

    public boolean searchEntities() {
        double range = this.mob.m_21133_(Attributes.f_22277_);
        List<LivingEntity> list = this.mob.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26883_(range).m_26888_(this.predicate), this.mob, this.mob.m_20191_().m_82400_(range)).stream().filter(livingEntity -> this.mob.m_20182_().m_82554_(livingEntity.m_20182_()) < range).sorted((l1, l2) -> {
            double a = Math.pow(l1.m_20185_() - this.mob.m_20185_(), 2.0) + Math.pow(l1.m_20189_() - this.mob.m_20189_(), 2.0);
            double b = Math.pow(l2.m_20185_() - this.mob.m_20185_(), 2.0) + Math.pow(l2.m_20189_() - this.mob.m_20189_(), 2.0);
            return Double.compare(a, b);
        }).toList();
        if (!list.isEmpty()) {
            for (LivingEntity entity : list) {
                if (entity.m_6095_().toString().equals("entity.sona.sound_decoy") || !this.mob.m_6779_(entity) || !this.isInMachineGunSight((Entity)entity) || entity instanceof HeavyMachineGunEntity) continue;
                this.mob.m_6710_(entity);
                return true;
            }
        }
        return false;
    }

    public boolean searchPlayer() {
        double range = this.mob.m_21133_(Attributes.f_22277_);
        List<Player> list = this.mob.m_9236_().m_45955_(TargetingConditions.m_148352_().m_26883_(range), this.mob, this.mob.m_20191_().m_82400_(range)).stream().filter(player -> this.mob.m_20182_().m_82554_(player.m_20182_()) < range).sorted((l1, l2) -> {
            double a = Math.pow(l1.m_20185_() - this.mob.m_20185_(), 2.0) + Math.pow(l1.m_20189_() - this.mob.m_20189_(), 2.0);
            double b = Math.pow(l2.m_20185_() - this.mob.m_20185_(), 2.0) + Math.pow(l2.m_20189_() - this.mob.m_20189_(), 2.0);
            return Double.compare(a, b);
        }).toList();
        if (!list.isEmpty()) {
            for (Player entity : list) {
                if (!this.isInMachineGunSight((Entity)entity)) continue;
                this.mob.m_6710_((LivingEntity)entity);
                return true;
            }
        }
        return false;
    }

    static enum MachineGunState {
        CHARGED,
        OVERHEAT,
        UNCHARGED,
        READY_TO_ATTACK;

    }
}

