/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.entity.ai.goal;

import com.scarasol.zombiekit.init.ZombieKitItems;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;

public class FlamethrowerUsingGoal<T extends Mob>
extends Goal {
    private final T mob;
    private int seeTime;
    private int attackDelay;
    private int attackTime;
    private FlamethrowerState flamethrowerState = FlamethrowerState.UNLOCKED;

    public FlamethrowerUsingGoal(T mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.isValidTarget() && this.mob.m_21205_().m_150930_((Item)ZombieKitItems.FLAMETHROWER.get());
    }

    public boolean m_8045_() {
        return this.isValidTarget() && this.mob.m_21205_().m_150930_((Item)ZombieKitItems.FLAMETHROWER.get());
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        if (this.flamethrowerState == FlamethrowerState.FIRE) {
            this.mob.m_5810_();
            this.flamethrowerState = FlamethrowerState.UNLOCKED;
            this.attackTime = 0;
            this.mob.m_21573_().m_26573_();
        }
        this.mob.m_21561_(false);
        this.mob.m_6710_(null);
        this.seeTime = 0;
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity != null) {
            boolean flag1;
            this.mob.m_21561_(true);
            boolean flag = this.mob.m_21574_().m_148306_((Entity)livingEntity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            double distance = this.mob.m_20270_((Entity)livingEntity);
            boolean flag2 = this.seeTime < 5 && this.attackDelay == 0;
            this.mob.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
            if (this.flamethrowerState == FlamethrowerState.UNLOCKED) {
                if (!flag2) {
                    this.flamethrowerState = FlamethrowerState.LOCKED;
                    this.attackDelay = 30 + this.mob.m_217043_().m_188503_(40);
                }
            } else if (this.flamethrowerState == FlamethrowerState.LOCKED) {
                --this.attackDelay;
                if (distance < 15.0) {
                    this.mob.m_21573_().m_26573_();
                } else {
                    this.mob.m_21573_().m_5624_((Entity)livingEntity, 1.0);
                }
                if (this.attackDelay == 0) {
                    this.flamethrowerState = FlamethrowerState.READY_TO_ATTACK;
                }
            } else if (this.flamethrowerState == FlamethrowerState.READY_TO_ATTACK && flag) {
                this.attackTime = 100 + this.mob.m_217043_().m_188503_(60);
                this.mob.m_6672_(InteractionHand.MAIN_HAND);
                this.flamethrowerState = FlamethrowerState.FIRE;
            } else if (this.flamethrowerState == FlamethrowerState.FIRE) {
                if (flag && this.attackTime > 0) {
                    --this.attackTime;
                    if (distance < 15.0) {
                        this.mob.m_21573_().m_26573_();
                    } else {
                        this.mob.m_21573_().m_5624_((Entity)livingEntity, 0.5);
                    }
                } else {
                    this.mob.m_5810_();
                    this.flamethrowerState = FlamethrowerState.UNLOCKED;
                }
            }
        }
    }

    static enum FlamethrowerState {
        LOCKED,
        UNLOCKED,
        READY_TO_ATTACK,
        FIRE;

    }
}

