/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.data;

import com.scarasol.zombiekit.api.MortarLevel;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public class LaunchSchedule {
    private final long createTime;
    private final UUID id;
    private int acceptCount;
    private int completeCount;
    private final BlockPos coordinate;
    private final ChunkPos chunk;
    private static final int MAX_TIME = 600;

    public LaunchSchedule(Long gameTime, BlockPos coordinate) {
        this.createTime = gameTime;
        this.id = UUID.randomUUID();
        this.coordinate = coordinate;
        this.chunk = new ChunkPos(coordinate);
    }

    public void completeSchedule(ServerLevel serverLevel) {
        ++this.completeCount;
        if (this.isScheduleCompletion() && serverLevel instanceof MortarLevel) {
            MortarLevel level = (MortarLevel)serverLevel;
            level.getMortarManager().abortSchedule(this);
        }
    }

    public void acceptSchedule() {
        ++this.acceptCount;
    }

    public void failSchedule() {
        --this.acceptCount;
    }

    public boolean isScheduleCompletion() {
        return this.completeCount == this.acceptCount;
    }

    public boolean isTimeout(long gameTime) {
        return gameTime - this.createTime > 600L;
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object launchSchedule) {
        if (!(launchSchedule instanceof LaunchSchedule)) return false;
        LaunchSchedule l = (LaunchSchedule)launchSchedule;
        if (!l.chunk.equals((Object)this.chunk)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.chunk);
    }
}

