/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.client.model;

import com.scarasol.zombiekit.entity.mechanics.MortarEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class MortarModel
extends GeoModel<MortarEntity> {
    public ResourceLocation getAnimationResource(MortarEntity entity) {
        return new ResourceLocation("zombiekit", "animations/mortar.animation.json");
    }

    public ResourceLocation getModelResource(MortarEntity entity) {
        return new ResourceLocation("zombiekit", "geo/" + entity.getModel() + ".geo.json");
    }

    public ResourceLocation getTextureResource(MortarEntity entity) {
        return new ResourceLocation("zombiekit", "textures/entities/mortar.png");
    }

    public void setCustomAnimations(MortarEntity animatable, long instanceId, AnimationState animationState) {
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX((entityData.headPitch() - 45.0f) * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

