/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.entity.mechanics.HeavyMachineGunEntity;
import com.scarasol.zombiekit.entity.mechanics.MortarEntity;
import com.scarasol.zombiekit.init.ZombieKitTags;
import com.scarasol.zombiekit.item.api.ModifiableWeapon;
import com.scarasol.zombiekit.item.armor.ExoArmor;
import com.scarasol.zombiekit.item.projectile.MortarShell;
import com.scarasol.zombiekit.item.weapon.Flamethrower;
import com.scarasol.zombiekit.item.weapon.parts.ChargingParts;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class OverlayEvent {
    public static void renderExo(RenderGuiEvent.Pre event) {
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        if (entity != null && ExoArmor.numberOfSuit((LivingEntity)entity) >= 4) {
            int width = event.getWindow().m_85445_();
            int height = event.getWindow().m_85446_();
            int posX = width - (Integer)CommonConfig.EXO_HUD_WIDTH.get();
            int posY = height - (Integer)CommonConfig.EXO_HUD_HEIGHT.get();
            if (!entity.m_5833_()) {
                event.getGuiGraphics().m_280168_().m_85836_();
                ItemStack itemStack = entity.m_6844_(EquipmentSlot.CHEST);
                String color = switch (ExoArmor.getMode(itemStack)) {
                    case 1 -> "blue";
                    case 2 -> "red";
                    default -> "green";
                };
                event.getGuiGraphics().m_280163_(new ResourceLocation("zombiekit:textures/screens/exo/" + color + "/basic_component.png"), posX, posY, 0.0f, 0.0f, 112, 35, 112, 35);
                int power = ExoArmor.getPower(itemStack);
                event.getGuiGraphics().m_280163_(new ResourceLocation("zombiekit:textures/screens/exo/" + color + "/" + power / 100 + ".png"), posX + 80, posY + 12, 0.0f, 0.0f, 5, 8, 5, 8);
                event.getGuiGraphics().m_280163_(new ResourceLocation("zombiekit:textures/screens/exo/" + color + "/" + power % 100 / 10 + ".png"), posX + 87, posY + 12, 0.0f, 0.0f, 5, 8, 5, 8);
                event.getGuiGraphics().m_280163_(new ResourceLocation("zombiekit:textures/screens/exo/" + color + "/" + power % 10 + ".png"), posX + 94, posY + 12, 0.0f, 0.0f, 5, 8, 5, 8);
                event.getGuiGraphics().m_280163_(new ResourceLocation("zombiekit:textures/screens/exo/" + color + "/percent.png"), posX + 101, posY + 12, 0.0f, 0.0f, 5, 8, 5, 8);
                int i = 0;
                while (power / ((i + 1) * 5) > 0) {
                    event.getGuiGraphics().m_280163_(new ResourceLocation("zombiekit:textures/screens/exo/" + color + "/power.png"), posX + 103 - 5 * i, posY + 21, 0.0f, 0.0f, 3, 8, 3, 8);
                    ++i;
                }
                if (ExoArmor.getRadar(itemStack) == 2) {
                    event.getGuiGraphics().m_280163_(new ResourceLocation("zombiekit:textures/screens/exo/" + color + "/radar.png"), posX + 96, posY + 2, 0.0f, 0.0f, 8, 8, 8, 8);
                } else if (ExoArmor.getRadar(itemStack) == 1) {
                    event.getGuiGraphics().m_280163_(new ResourceLocation("zombiekit:textures/screens/exo/" + color + "/night_vision.png"), posX + 96, posY + 2, 0.0f, 0.0f, 8, 8, 8, 8);
                }
                if (ExoArmor.getFlyMode(itemStack)) {
                    event.getGuiGraphics().m_280163_(new ResourceLocation("zombiekit:textures/screens/exo/" + color + "/fall_fly.png"), posX + 86, posY + 2, 0.0f, 0.0f, 8, 8, 8, 8);
                }
                if (ExoArmor.getReactiveArmor(itemStack) >= 0) {
                    event.getGuiGraphics().m_280163_(new ResourceLocation("zombiekit:textures/screens/exo/" + color + "/reactive_armor_charge.png"), posX + 76, posY + 2, 0.0f, 0.0f, 8, 8, 8, 8);
                    event.getGuiGraphics().m_280163_(new ResourceLocation("zombiekit:textures/screens/exo/" + color + "/reactive_armor.png"), posX + 76, posY + 2, 0.0f, 0.0f, 8, 8 * ExoArmor.getReactiveArmor(itemStack) / 160, 8, 8);
                }
                event.getGuiGraphics().m_280168_().m_85849_();
            }
        }
    }

    public static void renderSum(GuiGraphics guiGraphics, Player player, int posX, int posY, Predicate<ItemStack> predicate) {
        int i;
        int sum = player.m_150109_().f_35974_.stream().filter(predicate).mapToInt(ItemStack::m_41613_).sum();
        boolean flag = false;
        int[] number = new int[4];
        for (i = 1; i <= 4; ++i) {
            number[4 - i] = sum % 10;
            sum -= number[4 - i];
            if ((sum /= 10) == 0) break;
        }
        for (i = 0; i < number.length; ++i) {
            int num = number[i];
            if (!(num == 0 && i != number.length - 1 || flag)) {
                flag = true;
            }
            if (!flag) continue;
            guiGraphics.m_280163_(new ResourceLocation("zombiekit:textures/screens/weapon/" + num + ".png"), posX, posY, 0.0f, 0.0f, 6, 10, 6, 10);
            posX += 8;
        }
    }

    public static void renderMortarInfo(GuiGraphics guiGraphics, int posX, int posY, MortarEntity mortarEntity, Player player) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280163_(new ResourceLocation("zombiekit:textures/screens/weapon/mortar_bottom.png"), posX, posY, 0.0f, 0.0f, 28, 2, 28, 2);
        guiGraphics.m_280168_().m_252880_((float)(posX + 26), (float)(posY - 2), 0.0f);
        guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252961_((float)Math.toRadians(-mortarEntity.getAngle() - 45.0f)));
        guiGraphics.m_280163_(new ResourceLocation("zombiekit:textures/screens/weapon/mortar.png"), -20, -20, 0.0f, 0.0f, 30, 30, 30, 30);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280163_(new ResourceLocation("zombiekit:textures/screens/weapon/mortar_shell.png"), posX += 30, posY -= 28, 0.0f, 0.0f, 22, 20, 22, 20);
        OverlayEvent.renderSum(guiGraphics, player, posX + 24, posY, itemStack -> itemStack.m_41720_() instanceof MortarShell);
        guiGraphics.m_280168_().m_85849_();
    }

    public static void renderHeavyMachineGunInfo(GuiGraphics guiGraphics, int posX, int posY, Player player) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280163_(new ResourceLocation("zombiekit:textures/screens/weapon/heavy_machine_gun.png"), posX, posY, 0.0f, 0.0f, 56, 16, 56, 16);
        OverlayEvent.renderSum(guiGraphics, player, posX + 60, posY + 4, itemStack -> itemStack.m_204117_(ZombieKitTags.MACHINE_GUN_AMMO));
        guiGraphics.m_280168_().m_85849_();
    }

    public static void renderFlamethrowerInfo(GuiGraphics guiGraphics, int posX, int posY, ItemStack itemStack) {
        Flamethrower flamethrower = (Flamethrower)itemStack.m_41720_();
        double pressure = flamethrower.getPressure(itemStack) / 10000.0;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280163_(new ResourceLocation("zombiekit:textures/screens/weapon/flamethrower.png"), posX, posY, 0.0f, 0.0f, 80, 28, 80, 28);
        guiGraphics.m_280168_().m_252880_((float)(posX + 61), (float)(posY + 19), 0.0f);
        guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252961_((float)(-0.7853981633974483 + pressure * Math.PI)));
        guiGraphics.m_280163_(new ResourceLocation("zombiekit:textures/screens/weapon/pointer.png"), -9, -9, 0.0f, 0.0f, 10, 10, 10, 10);
        guiGraphics.m_280168_().m_85849_();
    }

    public static void renderChargingPartsInfo(GuiGraphics guiGraphics, int posX, int posY, ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof ModifiableWeapon) {
            ChargingParts chargingParts;
            ModifiableWeapon modifiableWeapon = (ModifiableWeapon)item;
            Item parts = modifiableWeapon.getChargingParts(itemStack);
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (parts instanceof ChargingParts && (chargingParts = (ChargingParts)parts).isOnCoolDown(itemStack, level.m_46467_())) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280163_(new ResourceLocation("zombiekit:textures/screens/weapon/charging_parts_empty.png"), posX + 10, posY - 5, 0.0f, 0.0f, 10, 10, 10, 10);
                double percent = (double)(level.m_46467_() - chargingParts.getCooldownTime(itemStack)) / (double)chargingParts.getChargingTime();
                guiGraphics.m_280163_(new ResourceLocation("zombiekit:textures/screens/weapon/charging_parts.png"), posX + 10, posY - 5, 0.0f, 0.0f, 10, (int)Math.round(10.0 * percent), 10, 10);
                guiGraphics.m_280168_().m_85849_();
            }
        }
    }

    public static void renderWeaponInfo(RenderGuiEvent.Pre event) {
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        if (entity != null) {
            int width = event.getWindow().m_85445_();
            int height = event.getWindow().m_85446_();
            int posX = width - 120;
            int posY = height - 15;
            GuiGraphics guiGraphics = event.getGuiGraphics();
            Entity vehicle = entity.m_20202_();
            ItemStack itemStack = entity.m_21205_();
            if (vehicle instanceof MortarEntity) {
                MortarEntity mortarEntity = (MortarEntity)vehicle;
                OverlayEvent.renderMortarInfo(guiGraphics, posX, posY, mortarEntity, (Player)entity);
            } else if (vehicle instanceof HeavyMachineGunEntity) {
                OverlayEvent.renderHeavyMachineGunInfo(guiGraphics, posX + 10, posY - 10, (Player)entity);
            } else if (itemStack.m_41720_() instanceof Flamethrower) {
                OverlayEvent.renderFlamethrowerInfo(guiGraphics, posX + 10, posY - 20, itemStack);
            } else {
                ModifiableWeapon modifiableWeapon;
                Item item = itemStack.m_41720_();
                if (item instanceof ModifiableWeapon && (modifiableWeapon = (ModifiableWeapon)item).getChargingParts(itemStack) != null) {
                    OverlayEvent.renderChargingPartsInfo(guiGraphics, width / 2, height / 2, itemStack);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void eventHandler(RenderGuiEvent.Pre event) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        OverlayEvent.renderExo(event);
        OverlayEvent.renderWeaponInfo(event);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

