/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.block.entity;

import com.scarasol.sona.manager.RotManager;
import com.scarasol.zombiekit.init.ZombieKitBlockEntities;
import com.scarasol.zombiekit.init.ZombieKitItems;
import com.scarasol.zombiekit.inventory.VacuumPackagingMachineMenu;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class VacuumPackagingMachineBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{1, 3};
    private static final int[] SLOTS_FOR_SIDES = new int[]{2, 3};
    private int vacuumPackagingTime;
    private final int maxVacuumPackagingTime = 200;
    private int batteryDuration;
    private final int maxBatteryDuration = 5;
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int id) {
            return switch (id) {
                case 0 -> VacuumPackagingMachineBlockEntity.this.vacuumPackagingTime;
                case 1 -> VacuumPackagingMachineBlockEntity.this.maxVacuumPackagingTime;
                default -> 0;
            };
        }

        public void m_8050_(int id, int value) {
            if (id == 0) {
                VacuumPackagingMachineBlockEntity.this.vacuumPackagingTime = value;
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public VacuumPackagingMachineBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)ZombieKitBlockEntities.VACUUM_PACKAGING_MACHINE.get(), position, state);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        this.vacuumPackagingTime = compoundTag.m_128451_("VacuumPackagingTime");
        this.batteryDuration = compoundTag.m_128451_("BatteryDuration");
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
        compoundTag.m_128405_("VacuumPackagingTime", this.vacuumPackagingTime);
        compoundTag.m_128405_("BatteryDuration", this.batteryDuration);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState blockState, VacuumPackagingMachineBlockEntity blockEntity) {
        if (blockEntity.canPackage()) {
            blockEntity.vacuumPackagingTime = (blockEntity.vacuumPackagingTime + 1) % blockEntity.maxVacuumPackagingTime;
            if (blockEntity.vacuumPackagingTime == 0) {
                blockEntity.packageFood();
            }
            blockEntity.m_6596_();
        } else if (blockEntity.vacuumPackagingTime > 0) {
            blockEntity.vacuumPackagingTime = 0;
            blockEntity.m_6596_();
        }
    }

    private void packageFood() {
        ItemStack food = this.m_8020_(0);
        ItemStack warpedFood = this.m_8020_(1);
        if (warpedFood.m_41619_()) {
            warpedFood = food.m_41777_();
            warpedFood.m_41764_(1);
            RotManager.putWarp((ItemStack)warpedFood, (boolean)true);
        } else {
            RotManager.rotWhenStack((ItemStack)warpedFood, (double)RotManager.getRot((ItemStack)warpedFood), (double)RotManager.getRot((ItemStack)food), (int)warpedFood.m_41613_(), (int)1, (long)this.f_58857_.m_46467_());
            warpedFood.m_41769_(1);
        }
        this.batteryDuration = (this.batteryDuration + 1) % 5;
        if (this.batteryDuration == 0) {
            ItemStack battery = this.m_8020_(3);
            battery.m_41721_(battery.m_41773_() + 1);
        }
        this.m_7407_(0, 1);
        this.m_7407_(2, 1);
        this.m_6836_(1, warpedFood);
    }

    public boolean canPackage() {
        if (this.hasPower() && !((ItemStack)this.items.get(2)).m_41619_() && !((ItemStack)this.items.get(0)).m_41619_() && (((ItemStack)this.items.get(1)).m_41619_() || ItemStack.m_41656_((ItemStack)((ItemStack)this.items.get(1)), (ItemStack)((ItemStack)this.items.get(0))))) {
            return ((ItemStack)this.items.get(1)).m_41613_() < ((ItemStack)this.items.get(1)).m_41741_();
        }
        return false;
    }

    private boolean hasPower() {
        return !((ItemStack)this.items.get(3)).m_41619_() && ((ItemStack)this.items.get(3)).m_41773_() < 100;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"zombiekit.container.vacuum_packaging_machine");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new VacuumPackagingMachineMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(this.m_58899_()), this.dataAccess);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        if (direction == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return SLOTS_FOR_SIDES;
    }

    public boolean m_7013_(int id, ItemStack itemStack) {
        if (id == 0) {
            return itemStack.m_41614_() && RotManager.canBeRotten((ItemStack)itemStack) && !RotManager.isWarped((ItemStack)itemStack);
        }
        if (id == 1) {
            return false;
        }
        if (id == 2) {
            return itemStack.m_41720_() == ZombieKitItems.PLASTIC_BAG.get();
        }
        return itemStack.m_41720_() == ZombieKitItems.BATTERY.get();
    }

    public boolean m_7155_(int id, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(id, itemStack);
    }

    public boolean m_7157_(int id, ItemStack itemStack, Direction direction) {
        if (direction == Direction.DOWN) {
            if (id == 1) {
                return true;
            }
            return id == 3 && itemStack.m_41773_() >= 100;
        }
        return false;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int id) {
        if (id > 3 || id < 0) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(id);
    }

    public ItemStack m_7407_(int slotId, int count) {
        return ContainerHelper.m_18969_(this.items, (int)slotId, (int)count);
    }

    public ItemStack m_8016_(int slotId) {
        return ContainerHelper.m_18966_(this.items, (int)slotId);
    }

    public void m_6836_(int id, ItemStack itemStack) {
        this.items.set(id, (Object)itemStack);
        if (itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlers[facing.ordinal()].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void m_7651_() {
        super.m_7651_();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }
}

