/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.block.entity;

import com.scarasol.zombiekit.block.ShortwaveRadioBlock;
import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.init.ZombieKitBlockEntities;
import com.scarasol.zombiekit.init.ZombieKitSounds;
import com.scarasol.zombiekit.init.ZombieKitTags;
import com.scarasol.zombiekit.inventory.ShortwaveRadioMenu;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ShortwaveRadioBlockEntity
extends BlockEntity
implements MenuProvider {
    private BlockPos currentPos;
    private int times;
    private final Map<Mob, BlockPos> survivorsNeedMove = new HashMap<Mob, BlockPos>();

    public ShortwaveRadioBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)ZombieKitBlockEntities.SHORTWAVE_RADIO.get(), position, state);
    }

    public void setContent(String content) {
        this.getPersistentData().m_128359_("Content", content);
    }

    public String getContent() {
        String content = this.getPersistentData().m_128461_("Content");
        if ("".equals(content)) {
            content = Component.m_237110_((String)"zombiekit.message.response1", (Object[])new Object[]{this.m_58899_().m_123341_(), this.m_58899_().m_123343_()}).getString();
        }
        return content;
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_("Time", this.times);
    }

    public void m_142466_(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("Time")) {
            this.times = compoundTag.m_128451_("Time");
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.zombiekit.shortwave_radio");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ShortwaveRadioMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(this.m_58899_()));
    }

    public void clearTime() {
        this.times = 0;
        this.m_6596_();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState blockState, ShortwaveRadioBlockEntity blockEntity) {
        if (((Boolean)blockState.m_61143_((Property)ShortwaveRadioBlock.TURN_ON)).booleanValue()) {
            if (level.m_46467_() % 20L == 0L) {
                level.m_5594_(null, pos, (SoundEvent)ZombieKitSounds.radio_static.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                int time = blockEntity.times;
                RandomSource random = level.f_46441_;
                if (level.m_46861_(pos) && level.m_46461_() && !level.m_6106_().m_6534_()) {
                    if (time < 600) {
                        if (random.m_188500_() < 1.0E-6 * (double)time && blockEntity.spawnSurvivors(level, pos, random)) {
                            blockEntity.times = 0;
                        }
                        ++blockEntity.times;
                    } else if (time < 1200) {
                        if (random.m_188500_() < 6.0E-4 + 1.5E-5 * (double)(time - 600) && blockEntity.spawnSurvivors(level, pos, random)) {
                            blockEntity.times = 0;
                        }
                        ++blockEntity.times;
                    } else if (random.m_188500_() < 0.01 && blockEntity.spawnSurvivors(level, pos, random)) {
                        blockEntity.times = 0;
                    }
                }
                blockEntity.m_6596_();
            }
            if (blockEntity.currentPos == null) {
                blockEntity.currentPos = pos;
            } else if (!blockEntity.currentPos.equals((Object)pos)) {
                ShortwaveRadioBlock.removeRadio(blockEntity.currentPos, level);
                ShortwaveRadioBlock.addRadio(pos, level);
                blockEntity.currentPos = pos;
            }
        }
        blockEntity.moveSurvivors();
    }

    public boolean spawnSurvivors(Level level, BlockPos pos, RandomSource random) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        for (int index0 = 0; index0 < 100; ++index0) {
            int dr = Mth.m_216271_((RandomSource)random, (int)48, (int)64);
            int dx = Mth.m_216271_((RandomSource)random, (int)0, (int)dr);
            int dz = dr -= dx;
            int tx = Mth.m_216271_((RandomSource)random, (int)1, (int)2) == 1 ? x + dx : x - dx;
            int tz = Mth.m_216271_((RandomSource)random, (int)1, (int)2) == 1 ? z + dz : z - dz;
            BlockPos spawnPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(tx, y, tz));
            BlockState blockState = level.m_8055_(spawnPos);
            BlockState blockState2 = level.m_8055_(spawnPos.m_7495_());
            if (!NaturalSpawner.m_47056_((BlockGetter)level, (BlockPos)spawnPos, (BlockState)blockState, (FluidState)blockState.m_60819_(), (EntityType)EntityType.f_20513_) && blockState2.m_60643_((BlockGetter)level, spawnPos.m_7495_(), EntityType.f_20492_)) continue;
            if (this.spawnPillagers((ServerLevel)level, pos, spawnPos, random)) {
                return true;
            }
            Entity entity = ((EntityType)ForgeRegistries.ENTITY_TYPES.tags().getTag(ZombieKitTags.SURVIVORS).getRandomElement(random).get()).m_262496_((ServerLevel)level, spawnPos, MobSpawnType.REINFORCEMENT);
            if (entity instanceof Mob) {
                Mob _living = (Mob)entity;
                this.survivorsNeedMove.put(_living, pos);
            }
            return true;
        }
        return false;
    }

    public boolean spawnPillagers(ServerLevel level, BlockPos radioPos, BlockPos spawnPos, RandomSource random) {
        if (level.m_46791_() != Difficulty.PEACEFUL && random.m_188500_() < (Double)CommonConfig.ILLAGER_CHANCE.get()) {
            for (int i = 0; i < (Integer)CommonConfig.ILLAGER_NUMBER.get(); ++i) {
                PatrollingMonster patrollingMonster = random.m_188500_() < (Double)CommonConfig.VINDICATOR_CHANCE.get() ? (PatrollingMonster)EntityType.f_20493_.m_20615_((Level)level) : (PatrollingMonster)EntityType.f_20513_.m_20615_((Level)level);
                if (i == 0) {
                    patrollingMonster.m_33075_(true);
                    patrollingMonster.m_33070_(radioPos);
                }
                patrollingMonster.m_6034_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
                patrollingMonster.m_6518_((ServerLevelAccessor)level, level.m_6436_(radioPos), MobSpawnType.PATROL, null, null);
                level.m_47205_((Entity)patrollingMonster);
            }
            return true;
        }
        return false;
    }

    public void moveSurvivors() {
        if (!this.survivorsNeedMove.isEmpty()) {
            for (Map.Entry<Mob, BlockPos> survivor : this.survivorsNeedMove.entrySet()) {
                int x = survivor.getValue().m_123341_();
                int y = survivor.getValue().m_123342_();
                int z = survivor.getValue().m_123343_();
                Mob mob = survivor.getKey();
                mob.m_21573_().m_26519_((double)x, (double)y, (double)z, 0.8);
            }
            this.survivorsNeedMove.clear();
        }
    }
}

