/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.block.entity;

import com.scarasol.zombiekit.entity.mechanics.MortarEntity;
import com.scarasol.zombiekit.init.ZombieKitBlockEntities;
import com.scarasol.zombiekit.init.ZombieKitItems;
import com.scarasol.zombiekit.inventory.MortarRackMenu;
import com.scarasol.zombiekit.item.projectile.MortarShell;
import io.netty.buffer.Unpooled;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MortarRackBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
GeoBlockEntity {
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)10, (Object)ItemStack.f_41583_);
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};

    public MortarRackBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ZombieKitBlockEntities.MORTAR_RACK.get(), blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState blockState, MortarRackBlockEntity blockEntity) {
        level.m_6443_(MortarEntity.class, new AABB(pos).m_82400_(16.0), mortarEntity -> !mortarEntity.m_20197_().isEmpty() && !(mortarEntity.m_20197_().get(0) instanceof Player) && mortarEntity.getRack() == null).forEach(mortarEntity -> mortarEntity.setRack(pos));
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
    }

    public ItemStack popShell() {
        AtomicReference<ItemStack> shell = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        this.items.stream().filter(itemStack -> itemStack.m_41720_() instanceof MortarShell).findFirst().ifPresent(itemStack -> {
            shell.set(itemStack.m_41777_());
            itemStack.m_41774_(1);
        });
        return shell.get();
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.zombiekit.mortar_rack");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new MortarRackMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(this.m_58899_()));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public int[] m_7071_(Direction direction) {
        return SLOTS;
    }

    public boolean m_7013_(int id, ItemStack itemStack) {
        if (id != 9) {
            return itemStack.m_41720_() instanceof MortarShell;
        }
        return itemStack.m_150930_((Item)ZombieKitItems.SHOOTING_PARAMETER.get());
    }

    public boolean m_7155_(int id, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(id, itemStack);
    }

    public boolean m_7157_(int id, ItemStack itemStack, Direction direction) {
        return id != 9;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean isNoShell() {
        for (ItemStack itemstack : this.items) {
            if (!(itemstack.m_41720_() instanceof MortarShell)) continue;
            return false;
        }
        return true;
    }

    public boolean hasTable() {
        return !((ItemStack)this.items.get(9)).m_41619_();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int id) {
        if (id > 9 || id < 0) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(id);
    }

    public ItemStack m_7407_(int slotId, int count) {
        return ContainerHelper.m_18969_(this.items, (int)slotId, (int)count);
    }

    public ItemStack m_8016_(int slotId) {
        return ContainerHelper.m_18966_(this.items, (int)slotId);
    }

    public void m_6836_(int id, ItemStack itemStack) {
        this.items.set(id, (Object)itemStack);
        if (itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlers[facing.ordinal()].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void m_7651_() {
        super.m_7651_();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

