/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.block;

import com.scarasol.zombiekit.config.CommonConfig;
import com.scarasol.zombiekit.entity.mechanics.Mechanics;
import com.scarasol.zombiekit.init.ZombieKitItems;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class UltraWidebandRadarBlock
extends Block {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final BooleanProperty RADAR_OPEN = BooleanProperty.m_61465_((String)"radar_open");
    public static final IntegerProperty RADAR_ELE = IntegerProperty.m_61631_((String)"radar_ele", (int)1, (int)5);
    public static final IntegerProperty RADAR_POWER = IntegerProperty.m_61631_((String)"radar_power", (int)0, (int)101);

    public UltraWidebandRadarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)RADAR_OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RADAR_ELE, (Comparable)Integer.valueOf(5))).m_61124_((Property)RADAR_POWER, (Comparable)Integer.valueOf(0)));
    }

    public void m_5871_(ItemStack itemstack, BlockGetter world, List<Component> list, TooltipFlag flag) {
        super.m_5871_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"block.zombiekit.uwr.description_1"));
        list.add((Component)Component.m_237115_((String)"block.zombiekit.uwr.description_2"));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{RADAR_OPEN});
        builder.m_61104_(new Property[]{RADAR_ELE});
        builder.m_61104_(new Property[]{RADAR_POWER});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.m_49635_(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        if ((Integer)state.m_61143_((Property)RADAR_POWER) > 0) {
            ItemStack itemStack = new ItemStack((ItemLike)ZombieKitItems.BATTERY.get(), 1);
            itemStack.m_41721_(101 - (Integer)state.m_61143_((Property)RADAR_POWER));
            return Arrays.asList(new ItemStack((ItemLike)this, 1), itemStack);
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    public void m_6807_(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        world.m_186460_(pos, (Block)this, ((Integer)CommonConfig.RADAR_POWER.get()).intValue());
    }

    public void m_213897_(BlockState blockState, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(blockState, world, pos, random);
        if ((Integer)blockState.m_61143_((Property)RADAR_POWER) <= 1) {
            world.m_7731_(pos, (BlockState)((BlockState)blockState.m_61124_((Property)RADAR_OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RADAR_ELE, (Comparable)Integer.valueOf(this.updateEle((Integer)blockState.m_61143_((Property)RADAR_POWER)))), 3);
            return;
        }
        if (((Boolean)blockState.m_61143_((Property)RADAR_OPEN)).booleanValue()) {
            this.highLightEntity(blockState, world, pos);
            int power = (Integer)blockState.m_61143_((Property)RADAR_POWER);
            world.m_7731_(pos, (BlockState)((BlockState)blockState.m_61124_((Property)RADAR_POWER, (Comparable)Integer.valueOf(Math.max(1, power - 1)))).m_61124_((Property)RADAR_ELE, (Comparable)Integer.valueOf(this.updateEle(Math.max(1, power - 1)))), 3);
        }
        world.m_186460_(pos, (Block)this, ((Integer)CommonConfig.RADAR_POWER.get()).intValue());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> UltraWidebandRadarBlock.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)6.0);
            case Direction.NORTH -> UltraWidebandRadarBlock.m_49796_((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)14.0, (double)16.0);
            case Direction.EAST -> UltraWidebandRadarBlock.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)6.0, (double)14.0, (double)14.0);
            case Direction.WEST -> UltraWidebandRadarBlock.m_49796_((double)10.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
            case Direction.UP -> UltraWidebandRadarBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
            case Direction.DOWN -> UltraWidebandRadarBlock.m_49796_((double)2.0, (double)10.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        };
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public void highLightEntity(BlockState blockState, ServerLevel world, BlockPos pos) {
        int range = (Integer)CommonConfig.RADAR_RANGE.get();
        BlockPos blockPos = switch ((Direction)blockState.m_61143_((Property)FACING)) {
            case Direction.UP -> pos.m_6625_(range / 2);
            case Direction.WEST -> pos.m_122030_(range / 2);
            case Direction.EAST -> pos.m_122025_(range / 2);
            case Direction.NORTH -> pos.m_122020_(range / 2);
            case Direction.SOUTH -> pos.m_122013_(range / 2);
            default -> pos.m_6630_(range / 2);
        };
        Vec3 _center = new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        List entFound = world.m_6443_(LivingEntity.class, new AABB(_center, _center).m_82400_((double)range), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).collect(Collectors.toList());
        block11: for (LivingEntity entityIterator : entFound) {
            if (entityIterator instanceof ArmorStand || entityIterator instanceof Mechanics) continue;
            switch ((Direction)blockState.m_61143_((Property)FACING)) {
                case EAST: 
                case WEST: {
                    if (!(Math.abs(entityIterator.m_20186_() - (double)blockPos.m_123342_()) > 8.0) && !(Math.abs(entityIterator.m_20189_() - (double)blockPos.m_123343_()) > 8.0)) break;
                    continue block11;
                }
                case NORTH: 
                case SOUTH: {
                    if (!(Math.abs(entityIterator.m_20186_() - (double)blockPos.m_123342_()) > 8.0) && !(Math.abs(entityIterator.m_20185_() - (double)blockPos.m_123341_()) > 8.0)) break;
                    continue block11;
                }
                default: {
                    if (Math.abs(entityIterator.m_20189_() - (double)blockPos.m_123343_()) > 8.0 || Math.abs(entityIterator.m_20185_() - (double)blockPos.m_123341_()) > 8.0) continue block11;
                }
            }
            entityIterator.m_7292_(new MobEffectInstance(MobEffects.f_19619_, (Integer)CommonConfig.RADAR_POWER.get() + 10, 0, false, false));
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos pos, Player entity, InteractionHand hand, BlockHitResult hit) {
        super.m_6227_(blockState, world, pos, entity, hand, hit);
        if ((Integer)blockState.m_61143_((Property)RADAR_POWER) < 1 && entity.m_21206_().m_41720_() == ZombieKitItems.WRENCH.get() && entity.m_21205_().m_41720_() == ZombieKitItems.BATTERY.get()) {
            world.m_7731_(pos, (BlockState)((BlockState)blockState.m_61124_((Property)RADAR_POWER, (Comparable)Integer.valueOf(101 - entity.m_21205_().m_41773_()))).m_61124_((Property)RADAR_ELE, (Comparable)Integer.valueOf(this.updateEle(101 - entity.m_21205_().m_41773_()))), 3);
            if (!entity.m_7500_()) {
                entity.m_21205_().m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if ((Integer)blockState.m_61143_((Property)RADAR_POWER) > 0 && entity.m_21206_().m_41720_() == ZombieKitItems.WRENCH.get()) {
            ItemStack itemStack = new ItemStack((ItemLike)ZombieKitItems.BATTERY.get(), 1);
            itemStack.m_41721_(101 - (Integer)blockState.m_61143_((Property)RADAR_POWER));
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), itemStack);
            itemEntity.m_32010_(10);
            world.m_7967_((Entity)itemEntity);
            world.m_7731_(pos, (BlockState)((BlockState)blockState.m_61124_((Property)RADAR_POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)RADAR_ELE, (Comparable)Integer.valueOf(this.updateEle(0))), 3);
            return InteractionResult.SUCCESS;
        }
        if ((Integer)blockState.m_61143_((Property)RADAR_POWER) > 1) {
            world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)RADAR_OPEN, (Comparable)Boolean.valueOf((Boolean)blockState.m_61143_((Property)RADAR_OPEN) == false)), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int updateEle(int power) {
        if (power <= 1) {
            return 5;
        }
        if (power < 26) {
            return 4;
        }
        if (power < 51) {
            return 3;
        }
        if (power < 76) {
            return 2;
        }
        return 1;
    }
}

