/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.zombiekit.block;

import com.scarasol.zombiekit.block.entity.ShortwaveRadioBlockEntity;
import com.scarasol.zombiekit.init.ZombieKitBlockEntities;
import com.scarasol.zombiekit.init.ZombieKitBlocks;
import com.scarasol.zombiekit.init.ZombieKitSounds;
import com.scarasol.zombiekit.network.MapVariables;
import com.scarasol.zombiekit.network.NetworkHandler;
import com.scarasol.zombiekit.network.SyncBlockPacket;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ShortwaveRadioBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty TURN_ON = BooleanProperty.m_61465_((String)"turn_on");
    public static final IntegerProperty TIME = IntegerProperty.m_61631_((String)"time", (int)0, (int)1);
    private static final Map<Level, Set<BlockPos>> workRadios = new HashMap<Level, Set<BlockPos>>();

    public ShortwaveRadioBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TIME, (Comparable)Integer.valueOf(0))).m_61124_((Property)TURN_ON, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return ShortwaveRadioBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShortwaveRadioBlockEntity(pos, state);
    }

    public void m_5871_(ItemStack itemstack, BlockGetter world, List<Component> list, TooltipFlag flag) {
        super.m_5871_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"block.zombiekit.shortwave_radio.description_1"));
        list.add((Component)Component.m_237115_((String)"block.zombiekit.shortwave_radio.description_2"));
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        super.m_6227_(blockState, level, pos, player, hand, hit);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncBlockPacket(0, pos, ((ShortwaveRadioBlockEntity)level.m_7702_(pos)).getContent()));
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this.m_7246_(blockState, level, pos), (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public static BlockPos findNearestRadio(BlockPos pos, Level world) {
        Set<BlockPos> levelRadios = ShortwaveRadioBlock.getLevelRadios(world);
        if (levelRadios.size() == 0) {
            return null;
        }
        BlockPos nearest = null;
        int nearestDistance = Integer.MAX_VALUE;
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        for (BlockPos radio : levelRadios) {
            if (world.m_8055_(radio).m_60734_() != ZombieKitBlocks.SHORTWAVE_RADIO.get()) {
                ShortwaveRadioBlock.removeRadio(radio, world);
                continue;
            }
            int distance = Math.abs(x - radio.m_123341_()) + Math.abs(z - radio.m_123343_());
            if (distance >= nearestDistance) continue;
            nearestDistance = distance;
            nearest = radio;
        }
        return nearest;
    }

    public static void saveRadioString(Level world) {
        Object workRadioToString = "";
        Set<BlockPos> levelRadios = ShortwaveRadioBlock.getLevelRadios(world);
        if (levelRadios.size() != 0) {
            for (BlockPos pos : levelRadios) {
                String buffer = pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_() + ";";
                workRadioToString = (String)workRadioToString + buffer;
            }
        }
        MapVariables.get((LevelAccessor)world).radio_location = workRadioToString;
        MapVariables.get((LevelAccessor)world).syncData((LevelAccessor)world);
    }

    public static void loadRadioString(LevelAccessor world) {
        String workRadioToString = MapVariables.get((LevelAccessor)world).radio_location;
        if ("\"\"".equals(workRadioToString)) {
            workRadioToString = "";
        }
        if (!"".equals(workRadioToString)) {
            HashSet<BlockPos> levelRadios = new HashSet<BlockPos>();
            for (String posStr : workRadioToString.split(";")) {
                String[] pos = posStr.split(",");
                levelRadios.add(new BlockPos(Integer.parseInt(pos[0]), Integer.parseInt(pos[1]), Integer.parseInt(pos[2])));
            }
            workRadios.put((Level)world, levelRadios);
        }
    }

    public static void addRadio(BlockPos pos, Level world) {
        ShortwaveRadioBlock.getLevelRadios(world).add(pos);
        ShortwaveRadioBlock.saveRadioString(world);
    }

    public static void removeRadio(BlockPos pos, Level world) {
        ShortwaveRadioBlock.getLevelRadios(world).remove(pos);
        ShortwaveRadioBlock.saveRadioString(world);
    }

    public static boolean hasRadio(BlockPos pos, Level world) {
        return ShortwaveRadioBlock.getLevelRadios(world).contains(pos);
    }

    public static Set<BlockPos> getLevelRadios(Level world) {
        if (!workRadios.containsKey(world)) {
            workRadios.put(world, new HashSet());
        }
        return workRadios.get(world);
    }

    public void m_6861_(BlockState blockstate, Level world, BlockPos pos, Block block, BlockPos blockPos2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = world.m_276867_(pos) || world.m_276867_(pos.m_7494_());
        if (!bl2 && ((Boolean)blockstate.m_61143_((Property)TURN_ON)).booleanValue()) {
            ShortwaveRadioBlock.removeRadio(pos, world);
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof ShortwaveRadioBlockEntity) {
                ShortwaveRadioBlockEntity blockEntity2 = (ShortwaveRadioBlockEntity)blockEntity;
                blockEntity2.clearTime();
            }
            world.m_7731_(pos, (BlockState)blockstate.m_61124_((Property)TURN_ON, (Comparable)Boolean.valueOf(false)), 3);
        } else if (bl2 && !((Boolean)blockstate.m_61143_((Property)TURN_ON)).booleanValue()) {
            ShortwaveRadioBlock.addRadio(pos, world);
            world.m_7731_(pos, (BlockState)blockstate.m_61124_((Property)TURN_ON, (Comparable)Boolean.valueOf(true)), 3);
            world.m_5594_(null, pos, (SoundEvent)ZombieKitSounds.radio_static.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_6807_(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        world.m_186460_(pos, (Block)this, 20);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            if (((Boolean)state.m_61143_((Property)TURN_ON)).booleanValue()) {
                ShortwaveRadioBlock.removeRadio(pos, world);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        } else if (((Boolean)state.m_61143_((Property)TURN_ON)).booleanValue() && !((Boolean)newState.m_61143_((Property)TURN_ON)).booleanValue()) {
            ShortwaveRadioBlock.removeRadio(pos, world);
        }
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{TURN_ON});
        builder.m_61104_(new Property[]{TIME});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43725_().m_276867_(context.m_8083_()) || context.m_43725_().m_276867_(context.m_8083_().m_7494_())) {
            ShortwaveRadioBlock.addRadio(context.m_8083_(), context.m_43725_());
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)TURN_ON, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)TURN_ON, (Comparable)Boolean.valueOf(false));
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        Item item = player.m_150109_().m_36056_().m_41720_();
        if (item instanceof PickaxeItem) {
            PickaxeItem tieredItem = (PickaxeItem)item;
            return tieredItem.m_43314_().m_6604_() >= 1;
        }
        return false;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.m_49635_(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createShortwaveRadioTicker(Level level, BlockEntityType<T> blockEntityType1, BlockEntityType<? extends ShortwaveRadioBlockEntity> blockEntityType2) {
        return level.f_46443_ ? null : ShortwaveRadioBlock.m_152132_(blockEntityType1, blockEntityType2, ShortwaveRadioBlockEntity::serverTick);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return ShortwaveRadioBlock.createShortwaveRadioTicker(level, blockEntityType, (BlockEntityType<? extends ShortwaveRadioBlockEntity>)((BlockEntityType)ZombieKitBlockEntities.SHORTWAVE_RADIO.get()));
    }
}

